/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.money.BankersRounding;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferOfferRuleXref;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.FulfillmentGroupOfferPotential;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.FulfillmentGroupOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.springframework.stereotype.Service;

@Service(value="blFulfillmentGroupOfferProcessor")
public class FulfillmentGroupOfferProcessorImpl
extends OrderOfferProcessorImpl
implements FulfillmentGroupOfferProcessor {
    @Override
    public void filterFulfillmentGroupLevelOffer(PromotableOrder order, List<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers, Offer offer) {
        for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            boolean fgLevelQualification = false;
            if (this.couldOfferApplyToOrder(offer, order, fulfillmentGroup)) {
                fgLevelQualification = true;
            } else {
                for (PromotableOrderItem discreteOrderItem : order.getAllOrderItems()) {
                    if (!this.couldOfferApplyToOrder(offer, order, discreteOrderItem, fulfillmentGroup)) continue;
                    fgLevelQualification = true;
                    break;
                }
            }
            if (fgLevelQualification) {
                fgLevelQualification = false;
                if (this.couldOfferApplyToFulfillmentGroup(offer, fulfillmentGroup)) {
                    fgLevelQualification = true;
                }
            }
            if (!fgLevelQualification) continue;
            CandidatePromotionItems candidates = this.couldOfferApplyToOrderItems(offer, fulfillmentGroup.getDiscountableOrderItems());
            if (!candidates.isMatchedQualifier() && this.getQualifyGroupAcrossAllOrderItems(fulfillmentGroup)) {
                candidates = this.couldOfferApplyToOrderItems(offer, order.getAllOrderItems());
            }
            if (!candidates.isMatchedQualifier()) continue;
            PromotableCandidateFulfillmentGroupOffer candidateOffer = this.createCandidateFulfillmentGroupOffer(offer, qualifiedFGOffers, fulfillmentGroup);
            candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
        }
    }

    protected boolean getQualifyGroupAcrossAllOrderItems(PromotableFulfillmentGroup fg) {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"promotion.fulfillmentgroup.qualifyAcrossAllOrderItems", (boolean)false);
    }

    @Override
    public void calculateFulfillmentGroupTotal(PromotableOrder order) {
        Money totalFulfillmentCharges = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getOrderCurrency());
        Iterator<PromotableFulfillmentGroup> iterator = order.getFulfillmentGroups().iterator();
        while (iterator.hasNext()) {
            PromotableFulfillmentGroup fulfillmentGroupMember;
            PromotableFulfillmentGroup fulfillmentGroup = fulfillmentGroupMember = iterator.next();
            Money fulfillmentCharges = fulfillmentGroup.getFinalizedPriceWithAdjustments();
            fulfillmentGroup.getFulfillmentGroup().setFulfillmentPrice(fulfillmentCharges);
            totalFulfillmentCharges = totalFulfillmentCharges.add(fulfillmentCharges);
        }
        order.setTotalFufillmentCharges(totalFulfillmentCharges);
    }

    protected boolean couldOfferApplyToFulfillmentGroup(Offer offer, PromotableFulfillmentGroup fulfillmentGroup) {
        boolean appliesToItem = false;
        OfferRule rule = null;
        OfferOfferRuleXref ruleXref = offer.getOfferMatchRulesXref().get(OfferRuleType.FULFILLMENT_GROUP.getType());
        if (ruleXref != null && ruleXref.getOfferRule() != null) {
            rule = ruleXref.getOfferRule();
        }
        if (rule != null && rule.getMatchRule() != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            fulfillmentGroup.updateRuleVariables(vars);
            Boolean expressionOutcome = this.executeExpression(rule.getMatchRule(), vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    protected PromotableCandidateFulfillmentGroupOffer createCandidateFulfillmentGroupOffer(Offer offer, List<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers, PromotableFulfillmentGroup fulfillmentGroup) {
        PromotableCandidateFulfillmentGroupOffer promotableCandidateFulfillmentGroupOffer = this.promotableItemFactory.createPromotableCandidateFulfillmentGroupOffer(fulfillmentGroup, offer);
        qualifiedFGOffers.add(promotableCandidateFulfillmentGroupOffer);
        return promotableCandidateFulfillmentGroupOffer;
    }

    @Override
    public boolean applyAllFulfillmentGroupOffers(List<PromotableCandidateFulfillmentGroupOffer> qualifiedFGOffers, PromotableOrder order) {
        boolean bl;
        HashMap offerMap = new HashMap();
        for (PromotableCandidateFulfillmentGroupOffer promotableCandidateFulfillmentGroupOffer : qualifiedFGOffers) {
            FulfillmentGroupOfferPotential potential = new FulfillmentGroupOfferPotential();
            potential.setOffer(promotableCandidateFulfillmentGroupOffer.getOffer());
            if (offerMap.get(potential) == null) {
                offerMap.put(potential, new ArrayList());
            }
            ((List)offerMap.get(potential)).add(promotableCandidateFulfillmentGroupOffer);
        }
        List<FulfillmentGroupOfferPotential> potentials = new ArrayList<FulfillmentGroupOfferPotential>();
        for (FulfillmentGroupOfferPotential potential : offerMap.keySet()) {
            List fgOffers = (List)offerMap.get(potential);
            Collections.sort(fgOffers, new ReverseComparator((Comparator)new BeanComparator("discountedAmount", (Comparator)new NullComparator())));
            Collections.sort(fgOffers, new BeanComparator("priority", (Comparator)new NullComparator()));
            if (potential.getOffer().isLimitedUsePerOrder() && fgOffers.size() > potential.getOffer().getMaxUsesPerOrder()) {
                for (int j = potential.getOffer().getMaxUsesPerOrder(); j < fgOffers.size(); ++j) {
                    fgOffers.remove(j);
                }
            }
            for (PromotableCandidateFulfillmentGroupOffer candidate : fgOffers) {
                if (potential.getTotalSavings().getAmount().equals(BankersRounding.zeroAmount())) {
                    BroadleafCurrency currency = order.getOrderCurrency();
                    if (currency != null) {
                        potential.setTotalSavings(new Money(BigDecimal.ZERO, currency.getCurrencyCode()));
                    } else {
                        potential.setTotalSavings(new Money(BigDecimal.ZERO));
                    }
                }
                Money priceBeforeAdjustments = candidate.getFulfillmentGroup().calculatePriceWithoutAdjustments();
                Money discountedPrice = candidate.getDiscountedPrice();
                potential.setTotalSavings(potential.getTotalSavings().add(priceBeforeAdjustments.subtract(discountedPrice)));
                potential.setPriority(candidate.getOffer().getPriority());
            }
            potentials.add(potential);
        }
        Collections.sort(potentials, new BeanComparator("totalSavings", Collections.reverseOrder()));
        Collections.sort(potentials, new BeanComparator("priority"));
        potentials = this.removeTrailingNotCombinableFulfillmentGroupOffers(potentials);
        boolean bl2 = false;
        for (FulfillmentGroupOfferPotential potential : potentials) {
            Offer offer = potential.getOffer();
            boolean alreadyContainsTotalitarianOffer = order.isTotalitarianOfferApplied();
            List candidates = (List)offerMap.get(potential);
            for (PromotableCandidateFulfillmentGroupOffer candidate : candidates) {
                this.applyFulfillmentGroupOffer(candidate.getFulfillmentGroup(), candidate);
                bl = true;
            }
            for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
                fg.chooseSaleOrRetailAdjustments();
            }
            if (!(offer.isTotalitarianOffer() != null && offer.isTotalitarianOffer() != false || alreadyContainsTotalitarianOffer ? (bl = this.compareAndAdjustFulfillmentGroupOffers(order, bl)) : !offer.isCombinableWithOtherOffers())) continue;
            break;
        }
        return bl;
    }

    protected boolean compareAndAdjustFulfillmentGroupOffers(PromotableOrder order, boolean fgOfferApplied) {
        Money regularOrderDiscountShippingTotal = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getOrderCurrency());
        regularOrderDiscountShippingTotal = regularOrderDiscountShippingTotal.add(order.calculateSubtotalWithoutAdjustments());
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            regularOrderDiscountShippingTotal = regularOrderDiscountShippingTotal.add(fg.getFinalizedPriceWithAdjustments());
        }
        Money discountOrderRegularShippingTotal = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)order.getOrderCurrency());
        discountOrderRegularShippingTotal = discountOrderRegularShippingTotal.add(order.calculateSubtotalWithAdjustments());
        for (PromotableFulfillmentGroup fg : order.getFulfillmentGroups()) {
            discountOrderRegularShippingTotal = discountOrderRegularShippingTotal.add(fg.calculatePriceWithoutAdjustments());
        }
        if (discountOrderRegularShippingTotal.lessThan(regularOrderDiscountShippingTotal)) {
            order.removeAllCandidateFulfillmentOfferAdjustments();
            fgOfferApplied = false;
        } else {
            order.removeAllCandidateOrderOfferAdjustments();
            order.removeAllCandidateItemOfferAdjustments();
            order.getOrder().setSubTotal(order.calculateSubtotalWithAdjustments());
        }
        return fgOfferApplied;
    }

    protected void applyFulfillmentGroupOffer(PromotableFulfillmentGroup promotableFulfillmentGroup, PromotableCandidateFulfillmentGroupOffer fulfillmentGroupOffer) {
        if (promotableFulfillmentGroup.canApplyOffer(fulfillmentGroupOffer)) {
            PromotableFulfillmentGroupAdjustment promotableFulfillmentGroupAdjustment = this.promotableItemFactory.createPromotableFulfillmentGroupAdjustment(fulfillmentGroupOffer, promotableFulfillmentGroup);
            promotableFulfillmentGroup.addCandidateFulfillmentGroupAdjustment(promotableFulfillmentGroupAdjustment);
        }
    }

    @Override
    public List<FulfillmentGroupOfferPotential> removeTrailingNotCombinableFulfillmentGroupOffers(List<FulfillmentGroupOfferPotential> candidateOffers) {
        ArrayList<FulfillmentGroupOfferPotential> remainingCandidateOffers = new ArrayList<FulfillmentGroupOfferPotential>();
        int offerCount = 0;
        for (FulfillmentGroupOfferPotential candidateOffer : candidateOffers) {
            if (offerCount == 0) {
                remainingCandidateOffers.add(candidateOffer);
            } else {
                boolean treatAsNewFormat = false;
                if (candidateOffer.getOffer().getTreatAsNewFormat() != null && candidateOffer.getOffer().getTreatAsNewFormat().booleanValue()) {
                    treatAsNewFormat = true;
                }
                if (!treatAsNewFormat && candidateOffer.getOffer().isCombinableWithOtherOffers() || treatAsNewFormat && (candidateOffer.getOffer().isTotalitarianOffer() == null || !candidateOffer.getOffer().isTotalitarianOffer().booleanValue())) {
                    remainingCandidateOffers.add(candidateOffer);
                }
            }
            ++offerCount;
        }
        return remainingCandidateOffers;
    }
}

