/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.annotation.Resource;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.RequestDTO;
import org.broadleafcommerce.common.TimeDTO;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.rule.MvelHelper;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferOfferRuleXref;
import org.broadleafcommerce.core.offer.domain.OfferQualifyingCriteriaXref;
import org.broadleafcommerce.core.offer.domain.OfferTargetCriteriaXref;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionManager;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.processor.BaseProcessor;
import org.broadleafcommerce.core.offer.service.processor.OfferTimeZoneProcessor;
import org.broadleafcommerce.core.offer.service.type.OfferRuleType;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.joda.time.LocalDateTime;

public abstract class AbstractBaseProcessor
implements BaseProcessor {
    private static final Log LOG = LogFactory.getLog(AbstractBaseProcessor.class);
    private static final Map EXPRESSION_CACHE = new LRUMap(1000);
    @Resource(name="blOfferTimeZoneProcessor")
    protected OfferTimeZoneProcessor offerTimeZoneProcessor;
    @Resource(name="blOfferServiceExtensionManager")
    protected OfferServiceExtensionManager extensionManager;

    protected CandidatePromotionItems couldOfferApplyToOrderItems(Offer offer, List<PromotableOrderItem> promotableOrderItems) {
        CandidatePromotionItems candidates = new CandidatePromotionItems();
        if (offer.getQualifyingItemCriteriaXref() == null || offer.getQualifyingItemCriteriaXref().size() == 0) {
            candidates.setMatchedQualifier(true);
        } else {
            for (OfferQualifyingCriteriaXref criteriaXref : offer.getQualifyingItemCriteriaXref()) {
                if (criteriaXref.getOfferItemCriteria() == null) continue;
                this.checkForItemRequirements(offer, candidates, criteriaXref.getOfferItemCriteria(), promotableOrderItems, true);
                if (candidates.isMatchedQualifier()) continue;
                break;
            }
        }
        if (offer.getType().equals(OfferType.ORDER_ITEM) && offer.getTargetItemCriteriaXref() != null) {
            for (OfferTargetCriteriaXref xref : offer.getTargetItemCriteriaXref()) {
                this.checkForItemRequirements(offer, candidates, xref.getOfferItemCriteria(), promotableOrderItems, false);
                if (candidates.isMatchedTarget()) continue;
                break;
            }
        }
        if (candidates.isMatchedQualifier() && !this.meetsItemQualifierSubtotal(offer, candidates)) {
            candidates.setMatchedQualifier(false);
        }
        return candidates;
    }

    private boolean isEmpty(Collection<? extends Object> collection) {
        return collection == null || collection.size() == 0;
    }

    private boolean hasPositiveValue(Money money) {
        return money != null && money.greaterThan(Money.ZERO);
    }

    protected boolean meetsItemQualifierSubtotal(Offer offer, CandidatePromotionItems candidateItem) {
        Money qualifyingSubtotal = offer.getQualifyingItemSubTotal();
        if (!this.hasPositiveValue(qualifyingSubtotal)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Offer " + offer.getName() + " does not have an item subtotal requirement."));
            }
            return true;
        }
        if (this.isEmpty(offer.getQualifyingItemCriteriaXref())) {
            if (OfferType.ORDER_ITEM.equals(offer.getType())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Offer " + offer.getName() + " has a subtotal item requirement but no item qualification criteria."));
                }
                return false;
            }
            Money accumulatedTotal = null;
            for (PromotableOrderItem orderItem : candidateItem.getAllCandidateTargets()) {
                Money itemPrice = orderItem.getCurrentBasePrice().multiply(orderItem.getQuantity());
                if (!(accumulatedTotal = accumulatedTotal == null ? itemPrice : accumulatedTotal.add(itemPrice)).greaterThan(qualifyingSubtotal)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Offer " + offer.getName() + " meets qualifying item subtotal."));
                }
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Offer " + offer.getName() + " does not meet qualifying item subtotal."));
            }
        } else if (candidateItem.getCandidateQualifiersMap() != null) {
            Money accumulatedTotal = null;
            HashSet<PromotableOrderItem> usedItems = new HashSet<PromotableOrderItem>();
            for (OfferItemCriteria criteria : candidateItem.getCandidateQualifiersMap().keySet()) {
                List<PromotableOrderItem> promotableItems = candidateItem.getCandidateQualifiersMap().get(criteria);
                if (promotableItems == null) continue;
                for (PromotableOrderItem item : promotableItems) {
                    if (usedItems.contains(item)) continue;
                    usedItems.add(item);
                    Money itemPrice = item.getCurrentBasePrice().multiply(item.getQuantity());
                    if (!(accumulatedTotal = accumulatedTotal == null ? itemPrice : accumulatedTotal.add(itemPrice)).greaterThan(qualifyingSubtotal)) continue;
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Offer " + offer.getName() + " meets the item subtotal requirement."));
                    }
                    return true;
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Offer " + offer.getName() + " does not meet the item subtotal qualifications."));
        }
        return false;
    }

    protected void checkForItemRequirements(Offer offer, CandidatePromotionItems candidates, OfferItemCriteria criteria, List<PromotableOrderItem> promotableOrderItems, boolean isQualifier) {
        boolean matchFound = false;
        int criteriaQuantity = criteria.getQuantity();
        int matchedQuantity = 0;
        if (criteriaQuantity > 0) {
            for (PromotableOrderItem item : promotableOrderItems) {
                if (!this.couldOrderItemMeetOfferRequirement(criteria, item)) continue;
                if (isQualifier) {
                    candidates.addQualifier(criteria, item);
                } else {
                    candidates.addTarget(criteria, item);
                }
                matchedQuantity += item.getQuantity();
            }
            boolean bl = matchFound = matchedQuantity >= criteriaQuantity;
        }
        if (isQualifier) {
            candidates.setMatchedQualifier(matchFound);
        } else {
            candidates.setMatchedTarget(matchFound);
        }
    }

    protected boolean couldOrderItemMeetOfferRequirement(OfferItemCriteria criteria, PromotableOrderItem orderItem) {
        boolean appliesToItem = false;
        if (criteria.getMatchRule() != null && criteria.getMatchRule().trim().length() != 0) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            orderItem.updateRuleVariables(vars);
            Boolean expressionOutcome = this.executeExpression(criteria.getMatchRule(), vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToItem = true;
            }
        } else {
            appliesToItem = true;
        }
        return appliesToItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean executeExpression(String expression, Map<String, Object> vars) {
        Map map = EXPRESSION_CACHE;
        synchronized (map) {
            HashMap<String, Class> contextImports = new HashMap<String, Class>();
            contextImports.put("OfferType", OfferType.class);
            contextImports.put("FulfillmentType", FulfillmentType.class);
            return MvelHelper.evaluateRule((String)expression, vars, (Map)EXPRESSION_CACHE, contextImports);
        }
    }

    protected void clearAllNonFinalizedQuantities(List<PromotableOrderItemPriceDetail> priceDetails) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            priceDetail.clearAllNonFinalizedQuantities();
        }
    }

    protected void finalizeQuantities(List<PromotableOrderItemPriceDetail> priceDetails) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            priceDetail.finalizeQuantities();
        }
    }

    protected void splitDetailsIfNecessary(List<PromotableOrderItemPriceDetail> priceDetails) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            PromotableOrderItemPriceDetail splitDetail = priceDetail.splitIfNecessary();
            if (splitDetail == null) continue;
            priceDetail.getPromotableOrderItem().getPromotableOrderItemPriceDetails().add(splitDetail);
        }
    }

    @Override
    public List<Offer> filterOffers(List<Offer> offers, Customer customer) {
        List<Offer> filteredOffers = new ArrayList<Offer>();
        if (offers != null && !offers.isEmpty()) {
            filteredOffers = this.removeOutOfDateOffers(offers);
            filteredOffers = this.removeTimePeriodOffers(filteredOffers);
            filteredOffers = this.removeInvalidRequestOffers(filteredOffers);
            filteredOffers = this.removeInvalidCustomerOffers(filteredOffers, customer);
        }
        return filteredOffers;
    }

    protected List<Offer> removeInvalidRequestOffers(List<Offer> offers) {
        RequestDTO requestDTO = null;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null) {
            requestDTO = BroadleafRequestContext.getBroadleafRequestContext().getRequestDTO();
        }
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToRequestDTO(offer, requestDTO)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToRequestDTO(Offer offer, RequestDTO requestDTO) {
        boolean appliesToRequestRule = false;
        String rule = null;
        OfferOfferRuleXref ruleXref = offer.getOfferMatchRulesXref().get(OfferRuleType.REQUEST.getType());
        if (ruleXref != null && ruleXref.getOfferRule() != null) {
            rule = ruleXref.getOfferRule().getMatchRule();
        }
        if (rule != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("request", requestDTO);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToRequestRule = true;
            }
        } else {
            appliesToRequestRule = true;
        }
        return appliesToRequestRule;
    }

    protected List<Offer> removeTimePeriodOffers(List<Offer> offers) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToTimePeriod(offer)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToTimePeriod(Offer offer) {
        boolean appliesToTimePeriod = false;
        String rule = null;
        OfferOfferRuleXref ruleXref = offer.getOfferMatchRulesXref().get(OfferRuleType.TIME.getType());
        if (ruleXref != null && ruleXref.getOfferRule() != null) {
            rule = ruleXref.getOfferRule().getMatchRule();
        }
        if (rule != null) {
            TimeZone timeZone = this.getOfferTimeZoneProcessor().getTimeZone(offer);
            TimeDTO timeDto = new TimeDTO(SystemTime.asCalendar((TimeZone)timeZone));
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("time", timeDto);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToTimePeriod = true;
            }
        } else {
            appliesToTimePeriod = true;
        }
        return appliesToTimePeriod;
    }

    protected List<Offer> removeOutOfDateOffers(List<Offer> offers) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            TimeZone timeZone = this.getOfferTimeZoneProcessor().getTimeZone(offer);
            Calendar current = timeZone == null ? SystemTime.asCalendar() : SystemTime.asCalendar((TimeZone)timeZone);
            Calendar start = null;
            if (offer.getStartDate() != null) {
                LocalDateTime startDate = new LocalDateTime((Object)offer.getStartDate());
                start = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
                start.set(1, startDate.getYear());
                start.set(2, startDate.getMonthOfYear() - 1);
                start.set(5, startDate.getDayOfMonth());
                start.set(11, startDate.getHourOfDay());
                start.set(12, startDate.getMinuteOfHour());
                start.set(13, startDate.getSecondOfMinute());
                start.get(11);
                start.get(12);
                if (LOG.isTraceEnabled()) {
                    LOG.debug((Object)("Offer: " + offer.getName() + " timeZone:" + timeZone + " startTime:" + start.getTime() + " currentTime:" + current.getTime()));
                }
            }
            GregorianCalendar end = null;
            if (offer.getEndDate() != null) {
                LocalDateTime endDate = new LocalDateTime((Object)offer.getEndDate());
                end = timeZone == null ? new GregorianCalendar() : new GregorianCalendar(timeZone);
                end.set(1, endDate.getYear());
                end.set(2, endDate.getMonthOfYear() - 1);
                end.set(5, endDate.getDayOfMonth());
                end.set(11, endDate.getHourOfDay());
                end.set(12, endDate.getMinuteOfHour());
                end.set(13, endDate.getSecondOfMinute());
                end.get(11);
                end.get(12);
                if (LOG.isTraceEnabled()) {
                    LOG.debug((Object)("Offer: " + offer.getName() + " endTime:" + start.getTime()));
                }
            }
            if (offer.getStartDate() == null || start.after(current)) {
                offersToRemove.add(offer);
                continue;
            }
            if (offer.getEndDate() == null || !end.before(current)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected List<Offer> removeInvalidCustomerOffers(List<Offer> offers, Customer customer) {
        ArrayList<Offer> offersToRemove = new ArrayList<Offer>();
        for (Offer offer : offers) {
            if (this.couldOfferApplyToCustomer(offer, customer)) continue;
            offersToRemove.add(offer);
        }
        for (Offer offer : offersToRemove) {
            offers.remove(offer);
        }
        return offers;
    }

    protected boolean couldOfferApplyToCustomer(Offer offer, Customer customer) {
        boolean appliesToCustomer = false;
        String rule = null;
        if (!StringUtils.isEmpty((CharSequence)offer.getAppliesToCustomerRules())) {
            rule = offer.getAppliesToCustomerRules();
        } else {
            OfferOfferRuleXref ruleXref = offer.getOfferMatchRulesXref().get(OfferRuleType.CUSTOMER.getType());
            if (ruleXref != null && ruleXref.getOfferRule() != null) {
                rule = ruleXref.getOfferRule().getMatchRule();
            }
        }
        if (rule != null) {
            HashMap<String, Object> vars = new HashMap<String, Object>();
            vars.put("customer", customer);
            Boolean expressionOutcome = this.executeExpression(rule, vars);
            if (expressionOutcome != null && expressionOutcome.booleanValue()) {
                appliesToCustomer = true;
            }
        } else {
            appliesToCustomer = true;
        }
        return appliesToCustomer;
    }

    public OfferTimeZoneProcessor getOfferTimeZoneProcessor() {
        return this.offerTimeZoneProcessor;
    }

    public void setOfferTimeZoneProcessor(OfferTimeZoneProcessor offerTimeZoneProcessor) {
        this.offerTimeZoneProcessor = offerTimeZoneProcessor;
    }
}

