/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemContainer;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;

public class PromotableOrderItemImpl
implements PromotableOrderItem {
    private static final Log LOG = LogFactory.getLog(PromotableOrderItem.class);
    private static final long serialVersionUID = 1L;
    protected PromotableOrder promotableOrder;
    protected OrderItem orderItem;
    protected PromotableItemFactory itemFactory;
    protected List<PromotableOrderItemPriceDetail> itemPriceDetails = new ArrayList<PromotableOrderItemPriceDetail>();
    protected boolean includeAdjustments;
    protected Map<String, Object> extraDataMap = new HashMap<String, Object>();

    public PromotableOrderItemImpl(OrderItem orderItem, PromotableOrder promotableOrder, PromotableItemFactory itemFactory, boolean includeAdjustments) {
        this.orderItem = orderItem;
        this.promotableOrder = promotableOrder;
        this.itemFactory = itemFactory;
        this.includeAdjustments = includeAdjustments;
        this.initializePriceDetails();
    }

    @Override
    public void resetPriceDetails() {
        this.itemPriceDetails.clear();
        this.initializePriceDetails();
    }

    protected void initializePriceDetails() {
        if (this.includeAdjustments) {
            for (OrderItemPriceDetail detail : this.orderItem.getOrderItemPriceDetails()) {
                PromotableOrderItemPriceDetail poid = this.itemFactory.createPromotableOrderItemPriceDetail(this, detail.getQuantity());
                this.itemPriceDetails.add(poid);
                for (OrderItemPriceDetailAdjustment adjustment : detail.getOrderItemPriceDetailAdjustments()) {
                    PromotableOrderItemPriceDetailAdjustmentImpl poidAdj = new PromotableOrderItemPriceDetailAdjustmentImpl(adjustment, poid);
                    poid.addCandidateItemPriceDetailAdjustment(poidAdj);
                }
                poid.chooseSaleOrRetailAdjustments();
                List<OrderItemQualifier> oiqs = poid.getPromotableOrderItem().getOrderItem().getOrderItemQualifiers();
                if (!CollectionUtils.isNotEmpty(oiqs)) continue;
                for (OrderItemQualifier oiq : oiqs) {
                    PromotionQualifier pq = new PromotionQualifier();
                    pq.setPromotion(oiq.getOffer());
                    pq.setQuantity(oiq.getQuantity().intValue());
                    pq.setFinalizedQuantity(oiq.getQuantity().intValue());
                    pq.setPrice(oiq.getOrderItem().getPriceBeforeAdjustments(oiq.getOffer().getApplyDiscountToSalePrice()));
                    poid.getPromotionQualifiers().add(pq);
                }
            }
        } else {
            PromotableOrderItemPriceDetail poid = this.itemFactory.createPromotableOrderItemPriceDetail(this, this.orderItem.getQuantity());
            this.itemPriceDetails.add(poid);
        }
    }

    @Override
    public void updateRuleVariables(Map<String, Object> ruleVars) {
        ruleVars.put("orderItem", this.orderItem);
        ruleVars.put("discreteOrderItem", this.orderItem);
        ruleVars.put("bundleOrderItem", this.orderItem);
    }

    @Override
    public boolean isDiscountingAllowed() {
        return this.orderItem.isDiscountingAllowed();
    }

    @Override
    public boolean isOrderItemContainer() {
        return this.orderItem instanceof OrderItemContainer;
    }

    @Override
    public OrderItemContainer getOrderItemContainer() {
        if (this.orderItem instanceof OrderItemContainer) {
            return (OrderItemContainer)((Object)this.orderItem);
        }
        return null;
    }

    @Override
    public List<PromotableOrderItemPriceDetail> getPromotableOrderItemPriceDetails() {
        return this.itemPriceDetails;
    }

    @Override
    public Money getSalePriceBeforeAdjustments() {
        return this.orderItem.getSalePrice();
    }

    @Override
    public Money getRetailPriceBeforeAdjustments() {
        return this.orderItem.getRetailPrice();
    }

    @Override
    public Money getPriceBeforeAdjustments(boolean applyToSalePrice) {
        if (applyToSalePrice && this.getSalePriceBeforeAdjustments() != null) {
            return this.getSalePriceBeforeAdjustments();
        }
        return this.getRetailPriceBeforeAdjustments();
    }

    @Override
    public Money getCurrentBasePrice() {
        if (this.orderItem.getIsOnSale()) {
            return this.orderItem.getSalePrice();
        }
        return this.orderItem.getRetailPrice();
    }

    @Override
    public int getQuantity() {
        return this.orderItem.getQuantity();
    }

    @Override
    public boolean isOnSale() {
        return this.orderItem.getIsOnSale();
    }

    @Override
    public BroadleafCurrency getCurrency() {
        return this.orderItem.getOrder().getCurrency();
    }

    @Override
    public void removeAllItemAdjustments() {
        Iterator<PromotableOrderItemPriceDetail> detailIterator = this.itemPriceDetails.iterator();
        boolean first = true;
        while (detailIterator.hasNext()) {
            PromotableOrderItemPriceDetail detail = detailIterator.next();
            if (first) {
                detail.setQuantity(this.getQuantity());
                detail.getPromotionDiscounts().clear();
                detail.getPromotionQualifiers().clear();
                detail.removeAllAdjustments();
                first = false;
                continue;
            }
            detailIterator.remove();
        }
    }

    protected void mergeDetails(PromotableOrderItemPriceDetail firstDetail, PromotableOrderItemPriceDetail secondDetail) {
        int firstQty = firstDetail.getQuantity();
        int secondQty = secondDetail.getQuantity();
        if (LOG.isDebugEnabled()) {
            LOG.trace((Object)("Merging priceDetails with quantities " + firstQty + " and " + secondQty));
        }
        firstDetail.setQuantity(firstQty + secondQty);
    }

    @Override
    public void mergeLikeDetails() {
        if (this.itemPriceDetails.size() > 1) {
            Iterator<PromotableOrderItemPriceDetail> detailIterator = this.itemPriceDetails.iterator();
            HashMap<String, PromotableOrderItemPriceDetail> detailMap = new HashMap<String, PromotableOrderItemPriceDetail>();
            while (detailIterator.hasNext()) {
                PromotableOrderItemPriceDetail currentDetail = detailIterator.next();
                String detailKey = currentDetail.buildDetailKey();
                if (detailMap.containsKey(detailKey)) {
                    PromotableOrderItemPriceDetail firstDetail = (PromotableOrderItemPriceDetail)detailMap.get(detailKey);
                    this.mergeDetails(firstDetail, currentDetail);
                    detailIterator.remove();
                    continue;
                }
                detailMap.put(detailKey, currentDetail);
            }
        }
    }

    @Override
    public Long getOrderItemId() {
        return this.orderItem.getId();
    }

    @Override
    public Money calculateTotalWithAdjustments() {
        Money returnTotal = new Money(this.getCurrency());
        for (PromotableOrderItemPriceDetail detail : this.itemPriceDetails) {
            returnTotal = returnTotal.add(detail.getFinalizedTotalWithAdjustments());
        }
        return returnTotal;
    }

    @Override
    public Money calculateTotalWithoutAdjustments() {
        return this.getCurrentBasePrice().multiply(this.orderItem.getQuantity());
    }

    @Override
    public Money calculateTotalAdjustmentValue() {
        Money returnTotal = new Money(this.getCurrency());
        for (PromotableOrderItemPriceDetail detail : this.itemPriceDetails) {
            returnTotal = returnTotal.add(detail.calculateTotalAdjustmentValue());
        }
        return returnTotal;
    }

    @Override
    public PromotableOrderItemPriceDetail createNewDetail(int quantity) {
        if (this.includeAdjustments) {
            throw new RuntimeException("Trying to createNewDetail when adjustments have already been included.");
        }
        return this.itemFactory.createPromotableOrderItemPriceDetail(this, quantity);
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public Map<String, Object> getExtraDataMap() {
        return this.extraDataMap;
    }
}

