/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.discount.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateFulfillmentGroupOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroupAdjustment;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemContainer;

public class PromotableFulfillmentGroupImpl
implements PromotableFulfillmentGroup {
    private static final long serialVersionUID = 1L;
    protected FulfillmentGroup fulfillmentGroup;
    protected PromotableOrder promotableOrder;
    protected PromotableItemFactory itemFactory;
    protected List<PromotableOrderItem> discountableOrderItems;
    protected boolean useSaleAdjustments = false;
    protected Money adjustedPrice;
    public List<PromotableFulfillmentGroupAdjustment> candidateFulfillmentGroupAdjustments = new ArrayList<PromotableFulfillmentGroupAdjustment>();

    public PromotableFulfillmentGroupImpl(FulfillmentGroup fulfillmentGroup, PromotableOrder promotableOrder, PromotableItemFactory itemFactory) {
        this.fulfillmentGroup = fulfillmentGroup;
        this.promotableOrder = promotableOrder;
        this.itemFactory = itemFactory;
    }

    @Override
    public FulfillmentGroup getFulfillmentGroup() {
        return this.fulfillmentGroup;
    }

    @Override
    public void updateRuleVariables(Map<String, Object> ruleVars) {
        ruleVars.put("fulfillmentGroup", this.fulfillmentGroup);
    }

    @Override
    public List<PromotableOrderItem> getDiscountableOrderItems() {
        if (this.discountableOrderItems != null) {
            return this.discountableOrderItems;
        }
        this.discountableOrderItems = new ArrayList<PromotableOrderItem>();
        ArrayList<Long> discountableOrderItemIds = new ArrayList<Long>();
        for (FulfillmentGroupItem fgItem : this.fulfillmentGroup.getFulfillmentGroupItems()) {
            OrderItemContainer orderItemContainer;
            OrderItem orderItem = fgItem.getOrderItem();
            if (orderItem.isDiscountingAllowed()) {
                discountableOrderItemIds.add(fgItem.getOrderItem().getId());
                continue;
            }
            if (!(orderItem instanceof OrderItemContainer) || !(orderItemContainer = (OrderItemContainer)((Object)orderItem)).getAllowDiscountsOnChildItems()) continue;
            for (OrderItem orderItem2 : orderItemContainer.getOrderItems()) {
                if (orderItem2.isDiscountingAllowed()) continue;
                discountableOrderItemIds.add(orderItem2.getId());
            }
        }
        for (PromotableOrderItem item : this.promotableOrder.getDiscountableOrderItems()) {
            if (!discountableOrderItemIds.contains(item.getOrderItemId())) continue;
            this.discountableOrderItems.add(item);
        }
        return this.discountableOrderItems;
    }

    protected Money getSalePriceBeforeAdjustments() {
        Money salePrice = this.fulfillmentGroup.getSaleFulfillmentPrice();
        if (salePrice == null) {
            return this.fulfillmentGroup.getRetailFulfillmentPrice();
        }
        return salePrice;
    }

    protected Money calculateSaleAdjustmentPrice() {
        Money returnPrice = this.getSalePriceBeforeAdjustments();
        for (PromotableFulfillmentGroupAdjustment adjustment : this.candidateFulfillmentGroupAdjustments) {
            returnPrice = returnPrice.subtract(adjustment.getSaleAdjustmentValue());
        }
        return returnPrice;
    }

    protected Money calculateRetailAdjustmentPrice() {
        Money returnPrice = this.fulfillmentGroup.getRetailFulfillmentPrice();
        for (PromotableFulfillmentGroupAdjustment adjustment : this.candidateFulfillmentGroupAdjustments) {
            returnPrice = returnPrice.subtract(adjustment.getRetailAdjustmentValue());
        }
        return returnPrice;
    }

    @Override
    public void chooseSaleOrRetailAdjustments() {
        Money retailAdjustmentPrice;
        this.useSaleAdjustments = Boolean.FALSE;
        Money saleAdjustmentPrice = this.calculateSaleAdjustmentPrice();
        if (saleAdjustmentPrice.lessThan(retailAdjustmentPrice = this.calculateRetailAdjustmentPrice())) {
            this.useSaleAdjustments = Boolean.TRUE;
            this.adjustedPrice = saleAdjustmentPrice;
        } else {
            this.adjustedPrice = retailAdjustmentPrice;
        }
        if (this.useSaleAdjustments) {
            this.removeRetailOnlyAdjustments();
        }
        this.removeZeroDollarAdjustments(this.useSaleAdjustments);
        this.finalizeAdjustments(this.useSaleAdjustments);
    }

    protected void finalizeAdjustments(boolean useSaleAdjustments) {
        for (PromotableFulfillmentGroupAdjustment adjustment : this.candidateFulfillmentGroupAdjustments) {
            adjustment.finalizeAdjustment(useSaleAdjustments);
        }
    }

    protected void removeRetailOnlyAdjustments() {
        Iterator<PromotableFulfillmentGroupAdjustment> adjustments = this.candidateFulfillmentGroupAdjustments.iterator();
        while (adjustments.hasNext()) {
            PromotableFulfillmentGroupAdjustment adjustment = adjustments.next();
            if (adjustment.getPromotableCandidateFulfillmentGroupOffer().getOffer().getApplyDiscountToSalePrice()) continue;
            adjustments.remove();
        }
    }

    protected void removeZeroDollarAdjustments(boolean useSalePrice) {
        Iterator<PromotableFulfillmentGroupAdjustment> adjustments = this.candidateFulfillmentGroupAdjustments.iterator();
        while (adjustments.hasNext()) {
            PromotableFulfillmentGroupAdjustment adjustment = adjustments.next();
            if (useSalePrice) {
                if (!adjustment.getSaleAdjustmentValue().isZero()) continue;
                adjustments.remove();
                continue;
            }
            if (!adjustment.getRetailAdjustmentValue().isZero()) continue;
            adjustments.remove();
        }
    }

    @Override
    public Money getFinalizedPriceWithAdjustments() {
        this.chooseSaleOrRetailAdjustments();
        return this.adjustedPrice;
    }

    @Override
    public Money calculatePriceWithoutAdjustments() {
        if (this.fulfillmentGroup.getSaleFulfillmentPrice() != null) {
            return this.fulfillmentGroup.getSaleFulfillmentPrice();
        }
        return this.fulfillmentGroup.getRetailFulfillmentPrice();
    }

    @Override
    public void addCandidateFulfillmentGroupAdjustment(PromotableFulfillmentGroupAdjustment adjustment) {
        this.candidateFulfillmentGroupAdjustments.add(adjustment);
    }

    @Override
    public List<PromotableFulfillmentGroupAdjustment> getCandidateFulfillmentGroupAdjustments() {
        return Collections.unmodifiableList(this.candidateFulfillmentGroupAdjustments);
    }

    @Override
    public boolean canApplyOffer(PromotableCandidateFulfillmentGroupOffer fulfillmentGroupOffer) {
        if (this.candidateFulfillmentGroupAdjustments.size() > 0) {
            if (!fulfillmentGroupOffer.getOffer().isCombinableWithOtherOffers()) {
                return false;
            }
            for (PromotableFulfillmentGroupAdjustment adjustment : this.candidateFulfillmentGroupAdjustments) {
                if (adjustment.isCombinable()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Money calculatePriceWithAdjustments(boolean useSalePrice) {
        if (useSalePrice) {
            return this.calculateSaleAdjustmentPrice();
        }
        return this.calculateRetailAdjustmentPrice();
    }

    @Override
    public boolean isTotalitarianOfferApplied() {
        for (PromotableFulfillmentGroupAdjustment adjustment : this.candidateFulfillmentGroupAdjustments) {
            if (!adjustment.getPromotableCandidateFulfillmentGroupOffer().getOffer().isTotalitarianOffer().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllCandidateAdjustments() {
        this.candidateFulfillmentGroupAdjustments.clear();
    }
}

