/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionHandler;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionManager;
import org.broadleafcommerce.core.offer.service.OfferServiceUtilities;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.PromotionQualifier;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferMarkTargets;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemContainer;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.broadleafcommerce.core.order.domain.dto.OrderItemHolder;
import org.springframework.stereotype.Service;

@Service(value="blOfferServiceUtilities")
public class OfferServiceUtilitiesImpl
implements OfferServiceUtilities {
    protected static final Log LOG = LogFactory.getLog(OfferServiceUtilitiesImpl.class);
    @Resource(name="blPromotableItemFactory")
    protected PromotableItemFactory promotableItemFactory;
    @Resource(name="blOfferDao")
    protected OfferDao offerDao;
    @Resource(name="blOfferServiceExtensionManager")
    protected OfferServiceExtensionManager extensionManager;

    @Override
    public void sortTargetItemDetails(List<PromotableOrderItemPriceDetail> itemPriceDetails, boolean applyToSalePrice) {
        Collections.sort(itemPriceDetails, this.getPromotableItemComparator(applyToSalePrice));
    }

    @Override
    public void sortQualifierItemDetails(List<PromotableOrderItemPriceDetail> itemPriceDetails, boolean applyToSalePrice) {
        Collections.sort(itemPriceDetails, this.getPromotableItemComparator(applyToSalePrice));
    }

    protected Comparator<PromotableOrderItemPriceDetail> getPromotableItemComparator(final boolean applyToSalePrice) {
        return new Comparator<PromotableOrderItemPriceDetail>(){

            @Override
            public int compare(PromotableOrderItemPriceDetail o1, PromotableOrderItemPriceDetail o2) {
                Money price = o1.getPromotableOrderItem().getPriceBeforeAdjustments(applyToSalePrice);
                Money price2 = o2.getPromotableOrderItem().getPriceBeforeAdjustments(applyToSalePrice);
                return price2.compareTo(price);
            }
        };
    }

    @Override
    public OrderItem findRelatedQualifierRoot(OrderItem relatedQualifier) {
        OrderItem relatedQualifierRoot = null;
        if (relatedQualifier != null) {
            relatedQualifierRoot = relatedQualifier;
            while (relatedQualifierRoot.getParentOrderItem() != null) {
                relatedQualifierRoot = relatedQualifierRoot.getParentOrderItem();
            }
        }
        return relatedQualifierRoot;
    }

    @Override
    public boolean itemOfferCanBeApplied(PromotableCandidateItemOffer itemOffer, List<PromotableOrderItemPriceDetail> details) {
        for (PromotableOrderItemPriceDetail detail : details) {
            for (PromotableOrderItemPriceDetailAdjustment adjustment : detail.getCandidateItemAdjustments()) {
                if (adjustment.isTotalitarian() || itemOffer.getOffer().isTotalitarianOffer().booleanValue()) {
                    return false;
                }
                if (itemOffer.isLegacyOffer() || adjustment.isCombinable() && itemOffer.getOffer().isCombinableWithOtherOffers()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int markQualifiersForCriteria(PromotableCandidateItemOffer itemOffer, OfferItemCriteria itemCriteria, List<PromotableOrderItemPriceDetail> priceDetails) {
        this.sortQualifierItemDetails(priceDetails, itemOffer.getOffer().getApplyDiscountToSalePrice());
        int qualifierQtyNeeded = itemCriteria.getQuantity();
        for (PromotableOrderItemPriceDetail detail : priceDetails) {
            int itemQtyAvailableToBeUsedAsQualifier;
            if (qualifierQtyNeeded > 0 && (itemQtyAvailableToBeUsedAsQualifier = detail.getQuantityAvailableToBeUsedAsQualifier(itemOffer)) > 0) {
                int qtyToMarkAsQualifier = Math.min(qualifierQtyNeeded, itemQtyAvailableToBeUsedAsQualifier);
                qualifierQtyNeeded -= qtyToMarkAsQualifier;
                detail.addPromotionQualifier(itemOffer, itemCriteria, qtyToMarkAsQualifier);
            }
            if (qualifierQtyNeeded != 0) continue;
            break;
        }
        return qualifierQtyNeeded;
    }

    @Override
    public int markTargetsForCriteria(PromotableCandidateItemOffer itemOffer, OrderItem relatedQualifier, boolean checkOnly, Offer promotion, OrderItem relatedQualifierRoot, OfferItemCriteria itemCriteria, List<PromotableOrderItemPriceDetail> priceDetails, int targetQtyNeeded) {
        for (PromotableOrderItemPriceDetail priceDetail : priceDetails) {
            OrderItem thisItem;
            if (relatedQualifier != null && !relatedQualifierRoot.isAParentOf(thisItem = priceDetail.getPromotableOrderItem().getOrderItem()) && !thisItem.isAParentOf(relatedQualifierRoot) && !thisItem.equals(relatedQualifierRoot)) continue;
            int itemQtyAvailableToBeUsedAsTarget = priceDetail.getQuantityAvailableToBeUsedAsTarget(itemOffer);
            if (itemQtyAvailableToBeUsedAsTarget > 0 && (promotion.isUnlimitedUsePerOrder() || itemOffer.getUses() < promotion.getMaxUsesPerOrder())) {
                int qtyToMarkAsTarget = Math.min(targetQtyNeeded, itemQtyAvailableToBeUsedAsTarget);
                targetQtyNeeded -= qtyToMarkAsTarget;
                if (!checkOnly) {
                    priceDetail.addPromotionDiscount(itemOffer, itemCriteria, qtyToMarkAsTarget);
                }
            }
            if (targetQtyNeeded != 0) continue;
            break;
        }
        return targetQtyNeeded;
    }

    @Override
    public int markRelatedQualifiersAndTargetsForItemCriteria(PromotableCandidateItemOffer itemOffer, PromotableOrder order, OrderItemHolder orderItemHolder, OfferItemCriteria itemCriteria, List<PromotableOrderItemPriceDetail> priceDetails, ItemOfferMarkTargets itemOfferMarkTargets) {
        this.sortQualifierItemDetails(priceDetails, itemOffer.getOffer().getApplyDiscountToSalePrice());
        int qualifierQtyNeeded = itemCriteria.getQuantity();
        for (PromotableOrderItemPriceDetail detail : priceDetails) {
            int itemQtyAvailableToBeUsedAsQualifier;
            OrderItem oi = detail.getPromotableOrderItem().getOrderItem();
            if (qualifierQtyNeeded > 0 && (itemQtyAvailableToBeUsedAsQualifier = detail.getQuantityAvailableToBeUsedAsQualifier(itemOffer)) > 0) {
                OfferItemCriteria previousQualifierCriteria = null;
                for (PromotionQualifier possibleQualifier : detail.getPromotionQualifiers()) {
                    if (!possibleQualifier.getPromotion().equals(itemOffer.getOffer())) continue;
                    previousQualifierCriteria = possibleQualifier.getItemCriteria();
                    break;
                }
                int qtyToMarkAsQualifier = Math.min(qualifierQtyNeeded, itemQtyAvailableToBeUsedAsQualifier);
                qualifierQtyNeeded -= qtyToMarkAsQualifier;
                PromotionQualifier pq = detail.addPromotionQualifier(itemOffer, itemCriteria, qtyToMarkAsQualifier);
                pq.setPrice(detail.getPromotableOrderItem().getPriceBeforeAdjustments(itemOffer.getOffer().getApplyDiscountToSalePrice()));
                if (itemOfferMarkTargets.markTargets(itemOffer, order, oi, true)) {
                    orderItemHolder.setOrderItem(oi);
                } else {
                    qualifierQtyNeeded += qtyToMarkAsQualifier;
                    if (pq.getQuantity() == qtyToMarkAsQualifier) {
                        detail.getPromotionQualifiers().remove(pq);
                    } else {
                        pq.setItemCriteria(previousQualifierCriteria);
                        pq.setQuantity(pq.getQuantity() - qtyToMarkAsQualifier);
                    }
                }
            }
            if (qualifierQtyNeeded != 0) continue;
            break;
        }
        return qualifierQtyNeeded;
    }

    @Override
    public void applyAdjustmentsForItemPriceDetails(PromotableCandidateItemOffer itemOffer, List<PromotableOrderItemPriceDetail> itemPriceDetails) {
        block0: for (PromotableOrderItemPriceDetail itemPriceDetail : itemPriceDetails) {
            for (PromotionDiscount discount : itemPriceDetail.getPromotionDiscounts()) {
                if (!discount.getPromotion().equals(itemOffer.getOffer())) continue;
                if ((itemOffer.getOffer().isTotalitarianOffer().booleanValue() || !itemOffer.getOffer().isCombinableWithOtherOffers()) && this.adjustmentIsNotGoodEnoughToBeApplied(itemOffer, itemPriceDetail)) continue block0;
                this.applyOrderItemAdjustment(itemOffer, itemPriceDetail);
                continue block0;
            }
        }
    }

    protected boolean adjustmentIsNotGoodEnoughToBeApplied(PromotableCandidateItemOffer itemOffer, PromotableOrderItemPriceDetail detail) {
        if (!itemOffer.getOffer().getApplyDiscountToSalePrice()) {
            Money salePrice = detail.getPromotableOrderItem().getSalePriceBeforeAdjustments();
            Money retailPrice = detail.getPromotableOrderItem().getRetailPriceBeforeAdjustments();
            Money savings = itemOffer.calculateSavingsForOrderItem(detail.getPromotableOrderItem(), 1);
            if (salePrice != null && salePrice.lessThan(retailPrice.subtract(savings))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void applyOrderItemAdjustment(PromotableCandidateItemOffer itemOffer, PromotableOrderItemPriceDetail itemPriceDetail) {
        PromotableOrderItemPriceDetailAdjustment promotableOrderItemPriceDetailAdjustment = this.promotableItemFactory.createPromotableOrderItemPriceDetailAdjustment(itemOffer, itemPriceDetail);
        itemPriceDetail.addCandidateItemPriceDetailAdjustment(promotableOrderItemPriceDetailAdjustment);
    }

    @Override
    public List<OrderItem> buildOrderItemList(Order order) {
        ArrayList<OrderItem> orderItemList = new ArrayList<OrderItem>();
        for (OrderItem currentItem : order.getOrderItems()) {
            if (currentItem instanceof OrderItemContainer) {
                OrderItemContainer container = (OrderItemContainer)((Object)currentItem);
                if (container.isPricingAtContainerLevel()) {
                    orderItemList.add(currentItem);
                    continue;
                }
                for (OrderItem orderItem : container.getOrderItems()) {
                    orderItemList.add(orderItem);
                }
                continue;
            }
            orderItemList.add(currentItem);
        }
        return orderItemList;
    }

    @Override
    public Map<OrderItem, PromotableOrderItem> buildPromotableItemMap(PromotableOrder promotableOrder) {
        HashMap<OrderItem, PromotableOrderItem> promotableItemMap = new HashMap<OrderItem, PromotableOrderItem>();
        for (PromotableOrderItem item : promotableOrder.getDiscountableOrderItems()) {
            promotableItemMap.put(item.getOrderItem(), item);
        }
        return promotableItemMap;
    }

    @Override
    public Map<Long, OrderItemPriceDetailAdjustment> buildItemDetailAdjustmentMap(OrderItemPriceDetail itemDetail) {
        HashMap<Long, OrderItemPriceDetailAdjustment> itemAdjustmentMap = new HashMap<Long, OrderItemPriceDetailAdjustment>();
        ArrayList<OrderItemPriceDetailAdjustment> adjustmentsToRemove = new ArrayList<OrderItemPriceDetailAdjustment>();
        for (OrderItemPriceDetailAdjustment adjustment : itemDetail.getOrderItemPriceDetailAdjustments()) {
            if (itemAdjustmentMap.containsKey(adjustment.getOffer().getId())) {
                if (LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder("Detected collisions for item adjustments with ids ").append(((OrderItemPriceDetailAdjustment)itemAdjustmentMap.get(adjustment.getOffer().getId())).getId()).append(" and ").append(adjustment.getId());
                    LOG.debug((Object)sb.toString());
                }
                adjustmentsToRemove.add(adjustment);
                continue;
            }
            itemAdjustmentMap.put(adjustment.getOffer().getId(), adjustment);
        }
        for (OrderItemPriceDetailAdjustment adjustment : adjustmentsToRemove) {
            itemDetail.getOrderItemPriceDetailAdjustments().remove(adjustment);
        }
        return itemAdjustmentMap;
    }

    @Override
    public void updatePriceDetail(OrderItemPriceDetail itemDetail, PromotableOrderItemPriceDetail promotableDetail) {
        Map<Long, OrderItemPriceDetailAdjustment> itemAdjustmentMap = this.buildItemDetailAdjustmentMap(itemDetail);
        if (itemDetail.getQuantity() != promotableDetail.getQuantity()) {
            itemDetail.setQuantity(promotableDetail.getQuantity());
        }
        if (promotableDetail.isAdjustmentsFinalized()) {
            itemDetail.setUseSalePrice(promotableDetail.useSaleAdjustments());
        }
        for (PromotableOrderItemPriceDetailAdjustment promotableOrderItemPriceDetailAdjustment : promotableDetail.getCandidateItemAdjustments()) {
            OrderItemPriceDetailAdjustment itemAdjustment = itemAdjustmentMap.remove(promotableOrderItemPriceDetailAdjustment.getOfferId());
            if (itemAdjustment != null) {
                if (itemAdjustment.getValue().equals((Object)promotableOrderItemPriceDetailAdjustment.getAdjustmentValue())) continue;
                this.updateItemAdjustment(itemAdjustment, promotableOrderItemPriceDetailAdjustment);
                continue;
            }
            ExtensionResultHolder resultHolder = new ExtensionResultHolder();
            if (this.extensionManager != null) {
                ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).createOrderItemPriceDetailAdjustment(resultHolder, itemDetail);
            }
            OrderItemPriceDetailAdjustment newItemAdjustment = resultHolder != null && resultHolder.getContextMap().containsKey("OrderItemPriceDetailAdjustment") ? (OrderItemPriceDetailAdjustment)resultHolder.getContextMap().get("OrderItemPriceDetailAdjustment") : this.offerDao.createOrderItemPriceDetailAdjustment();
            newItemAdjustment.init(itemDetail, promotableOrderItemPriceDetailAdjustment.getOffer(), null);
            this.updateItemAdjustment(newItemAdjustment, promotableOrderItemPriceDetailAdjustment);
            itemDetail.getOrderItemPriceDetailAdjustments().add(newItemAdjustment);
        }
        if (itemAdjustmentMap.size() > 0) {
            ArrayList<Long> adjustmentIdsToRemove = new ArrayList<Long>();
            for (OrderItemPriceDetailAdjustment adjustmentToRemove : itemAdjustmentMap.values()) {
                adjustmentIdsToRemove.add(adjustmentToRemove.getOffer().getId());
            }
            Iterator<OrderItemPriceDetailAdjustment> iterator = itemDetail.getOrderItemPriceDetailAdjustments().iterator();
            while (iterator.hasNext()) {
                OrderItemPriceDetailAdjustment adj = iterator.next();
                if (!adjustmentIdsToRemove.contains(adj.getOffer().getId())) continue;
                iterator.remove();
            }
        }
    }

    protected void updateItemAdjustment(OrderItemPriceDetailAdjustment itemAdjustment, PromotableOrderItemPriceDetailAdjustment promotableAdjustment) {
        itemAdjustment.setValue(promotableAdjustment.getAdjustmentValue());
        itemAdjustment.setSalesPriceValue(promotableAdjustment.getSaleAdjustmentValue());
        itemAdjustment.setRetailPriceValue(promotableAdjustment.getRetailAdjustmentValue());
        itemAdjustment.setAppliedToSalePrice(promotableAdjustment.isAppliedToSalePrice());
    }

    @Override
    public void removeUnmatchedPriceDetails(Map<Long, ? extends OrderItemPriceDetail> unmatchedDetailsMap, Iterator<? extends OrderItemPriceDetail> pdIterator) {
        while (pdIterator.hasNext()) {
            OrderItemPriceDetail currentDetail = pdIterator.next();
            if (!unmatchedDetailsMap.containsKey(currentDetail.getId())) continue;
            pdIterator.remove();
        }
    }

    @Override
    public void removeUnmatchedQualifiers(Map<Long, ? extends OrderItemQualifier> unmatchedQualifiersMap, Iterator<? extends OrderItemQualifier> qIterator) {
        while (qIterator.hasNext()) {
            OrderItemQualifier currentQualifier = qIterator.next();
            if (!unmatchedQualifiersMap.containsKey(currentQualifier.getId())) continue;
            qIterator.remove();
        }
    }

    public PromotableItemFactory getPromotableItemFactory() {
        return this.promotableItemFactory;
    }

    public void setPromotableItemFactory(PromotableItemFactory promotableItemFactory) {
        this.promotableItemFactory = promotableItemFactory;
    }

    public OfferDao getOfferDao() {
        return this.offerDao;
    }

    public void setOfferDao(OfferDao offerDao) {
        this.offerDao = offerDao;
    }
}

