/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.persistence.DefaultPostLoaderDao;
import org.broadleafcommerce.common.persistence.PostLoaderDao;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.common.util.HibernateUtils;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetailImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.proxy.HibernateProxy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM_DTL_ADJ")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
public class OrderItemPriceDetailAdjustmentImpl
implements OrderItemPriceDetailAdjustment,
CurrencyCodeIdentifiable {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemPriceDetailAdjustmentId")
    @GenericGenerator(name="OrderItemPriceDetailAdjustmentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderItemPriceDetailAdjustmentImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustmentImpl")})
    @Column(name="ORDER_ITEM_DTL_ADJ_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderItemPriceDetailImpl.class)
    @JoinColumn(name="ORDER_ITEM_PRICE_DTL_ID")
    @AdminPresentation(excluded=true)
    protected OrderItemPriceDetail orderItemPriceDetail;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false)
    @JoinColumn(name="OFFER_ID")
    @AdminPresentation(friendlyName="OrderItemPriceDetailAdjustmentImpl_Offer", order=1000, prominent=true, gridOrder=1000)
    @AdminPresentationToOneLookup
    protected Offer offer;
    @Column(name="OFFER_NAME")
    protected String offerName;
    @Column(name="ADJUSTMENT_REASON", nullable=false)
    @AdminPresentation(friendlyName="OrderItemPriceDetailAdjustmentImpl_reason", order=1, group="OrderItemPriceDetailAdjustmentImpl_Description")
    protected String reason;
    @Column(name="ADJUSTMENT_VALUE", nullable=false, precision=19, scale=5)
    @AdminPresentation(friendlyName="OrderItemPriceDetailAdjustmentImpl_value", order=2, group="OrderItemPriceDetailAdjustmentImpl_Description", fieldType=SupportedFieldType.MONEY, prominent=true)
    protected BigDecimal value = Money.ZERO.getAmount();
    @Column(name="APPLIED_TO_SALE_PRICE")
    @AdminPresentation(friendlyName="OrderItemPriceDetailAdjustmentImpl_appliedToSalePrice", order=3, group="OrderItemPriceDetailAdjustmentImpl_Description")
    protected boolean appliedToSalePrice;
    @Transient
    protected Money retailValue;
    @Transient
    protected Money salesValue;
    @Transient
    protected Offer deproxiedOffer;

    @Override
    public void init(OrderItemPriceDetail orderItemPriceDetail, Offer offer, String reason) {
        this.setOrderItemPriceDetail(orderItemPriceDetail);
        this.setOffer(offer);
        this.setReason(reason);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderItemPriceDetail getOrderItemPriceDetail() {
        return this.orderItemPriceDetail;
    }

    @Override
    public Offer getOffer() {
        if (this.deproxiedOffer == null) {
            PostLoaderDao postLoaderDao = DefaultPostLoaderDao.getPostLoaderDao();
            if (postLoaderDao != null && this.offer.getId() != null) {
                Long id = this.offer.getId();
                this.deproxiedOffer = (Offer)postLoaderDao.find(OfferImpl.class, (Object)id);
            } else {
                this.deproxiedOffer = this.offer instanceof HibernateProxy ? (Offer)HibernateUtils.deproxy((Object)this.offer) : this.offer;
            }
        }
        return this.deproxiedOffer;
    }

    @Override
    public String getOfferName() {
        return this.offerName;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public void setReason(String reason) {
        if (reason != null) {
            this.reason = reason;
        } else if (this.offerName != null) {
            this.reason = this.offerName;
        }
    }

    @Override
    public void setOrderItemPriceDetail(OrderItemPriceDetail orderItemPriceDetail) {
        this.orderItemPriceDetail = orderItemPriceDetail;
    }

    public void setOffer(Offer offer) {
        this.offer = offer;
        this.deproxiedOffer = null;
        if (offer != null) {
            this.offerName = offer.getMarketingMessage() != null ? offer.getMarketingMessage() : offer.getName();
        }
    }

    @Override
    public void setOfferName(String offerName) {
        this.offerName = this.offer.getName();
    }

    protected BroadleafCurrency getCurrency() {
        return this.getOrderItemPriceDetail().getOrderItem().getOrder().getCurrency();
    }

    @Override
    public Money getValue() {
        return this.value == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.value, (BroadleafCurrency)this.getCurrency());
    }

    @Override
    public void setValue(Money value) {
        this.value = value.getAmount();
    }

    @Override
    public boolean isAppliedToSalePrice() {
        return this.appliedToSalePrice;
    }

    @Override
    public void setAppliedToSalePrice(boolean appliedToSalePrice) {
        this.appliedToSalePrice = appliedToSalePrice;
    }

    @Override
    public Money getRetailPriceValue() {
        if (this.retailValue == null) {
            return BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getCurrency());
        }
        return this.retailValue;
    }

    @Override
    public void setRetailPriceValue(Money retailPriceValue) {
        this.retailValue = retailPriceValue;
    }

    @Override
    public Money getSalesPriceValue() {
        if (this.salesValue == null) {
            return BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getCurrency());
        }
        return this.salesValue;
    }

    @Override
    public void setSalesPriceValue(Money salesPriceValue) {
        this.salesValue = salesPriceValue;
    }

    public String getCurrencyCode() {
        if (this.getCurrency() != null) {
            return this.getCurrency().getCurrencyCode();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.offer == null ? 0 : this.offer.hashCode());
        result = 31 * result + (this.orderItemPriceDetail == null ? 0 : this.orderItemPriceDetail.hashCode());
        result = 31 * result + (this.reason == null ? 0 : this.reason.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        OrderItemPriceDetailAdjustmentImpl other = (OrderItemPriceDetailAdjustmentImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.offer == null ? other.offer != null : !this.offer.equals(other.offer)) {
            return false;
        }
        if (this.orderItemPriceDetail == null ? other.orderItemPriceDetail != null : !this.orderItemPriceDetail.equals(other.orderItemPriceDetail)) {
            return false;
        }
        if (this.reason == null ? other.reason != null : !this.reason.equals(other.reason)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public <G extends OrderItemPriceDetailAdjustment> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        OrderItemPriceDetailAdjustment cloned = (OrderItemPriceDetailAdjustment)createResponse.getClone();
        cloned.setOfferName(this.offerName);
        cloned.setAppliedToSalePrice(this.appliedToSalePrice);
        cloned.setOrderItemPriceDetail(this.orderItemPriceDetail);
        cloned.setSalesPriceValue(this.getSalesPriceValue());
        cloned.setRetailPriceValue(this.getRetailPriceValue());
        cloned.setReason(this.reason);
        cloned.setValue(this.getValue());
        return createResponse;
    }
}

