/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicy;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.rule.QuantityBasedRule;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl;
import org.broadleafcommerce.core.offer.domain.OfferQualifyingCriteriaXref;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_QUAL_CRIT_OFFER_XREF")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
@AdminPresentationClass(excludeFromPolymorphism=false, populateToOneFields=PopulateToOneFieldsEnum.TRUE)
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class OfferQualifyingCriteriaXrefImpl
implements OfferQualifyingCriteriaXref,
QuantityBasedRule {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferQualCritId")
    @GenericGenerator(name="OfferQualCritId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OfferQualifyingCriteriaXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferQualifyingCriteriaXrefImpl")})
    @Column(name="OFFER_QUAL_CRIT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="OFFER_ID")
    @AdminPresentation(excluded=true)
    protected Offer offer;
    @ManyToOne(targetEntity=OfferItemCriteriaImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="OFFER_ITEM_CRITERIA_ID")
    @ClonePolicy
    protected OfferItemCriteria offerItemCriteria;

    public OfferQualifyingCriteriaXrefImpl(Offer offer, OfferItemCriteria offerItemCriteria) {
        this.offer = offer;
        this.offerItemCriteria = offerItemCriteria;
    }

    public OfferQualifyingCriteriaXrefImpl() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public OfferItemCriteria getOfferItemCriteria() {
        return this.offerItemCriteria;
    }

    @Override
    public void setOfferItemCriteria(OfferItemCriteria offerItemCriteria) {
        this.offerItemCriteria = offerItemCriteria;
    }

    public Integer getQuantity() {
        this.createEntityInstance();
        return this.offerItemCriteria.getQuantity();
    }

    public void setQuantity(Integer quantity) {
        this.createEntityInstance();
        this.offerItemCriteria.setQuantity(quantity);
    }

    public String getMatchRule() {
        this.createEntityInstance();
        return this.offerItemCriteria.getMatchRule();
    }

    public void setMatchRule(String matchRule) {
        this.createEntityInstance();
        this.offerItemCriteria.setMatchRule(matchRule);
    }

    protected void createEntityInstance() {
        if (this.offerItemCriteria == null) {
            this.offerItemCriteria = new OfferItemCriteriaImpl();
        }
    }

    public <G extends OfferQualifyingCriteriaXref> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        OfferQualifyingCriteriaXref cloned = (OfferQualifyingCriteriaXref)createResponse.getClone();
        if (this.offer != null) {
            cloned.setOffer((Offer)this.offer.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.offerItemCriteria != null) {
            cloned.setOfferItemCriteria((OfferItemCriteria)this.offerItemCriteria.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

