/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import javax.annotation.Nonnull;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicy;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.rule.SimpleRule;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferOfferRuleXref;
import org.broadleafcommerce.core.offer.domain.OfferRule;
import org.broadleafcommerce.core.offer.domain.OfferRuleImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_OFFER_RULE_MAP")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
@AdminPresentationClass(excludeFromPolymorphism=false, populateToOneFields=PopulateToOneFieldsEnum.TRUE)
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class OfferOfferRuleXrefImpl
implements OfferOfferRuleXref,
SimpleRule {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferOfferRuleId")
    @GenericGenerator(name="OfferOfferRuleId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OfferOfferRuleXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferOfferRuleXrefImpl")})
    @Column(name="OFFER_OFFER_RULE_ID")
    protected Long id;
    @ManyToOne(targetEntity=OfferImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BLC_OFFER_OFFER_ID")
    @AdminPresentation(excluded=true)
    protected Offer offer;
    @ManyToOne(targetEntity=OfferRuleImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="OFFER_RULE_ID")
    @ClonePolicy
    protected OfferRule offerRule;
    @Column(name="MAP_KEY", nullable=false)
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected String key;

    public OfferOfferRuleXrefImpl(Offer offer, OfferRule offerRule, String key) {
        this.offer = offer;
        this.offerRule = offerRule;
        this.key = key;
    }

    public OfferOfferRuleXrefImpl() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Offer getOffer() {
        return this.offer;
    }

    @Override
    public void setOffer(Offer offer) {
        this.offer = offer;
    }

    @Override
    public OfferRule getOfferRule() {
        return this.offerRule;
    }

    @Override
    public void setOfferRule(OfferRule offerRule) {
        this.offerRule = offerRule;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Nonnull
    public String getMatchRule() {
        this.createEntityInstance();
        return this.offerRule.getMatchRule();
    }

    public void setMatchRule(@Nonnull String matchRule) {
        this.createEntityInstance();
        this.offerRule.setMatchRule(matchRule);
    }

    protected void createEntityInstance() {
        if (this.offerRule == null) {
            this.offerRule = new OfferRuleImpl();
        }
    }

    public <G extends OfferOfferRuleXref> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        OfferOfferRuleXref cloned = (OfferOfferRuleXref)createResponse.getClone();
        cloned.setKey(this.key);
        if (this.offer != null) {
            cloned.setOffer((Offer)this.offer.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.offerRule != null) {
            cloned.setOfferRule((OfferRule)this.offerRule.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

