/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.inventory.service.type;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class InventoryType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, InventoryType> TYPES = new LinkedHashMap<String, InventoryType>();
    @Deprecated
    public static final InventoryType NONE = new InventoryType("NONE", "None");
    @Deprecated
    public static final InventoryType BASIC = new InventoryType("BASIC", "Basic");
    public static final InventoryType ALWAYS_AVAILABLE = new InventoryType("ALWAYS_AVAILABLE", "Always Available");
    public static final InventoryType UNAVAILABLE = new InventoryType("UNAVAILABLE", "Unavailable");
    public static final InventoryType CHECK_QUANTITY = new InventoryType("CHECK_QUANTITY", "Check Quantity");
    private String type;
    private String friendlyType;

    public static InventoryType getInstance(String type) {
        return TYPES.get(type);
    }

    public InventoryType() {
    }

    public InventoryType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (TYPES.containsKey(type)) {
            throw new RuntimeException("Cannot add the type: (" + type + "). It already exists as a type via " + InventoryType.getInstance(type).getClass().getName());
        }
        TYPES.put(type, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        InventoryType other = (InventoryType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

