/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.pricing.service.TaxService;
import org.broadleafcommerce.core.pricing.service.exception.TaxException;
import org.broadleafcommerce.core.workflow.Activity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.state.RollbackFailureException;
import org.broadleafcommerce.core.workflow.state.RollbackHandler;
import org.springframework.stereotype.Component;

@Component(value="blCommitTaxRollbackHandler")
public class CommitTaxRollbackHandler
implements RollbackHandler<CheckoutSeed> {
    @Resource(name="blTaxService")
    protected TaxService taxService;

    @Override
    public void rollbackState(Activity<? extends ProcessContext<CheckoutSeed>> activity, ProcessContext<CheckoutSeed> processContext, Map<String, Object> stateConfiguration) throws RollbackFailureException {
        ProcessContext<CheckoutSeed> ctx = processContext;
        Order order = ctx.getSeedData().getOrder();
        try {
            this.taxService.cancelTax(order);
        }
        catch (TaxException e) {
            throw new RollbackFailureException("An exception occured cancelling taxes for order id: " + order.getId(), e);
        }
    }
}

