/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValueImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.domain.SkuProductOptionValueXref;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Polymorphism;
import org.hibernate.annotations.PolymorphismType;

@Entity
@Polymorphism(type=PolymorphismType.EXPLICIT)
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_OPTION_VALUE_XREF")
@AdminPresentationClass(excludeFromPolymorphism=false)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class SkuProductOptionValueXrefImpl
implements SkuProductOptionValueXref {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuProductOptionValueXrefId")
    @GenericGenerator(name="SkuProductOptionValueXrefId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SkuProductOptionValueXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuProductOptionValueXrefImpl")})
    @Column(name="SKU_OPTION_VALUE_XREF_ID")
    protected Long id;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="SKU_ID")
    protected Sku sku;
    @ManyToOne(targetEntity=ProductOptionValueImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PRODUCT_OPTION_VALUE_ID")
    protected ProductOptionValue productOptionValue;

    public SkuProductOptionValueXrefImpl() {
    }

    public SkuProductOptionValueXrefImpl(Sku sku, ProductOptionValue val) {
        this.sku = sku;
        this.productOptionValue = val;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
    }

    @Override
    public ProductOptionValue getProductOptionValue() {
        return this.productOptionValue;
    }

    @Override
    public void setProductOptionValue(ProductOptionValue productOptionValue) {
        this.productOptionValue = productOptionValue;
    }

    public <G extends SkuProductOptionValueXref> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        SkuProductOptionValueXref cloned = (SkuProductOptionValueXref)createResponse.getClone();
        if (this.sku != null) {
            cloned.setSku((Sku)this.sku.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.productOptionValue != null) {
            cloned.setProductOptionValue((ProductOptionValue)this.productOptionValue.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

