/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrencyImpl;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyArchive;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicyCollectionOverride;
import org.broadleafcommerce.common.extensibility.jpa.clone.IgnoreEnterpriseBehavior;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationDataDrivenEnumeration;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationMapField;
import org.broadleafcommerce.common.presentation.AdminPresentationMapFields;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.ConfigurationItem;
import org.broadleafcommerce.common.presentation.OptionFilterParam;
import org.broadleafcommerce.common.presentation.OptionFilterParamType;
import org.broadleafcommerce.common.presentation.ValidationConfiguration;
import org.broadleafcommerce.common.presentation.client.LookupType;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Dimension;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.catalog.domain.SkuAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.domain.SkuFeeImpl;
import org.broadleafcommerce.core.catalog.domain.SkuMediaXref;
import org.broadleafcommerce.core.catalog.domain.SkuMediaXrefImpl;
import org.broadleafcommerce.core.catalog.domain.SkuProductOptionValueXref;
import org.broadleafcommerce.core.catalog.domain.SkuProductOptionValueXrefImpl;
import org.broadleafcommerce.core.catalog.domain.Weight;
import org.broadleafcommerce.core.catalog.service.dynamic.DefaultDynamicSkuPricingInvocationHandler;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPrices;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuActiveDateConsiderationContext;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.springframework.util.ClassUtils;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU")
@org.hibernate.annotations.Table(appliesTo="BLC_SKU", indexes={@Index(name="SKU_URL_KEY_INDEX", columnNames={"URL_KEY"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(friendlyName="baseSku")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class SkuImpl
implements Sku {
    private static final Log LOG = LogFactory.getLog(SkuImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuId")
    @GenericGenerator(name="SkuId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SkuImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuImpl")})
    @Column(name="SKU_ID")
    @AdminPresentation(friendlyName="SkuImpl_Sku_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="EXTERNAL_ID")
    @Index(name="SKU_EXTERNAL_ID_INDEX", columnNames={"EXTERNAL_ID"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_ExternalID", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected String externalId;
    @Column(name="URL_KEY")
    @AdminPresentation(friendlyName="SkuImpl_Sku_UrlKey", order=4000, tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000, excluded=true)
    protected String urlKey;
    @Column(name="DISPLAY_TEMPLATE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_Display_Template", order=5000, tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000, excluded=true)
    protected String displayTemplate;
    @Column(name="UPC")
    @Index(name="SKU_UPC_INDEX", columnNames={"UPC"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_UPC", order=6000, tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected String upc;
    @Column(name="SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="SkuImpl_Sku_Sale_Price", order=2000, group="SkuImpl_Price", groupOrder=2000, prominent=true, gridOrder=6, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal salePrice;
    @Column(name="RETAIL_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="SkuImpl_Sku_Retail_Price", order=1000, group="SkuImpl_Price", groupOrder=2000, prominent=true, gridOrder=5, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal retailPrice;
    @Column(name="NAME")
    @Index(name="SKU_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Name", order=1000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=1, columnWidth="260px", translatable=true)
    protected String name;
    @Column(name="DESCRIPTION")
    @AdminPresentation(friendlyName="SkuImpl_Sku_Description", order=2000, group="ProductImpl_Product_Description", groupOrder=1000, largeEntry=true, excluded=true, translatable=true)
    protected String description;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="LONG_DESCRIPTION", length=0x7FFFFFFE)
    @AdminPresentation(friendlyName="SkuImpl_Sku_Large_Description", order=4000, group="ProductImpl_Product_Description", groupOrder=1000, largeEntry=true, fieldType=SupportedFieldType.HTML_BASIC, translatable=true)
    protected String longDescription;
    @Column(name="TAX_CODE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_TaxCode", order=1001, group="ProductImpl_Financial")
    @AdminPresentationDataDrivenEnumeration(optionCanEditValues=true, optionFilterParams={@OptionFilterParam(param="type.key", value="TAX_CODE", paramType=OptionFilterParamType.STRING)})
    protected String taxCode;
    @Column(name="TAXABLE_FLAG")
    @Index(name="SKU_TAXABLE_INDEX", columnNames={"TAXABLE_FLAG"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Taxable", order=1000, group="ProductImpl_Financial")
    protected Character taxable;
    @Column(name="DISCOUNTABLE_FLAG")
    @Index(name="SKU_DISCOUNTABLE_INDEX", columnNames={"DISCOUNTABLE_FLAG"})
    @AdminPresentation(friendlyName="SkuImpl_Sku_Discountable", order=2000, tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected Character discountable = Character.valueOf('Y');
    @Column(name="AVAILABLE_FLAG")
    @Index(name="SKU_AVAILABLE_INDEX", columnNames={"AVAILABLE_FLAG"})
    @AdminPresentation(excluded=true)
    @Deprecated
    protected Character available;
    @Column(name="ACTIVE_START_DATE")
    @Index(name="SKU_ACTIVE_START_INDEX")
    @AdminPresentation(friendlyName="SkuImpl_Sku_Start_Date", order=1000, group="ProductImpl_Product_Active_Date_Range", groupOrder=3000, tooltip="skuStartDateTooltip", defaultValue="today")
    protected Date activeStartDate;
    @Column(name="ACTIVE_END_DATE")
    @Index(name="SKU_ACTIVE_END_INDEX")
    @AdminPresentation(friendlyName="SkuImpl_Sku_End_Date", order=2000, group="ProductImpl_Product_Active_Date_Range", groupOrder=3000, tooltip="skuEndDateTooltip", validationConfigurations={@ValidationConfiguration(validationImplementation="blAfterStartDateValidator", configurationItems={@ConfigurationItem(itemName="otherField", itemValue="activeStartDate")})})
    protected Date activeEndDate;
    @Embedded
    protected Dimension dimension = new Dimension();
    @Embedded
    protected Weight weight = new Weight();
    @Transient
    protected DynamicSkuPrices dynamicPrices = null;
    @Column(name="IS_MACHINE_SORTABLE")
    @AdminPresentation(friendlyName="ProductImpl_Is_Product_Machine_Sortable", order=10000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000)
    protected Boolean isMachineSortable = true;
    @OneToMany(mappedBy="sku", targetEntity=SkuMediaXrefImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @MapKey(name="key")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="SkuImpl_Sku_Media", tab="SkuImpl_Media_Tab", tabOrder=3000, keyPropertyFriendlyName="SkuImpl_Sku_Media_Key", deleteEntityUponRemove=true, mediaField="media.url", toOneTargetProperty="media", toOneParentProperty="sku", forceFreeFormKeys=true)
    @AdminPresentationMapFields(mapDisplayFields={@AdminPresentationMapField(fieldName="primary", fieldPresentation=@AdminPresentation(fieldType=SupportedFieldType.MEDIA, group="ProductImpl_Product_Description", groupOrder=1000, order=3000, friendlyName="SkuImpl_Primary_Media"))})
    protected Map<String, SkuMediaXref> skuMedia = new HashMap<String, SkuMediaXref>();
    @Transient
    protected Map<String, Media> legacySkuMedia = new HashMap<String, Media>();
    @OneToOne(optional=true, targetEntity=ProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="DEFAULT_PRODUCT_ID")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @IgnoreEnterpriseBehavior
    protected Product defaultProduct;
    @ManyToOne(optional=true, targetEntity=ProductImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="ADDL_PRODUCT_ID")
    protected Product product;
    @OneToMany(mappedBy="sku", targetEntity=SkuAttributeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blProducts")
    @MapKey(name="name")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="skuAttributesTitle", tab="ProductImpl_Advanced_Tab", tabOrder=7000, deleteEntityUponRemove=true, forceFreeFormKeys=true)
    protected Map<String, SkuAttribute> skuAttributes = new HashMap<String, SkuAttribute>();
    @OneToMany(targetEntity=SkuProductOptionValueXrefImpl.class, cascade={CascadeType.ALL}, mappedBy="sku")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @ClonePolicyCollectionOverride
    @ClonePolicyArchive
    protected Set<SkuProductOptionValueXref> productOptionValueXrefs = new HashSet<SkuProductOptionValueXref>();
    @Transient
    protected Set<ProductOptionValue> legacyProductOptionValues = new HashSet<ProductOptionValue>();
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=SkuFeeImpl.class)
    @JoinTable(name="BLC_SKU_FEE_XREF", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)}, inverseJoinColumns={@JoinColumn(name="SKU_FEE_ID", referencedColumnName="SKU_FEE_ID", nullable=true)})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    protected List<SkuFee> fees = new ArrayList<SkuFee>();
    @ElementCollection
    @CollectionTable(name="BLC_SKU_FULFILLMENT_FLAT_RATES", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID", nullable=true)})
    @MapKeyJoinColumn(name="FULFILLMENT_OPTION_ID", referencedColumnName="FULFILLMENT_OPTION_ID")
    @MapKeyClass(value=FulfillmentOptionImpl.class)
    @Column(name="RATE", precision=19, scale=5)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    protected Map<FulfillmentOption, BigDecimal> fulfillmentFlatRates = new HashMap<FulfillmentOption, BigDecimal>();
    @ManyToMany(targetEntity=FulfillmentOptionImpl.class)
    @JoinTable(name="BLC_SKU_FULFILLMENT_EXCLUDED", joinColumns={@JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")}, inverseJoinColumns={@JoinColumn(name="FULFILLMENT_OPTION_ID", referencedColumnName="FULFILLMENT_OPTION_ID")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    protected List<FulfillmentOption> excludedFulfillmentOptions = new ArrayList<FulfillmentOption>();
    @Column(name="INVENTORY_TYPE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_InventoryType", helpText="skuInventoryTypeHelpText", order=1000, tab="ProductImpl_Inventory_Tab", tabOrder=5000, group="SkuImpl_Sku_Inventory", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.inventory.service.type.InventoryType")
    protected String inventoryType;
    @Column(name="QUANTITY_AVAILABLE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_QuantityAvailable", order=1010, tab="ProductImpl_Inventory_Tab", tabOrder=5000, group="SkuImpl_Sku_Inventory", groupOrder=1000)
    protected Integer quantityAvailable = 0;
    @Column(name="FULFILLMENT_TYPE")
    @AdminPresentation(friendlyName="SkuImpl_Sku_FulfillmentType", order=1000, tab="ProductImpl_Shipping_Tab", tabOrder=6000, group="ProductWeight_Shipping", groupOrder=1000, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.order.service.type.FulfillmentType")
    protected String fulfillmentType;
    @ManyToOne(targetEntity=BroadleafCurrencyImpl.class)
    @JoinColumn(name="CURRENCY_CODE")
    @AdminPresentation(friendlyName="SkuImpl_Currency", order=3000, visibility=VisibilityEnum.HIDDEN_ALL, tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    @AdminPresentationToOneLookup(lookupType=LookupType.DROPDOWN, lookupDisplayProperty="friendlyName")
    protected BroadleafCurrency currency;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUrlKey() {
        return this.urlKey;
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    @Override
    public boolean isOnSale() {
        Money retailPrice = this.getRetailPrice();
        Money salePrice = this.getSalePrice();
        return salePrice != null && !salePrice.isZero() && salePrice.lessThan(retailPrice);
    }

    protected boolean hasDefaultSku() {
        return this.product != null && this.product.getDefaultSku() != null && !this.getId().equals(this.product.getDefaultSku().getId());
    }

    protected Sku lookupDefaultSku() {
        if (this.product != null && this.product.getDefaultSku() != null) {
            return this.product.getDefaultSku();
        }
        return null;
    }

    @Override
    public Money getProductOptionValueAdjustments() {
        Money optionValuePriceAdjustments = null;
        if (this.getProductOptionValues() != null) {
            for (ProductOptionValue value : this.getProductOptionValues()) {
                if (value.getPriceAdjustment() == null) continue;
                if (optionValuePriceAdjustments == null) {
                    optionValuePriceAdjustments = value.getPriceAdjustment();
                    continue;
                }
                optionValuePriceAdjustments = optionValuePriceAdjustments.add(value.getPriceAdjustment());
            }
        }
        return optionValuePriceAdjustments;
    }

    @Override
    public Money getSalePrice() {
        Money returnPrice = null;
        Money optionValueAdjustments = null;
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            if (this.dynamicPrices == null) {
                DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
                Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), ClassUtils.getAllInterfacesForClass(this.getClass()), (InvocationHandler)handler);
                this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            }
            returnPrice = this.dynamicPrices.getSalePrice();
            optionValueAdjustments = this.dynamicPrices.getPriceAdjustment();
        } else if (this.salePrice != null) {
            returnPrice = new Money(this.salePrice, this.getCurrency());
        }
        if (returnPrice == null && this.hasDefaultSku()) {
            returnPrice = this.lookupDefaultSku().getSalePrice();
            optionValueAdjustments = this.getProductOptionValueAdjustments();
        }
        if (returnPrice == null) {
            return null;
        }
        if (optionValueAdjustments != null) {
            returnPrice = returnPrice.add(optionValueAdjustments);
        }
        return returnPrice;
    }

    @Override
    public boolean hasSalePrice() {
        return this.getSalePrice() != null;
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.salePrice = Money.toAmount((Money)salePrice);
    }

    @Override
    public Money getRetailPrice() {
        return this.getRetailPriceInternal();
    }

    protected Money getRetailPriceInternal() {
        Money returnPrice = null;
        Money optionValueAdjustments = null;
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            if (this.dynamicPrices == null) {
                DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
                Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), ClassUtils.getAllInterfacesForClass(this.getClass()), (InvocationHandler)handler);
                this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            }
            returnPrice = this.dynamicPrices.getRetailPrice();
            optionValueAdjustments = this.dynamicPrices.getPriceAdjustment();
        } else if (this.retailPrice != null) {
            returnPrice = new Money(this.retailPrice, this.getCurrency());
        }
        if (returnPrice == null && this.hasDefaultSku()) {
            returnPrice = this.lookupDefaultSku().getRetailPrice();
            optionValueAdjustments = this.getProductOptionValueAdjustments();
        }
        if (returnPrice != null && optionValueAdjustments != null) {
            returnPrice = returnPrice.add(optionValueAdjustments);
        }
        return returnPrice;
    }

    @Override
    public DynamicSkuPrices getPriceData() {
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            if (this.dynamicPrices == null) {
                DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(this);
                Sku proxy = (Sku)Proxy.newProxyInstance(this.getClass().getClassLoader(), ClassUtils.getAllInterfacesForClass(this.getClass()), (InvocationHandler)handler);
                this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
            }
            return this.dynamicPrices;
        }
        DynamicSkuPrices dsp = new DynamicSkuPrices();
        BroadleafCurrency tmpCurrency = this.currency != null ? this.currency : BroadleafRequestContext.getCurrency();
        if (this.retailPrice != null) {
            dsp.setRetailPrice(new Money(this.retailPrice, tmpCurrency));
        }
        if (this.salePrice != null) {
            dsp.setSalePrice(new Money(this.salePrice, tmpCurrency));
        }
        return dsp;
    }

    @Override
    public boolean hasRetailPrice() {
        return this.getRetailPriceInternal() != null;
    }

    @Override
    public void setRetailPrice(Money retailPrice) {
        this.retailPrice = Money.toAmount((Money)retailPrice);
    }

    @Override
    public Money getPrice() {
        return this.isOnSale() ? this.getSalePrice() : this.getRetailPrice();
    }

    @Override
    @Deprecated
    public Money getListPrice() {
        return this.getRetailPrice();
    }

    @Override
    @Deprecated
    public void setListPrice(Money listPrice) {
        this.retailPrice = Money.toAmount((Money)listPrice);
    }

    @Override
    public String getName() {
        if (this.name == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getName();
        }
        return DynamicTranslationProvider.getValue((Object)this, (String)"name", (String)this.name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        if (this.description == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getDescription();
        }
        return DynamicTranslationProvider.getValue((Object)this, (String)"description", (String)this.description);
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getLongDescription() {
        if (this.longDescription == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getLongDescription();
        }
        return DynamicTranslationProvider.getValue((Object)this, (String)"longDescription", (String)this.longDescription);
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Override
    public Boolean isTaxable() {
        if (this.taxable == null) {
            if (this.hasDefaultSku()) {
                return this.lookupDefaultSku().isTaxable();
            }
            return null;
        }
        return this.taxable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Boolean getTaxable() {
        return this.isTaxable();
    }

    @Override
    public void setTaxable(Boolean taxable) {
        this.taxable = taxable == null ? null : Character.valueOf(taxable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isDiscountable() {
        if (this.discountable == null) {
            if (this.hasDefaultSku()) {
                return this.lookupDefaultSku().isDiscountable();
            }
            return Boolean.FALSE;
        }
        return this.discountable.charValue() == 'Y' ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean getDiscountable() {
        return this.isDiscountable();
    }

    @Override
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable == null ? null : Character.valueOf(discountable != false ? (char)'Y' : 'N');
    }

    @Override
    public Boolean isAvailable() {
        if (InventoryType.UNAVAILABLE.equals(this.getInventoryType())) {
            return false;
        }
        if (this.available == null) {
            if (this.hasDefaultSku()) {
                return this.lookupDefaultSku().isAvailable();
            }
            return true;
        }
        return this.available.charValue() != 'N';
    }

    @Override
    public Boolean getAvailable() {
        return this.isAvailable();
    }

    @Override
    public void setAvailable(Boolean available) {
        this.available = available == null ? null : Character.valueOf(available != false ? (char)'Y' : 'N');
    }

    @Override
    public Date getActiveStartDate() {
        Date returnDate = null;
        if (SkuActiveDateConsiderationContext.hasDynamicActiveDates()) {
            returnDate = SkuActiveDateConsiderationContext.getSkuActiveDatesService().getDynamicSkuActiveStartDate(this);
        }
        if (returnDate == null) {
            if (this.activeStartDate == null && this.hasDefaultSku()) {
                return this.lookupDefaultSku().getActiveStartDate();
            }
            return this.activeStartDate;
        }
        return returnDate;
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.activeStartDate = activeStartDate;
    }

    @Override
    public Date getActiveEndDate() {
        Date returnDate = null;
        if (SkuActiveDateConsiderationContext.hasDynamicActiveDates()) {
            returnDate = SkuActiveDateConsiderationContext.getSkuActiveDatesService().getDynamicSkuActiveEndDate(this);
        }
        if (returnDate == null) {
            if (this.activeEndDate == null && this.hasDefaultSku()) {
                return this.lookupDefaultSku().getActiveEndDate();
            }
            return this.activeEndDate;
        }
        return returnDate;
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.activeEndDate = activeEndDate;
    }

    @Override
    public Dimension getDimension() {
        if (this.dimension == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getDimension();
        }
        return this.dimension;
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public Weight getWeight() {
        if (this.weight == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getWeight();
        }
        return this.weight;
    }

    @Override
    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    @Override
    public boolean isActive() {
        if (this.activeStartDate == null && this.activeEndDate == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().isActive();
        }
        if (LOG.isDebugEnabled() && !DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
            LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true);
    }

    @Override
    public boolean isActive(Product product, Category category) {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to date"));
            } else if (!product.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to product being inactive"));
            } else if (!category.isActive()) {
                LOG.debug((Object)("sku, " + this.id + ", inactive due to category being inactive"));
            }
        }
        return !(!this.isActive() || product != null && !product.isActive() || category != null && !category.isActive());
    }

    @Override
    @Deprecated
    public Map<String, Media> getSkuMedia() {
        if (this.legacySkuMedia.size() == 0) {
            for (Map.Entry<String, SkuMediaXref> entry : this.getSkuMediaXref().entrySet()) {
                this.legacySkuMedia.put(entry.getKey(), entry.getValue().getMedia());
            }
        }
        return Collections.unmodifiableMap(this.legacySkuMedia);
    }

    @Override
    @Deprecated
    public void setSkuMedia(Map<String, Media> skuMedia) {
        this.skuMedia.clear();
        this.legacySkuMedia.clear();
        for (Map.Entry<String, Media> entry : skuMedia.entrySet()) {
            this.skuMedia.put(entry.getKey(), new SkuMediaXrefImpl(this, entry.getValue(), entry.getKey()));
        }
    }

    @Override
    public Map<String, SkuMediaXref> getSkuMediaXref() {
        if ((this.skuMedia == null || this.skuMedia.isEmpty()) && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getSkuMediaXref();
        }
        return this.skuMedia;
    }

    @Override
    public Map<String, SkuMediaXref> getSkuMediaXrefIgnoreDefaultSku() {
        return this.skuMedia;
    }

    @Override
    public void setSkuMediaXref(Map<String, SkuMediaXref> skuMediaXref) {
        this.skuMedia = skuMediaXref;
    }

    @Override
    public Product getDefaultProduct() {
        return this.defaultProduct;
    }

    @Override
    public void setDefaultProduct(Product defaultProduct) {
        this.defaultProduct = defaultProduct;
    }

    @Override
    public Product getProduct() {
        return this.getDefaultProduct() != null ? this.getDefaultProduct() : this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public Set<SkuProductOptionValueXref> getProductOptionValueXrefs() {
        return this.productOptionValueXrefs;
    }

    @Override
    public void setProductOptionValueXrefs(Set<SkuProductOptionValueXref> productOptionValueXrefs) {
        this.productOptionValueXrefs = productOptionValueXrefs;
    }

    @Override
    public Set<ProductOptionValue> getProductOptionValuesCollection() {
        if (this.legacyProductOptionValues.size() == 0) {
            for (SkuProductOptionValueXref xref : this.productOptionValueXrefs) {
                this.legacyProductOptionValues.add(xref.getProductOptionValue());
            }
        }
        return Collections.unmodifiableSet(this.legacyProductOptionValues);
    }

    @Override
    public void setProductOptionValuesCollection(Set<ProductOptionValue> productOptionValues) {
        this.legacyProductOptionValues.clear();
        this.productOptionValueXrefs.clear();
        for (ProductOptionValue val : productOptionValues) {
            this.productOptionValueXrefs.add(new SkuProductOptionValueXrefImpl(this, val));
        }
    }

    @Override
    @Deprecated
    public List<ProductOptionValue> getProductOptionValues() {
        return (List)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{List.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return MethodUtils.invokeMethod(SkuImpl.this.getProductOptionValuesCollection(), (String)method.getName(), (Object[])args, (Class[])method.getParameterTypes());
            }
        });
    }

    @Override
    @Deprecated
    public void setProductOptionValues(List<ProductOptionValue> productOptionValues) {
        this.setProductOptionValuesCollection(new HashSet<ProductOptionValue>(productOptionValues));
    }

    @Override
    @Deprecated
    public Boolean isMachineSortable() {
        if (this.isMachineSortable == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().isMachineSortable();
        }
        return this.isMachineSortable == null ? false : this.isMachineSortable;
    }

    @Override
    public Boolean getIsMachineSortable() {
        if (this.isMachineSortable == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getIsMachineSortable();
        }
        return this.isMachineSortable == null ? false : this.isMachineSortable;
    }

    @Override
    @Deprecated
    public void setMachineSortable(Boolean isMachineSortable) {
        this.isMachineSortable = isMachineSortable;
    }

    @Override
    public void setIsMachineSortable(Boolean isMachineSortable) {
        this.isMachineSortable = isMachineSortable;
    }

    @Override
    public List<SkuFee> getFees() {
        return this.fees;
    }

    @Override
    public void setFees(List<SkuFee> fees) {
        this.fees = fees;
    }

    @Override
    public Map<FulfillmentOption, BigDecimal> getFulfillmentFlatRates() {
        return this.fulfillmentFlatRates;
    }

    @Override
    public void setFulfillmentFlatRates(Map<FulfillmentOption, BigDecimal> fulfillmentFlatRates) {
        this.fulfillmentFlatRates = fulfillmentFlatRates;
    }

    @Override
    public List<FulfillmentOption> getExcludedFulfillmentOptions() {
        return this.excludedFulfillmentOptions;
    }

    @Override
    public void setExcludedFulfillmentOptions(List<FulfillmentOption> excludedFulfillmentOptions) {
        this.excludedFulfillmentOptions = excludedFulfillmentOptions;
    }

    @Override
    public InventoryType getInventoryType() {
        if (StringUtils.isEmpty((String)this.inventoryType)) {
            if (this.hasDefaultSku() && this.lookupDefaultSku().getInventoryType() != null) {
                return this.lookupDefaultSku().getInventoryType();
            }
            if (this.getProduct() != null && this.getProduct().getDefaultCategory() != null) {
                return this.getProduct().getDefaultCategory().getInventoryType();
            }
            return null;
        }
        return InventoryType.getInstance(this.inventoryType);
    }

    @Override
    public void setInventoryType(InventoryType inventoryType) {
        this.inventoryType = inventoryType == null ? null : inventoryType.getType();
    }

    @Override
    public Integer getQuantityAvailable() {
        return this.quantityAvailable;
    }

    @Override
    public void setQuantityAvailable(Integer quantityAvailable) {
        this.quantityAvailable = quantityAvailable;
    }

    @Override
    public FulfillmentType getFulfillmentType() {
        if (StringUtils.isEmpty((String)this.fulfillmentType)) {
            if (this.hasDefaultSku() && this.lookupDefaultSku().getFulfillmentType() != null) {
                return this.lookupDefaultSku().getFulfillmentType();
            }
            if (this.getProduct() != null && this.getProduct().getDefaultCategory() != null) {
                return this.getProduct().getDefaultCategory().getFulfillmentType();
            }
            return null;
        }
        return FulfillmentType.getInstance(this.fulfillmentType);
    }

    @Override
    public void setFulfillmentType(FulfillmentType fulfillmentType) {
        if (fulfillmentType != null) {
            this.fulfillmentType = fulfillmentType.getType();
        }
    }

    @Override
    public Map<String, SkuAttribute> getSkuAttributes() {
        return this.skuAttributes;
    }

    @Override
    public void setSkuAttributes(Map<String, SkuAttribute> skuAttributes) {
        this.skuAttributes = skuAttributes;
    }

    @Override
    public BroadleafCurrency getCurrency() {
        if (this.currency == null && this.hasDefaultSku()) {
            return this.lookupDefaultSku().getCurrency();
        }
        return this.currency;
    }

    @Override
    public void setCurrency(BroadleafCurrency currency) {
        this.currency = currency;
    }

    @Override
    public void clearDynamicPrices() {
        this.dynamicPrices = null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        SkuImpl other = (SkuImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName()));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public String getTaxCode() {
        if (StringUtils.isEmpty((String)this.taxCode)) {
            if (this.hasDefaultSku() && !StringUtils.isEmpty((String)this.lookupDefaultSku().getTaxCode())) {
                return this.lookupDefaultSku().getTaxCode();
            }
            if (this.getProduct() != null && this.getProduct().getDefaultCategory() != null) {
                return this.getProduct().getDefaultCategory().getTaxCode();
            }
        }
        return this.taxCode;
    }

    @Override
    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public String getUpc() {
        return this.upc;
    }

    @Override
    public void setUpc(String upc) {
        this.upc = upc;
    }

    public <G extends Sku> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        Object clonedEntry;
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        Sku cloned = (Sku)createResponse.getClone();
        cloned.setRetailPrice(this.getRetailPrice());
        cloned.setSalePrice(this.getSalePrice());
        cloned.setName(this.name);
        cloned.setActiveEndDate(this.activeEndDate);
        cloned.setActiveStartDate(this.activeStartDate);
        cloned.setCurrency(this.currency);
        cloned.setQuantityAvailable(this.quantityAvailable);
        cloned.setDescription(this.description);
        cloned.setDimension(this.dimension);
        cloned.setDiscountable(this.isDiscountable());
        cloned.setDisplayTemplate(this.displayTemplate);
        cloned.setExternalId(this.externalId);
        cloned.setTaxable(this.isTaxable());
        cloned.setTaxCode(this.taxCode);
        cloned.setUrlKey(this.urlKey);
        cloned.setInventoryType(this.getInventoryType());
        cloned.setFulfillmentType(this.getFulfillmentType());
        cloned.setIsMachineSortable(this.isMachineSortable);
        cloned.setLongDescription(this.longDescription);
        cloned.setUpc(this.upc);
        if (this.product != null) {
            cloned.setDefaultProduct((Product)this.product.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.product != null) {
            cloned.setProduct((Product)this.product.createOrRetrieveCopyInstance(context).getClone());
        }
        for (Map.Entry<String, SkuAttribute> entry : this.skuAttributes.entrySet()) {
            clonedEntry = (SkuAttribute)entry.getValue().createOrRetrieveCopyInstance(context).getClone();
            cloned.getSkuAttributes().put(entry.getKey(), (SkuAttribute)clonedEntry);
        }
        for (SkuProductOptionValueXref skuProductOptionValueXref : this.productOptionValueXrefs) {
            clonedEntry = (SkuProductOptionValueXref)skuProductOptionValueXref.createOrRetrieveCopyInstance(context).getClone();
            cloned.getProductOptionValueXrefs().add((SkuProductOptionValueXref)clonedEntry);
        }
        for (Map.Entry entry : this.skuMedia.entrySet()) {
            clonedEntry = (SkuMediaXrefImpl)((SkuMediaXrefImpl)entry.getValue()).createOrRetrieveCopyInstance(context).getClone();
            cloned.getSkuMediaXrefIgnoreDefaultSku().put((String)entry.getKey(), (SkuMediaXref)clonedEntry);
        }
        for (FulfillmentOption fulfillmentOption : this.excludedFulfillmentOptions) {
            clonedEntry = (FulfillmentOption)fulfillmentOption.createOrRetrieveCopyInstance(context).getClone();
            cloned.getExcludedFulfillmentOptions().add((FulfillmentOption)clonedEntry);
        }
        for (Map.Entry entry : this.fulfillmentFlatRates.entrySet()) {
            clonedEntry = (FulfillmentOption)((FulfillmentOption)entry.getKey()).createOrRetrieveCopyInstance(context).getClone();
            cloned.getFulfillmentFlatRates().put((FulfillmentOption)clonedEntry, (BigDecimal)entry.getValue());
        }
        return createResponse;
    }
}

