/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_ATTRIBUTE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(friendlyName="ProductAttributeImpl_baseProductAttribute")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"}, skipOverlaps=true)})
public class ProductAttributeImpl
implements ProductAttribute {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductAttributeId")
    @GenericGenerator(name="ProductAttributeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="ProductAttributeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductAttributeImpl")})
    @Column(name="PRODUCT_ATTRIBUTE_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @Index(name="PRODUCTATTRIBUTE_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected String name;
    @Column(name="VALUE")
    @AdminPresentation(friendlyName="ProductAttributeImpl_Attribute_Value", order=2, group="ProductAttributeImpl_Description", prominent=true)
    protected String value;
    @Column(name="SEARCHABLE")
    @AdminPresentation(excluded=true)
    protected Boolean searchable = false;
    @ManyToOne(targetEntity=ProductImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PRODUCT_ID")
    @Index(name="PRODUCTATTRIBUTE_INDEX", columnNames={"PRODUCT_ID"})
    protected Product product;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getValue() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"value", (String)this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getSearchable() {
        if (this.searchable == null) {
            return Boolean.FALSE;
        }
        return this.searchable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    public String getName() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"name", (String)this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.product == null ? 0 : this.product.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProductAttributeImpl other = (ProductAttributeImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.product == null ? other.product != null : !this.product.equals(other.product)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public <G extends ProductAttribute> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        ProductAttribute cloned = (ProductAttribute)createResponse.getClone();
        if (this.product != null) {
            cloned.setProduct((Product)this.product.createOrRetrieveCopyInstance(context).getClone());
        }
        cloned.setName(this.name);
        cloned.setSearchable(this.searchable);
        cloned.setValue((Serializable)((Object)this.value));
        return createResponse;
    }
}

