/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.dao.TypedQueryBuilder;
import org.broadleafcommerce.core.catalog.dao.CategoryDao;
import org.broadleafcommerce.core.catalog.dao.CategoryDaoExtensionHandler;
import org.broadleafcommerce.core.catalog.dao.CategoryDaoExtensionManager;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.springframework.stereotype.Repository;

@Repository(value="blCategoryDao")
public class CategoryDaoImpl
implements CategoryDao {
    protected Long currentDateResolution = 10000L;
    protected Date cachedDate = SystemTime.asDate();
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;
    @Resource(name="blCategoryDaoExtensionManager")
    protected CategoryDaoExtensionManager extensionManager;

    protected Date getCurrentDateAfterFactoringInDateResolution() {
        Date returnDate = SystemTime.getCurrentDateWithinTimeResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        if (returnDate != this.cachedDate && SystemTime.shouldCacheDate()) {
            this.cachedDate = returnDate;
        }
        return returnDate;
    }

    @Override
    public Category save(Category category) {
        return (Category)this.em.merge((Object)category);
    }

    @Override
    public Category readCategoryById(Long categoryId) {
        return (Category)this.em.find(CategoryImpl.class, (Object)categoryId);
    }

    @Override
    public Category readCategoryByExternalId(@Nonnull String externalId) {
        TypedQuery query = new TypedQueryBuilder(Category.class, "cat").addRestriction("cat.externalId", "=", (Object)externalId).toQuery(this.em);
        try {
            return (Category)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    @Deprecated
    public Category readCategoryByName(String categoryName) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME");
        query.setParameter("categoryName", (Object)categoryName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return (Category)query.getSingleResult();
    }

    @Override
    public List<Category> readAllParentCategories() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Category.class);
        Root category = criteria.from(CategoryImpl.class);
        criteria.select((Selection)category);
        criteria.where((Expression)builder.isNull((Expression)category.get("defaultParentCategory")));
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Category> readCategoriesByName(String categoryName) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME", Category.class);
        query.setParameter("categoryName", (Object)categoryName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Category> readCategoriesByName(String categoryName, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CATEGORY_BY_NAME", Category.class);
        query.setParameter("categoryName", (Object)categoryName);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Category> readAllCategories() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_CATEGORIES", Category.class);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Category> readAllCategories(int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_CATEGORIES", Category.class);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Product> readAllProducts() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_PRODUCTS", Product.class);
        return query.getResultList();
    }

    @Override
    public List<Product> readAllProducts(int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_PRODUCTS", Product.class);
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Category> readAllSubCategories(Category category) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_SUBCATEGORIES", Category.class);
        query.setParameter("parentCategoryId", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, new Long[]{category.getId()}));
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Category> readAllSubCategories(Category category, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_SUBCATEGORIES", Category.class);
        query.setParameter("parentCategoryId", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, new Long[]{category.getId()}));
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public List<Category> readActiveSubCategoriesByCategory(Category category) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_SUBCATEGORIES_BY_CATEGORY", Category.class);
        query.setParameter("parentCategoryId", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, new Long[]{category.getId()}));
        query.setParameter("currentDate", (Object)this.getCurrentDateAfterFactoringInDateResolution());
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public List<Category> readActiveSubCategoriesByCategory(Category category, int limit, int offset) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ACTIVE_SUBCATEGORIES_BY_CATEGORY", Category.class);
        query.setParameter("parentCategoryId", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, new Long[]{category.getId()}));
        query.setParameter("currentDate", (Object)this.getCurrentDateAfterFactoringInDateResolution());
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        return query.getResultList();
    }

    @Override
    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    @Override
    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }

    @Override
    public void delete(Category category) {
        ((Status)category).setArchived(Character.valueOf('Y'));
        this.em.merge((Object)category);
    }

    @Override
    public Category create() {
        return (Category)this.entityConfiguration.createEntityInstance(Category.class.getName());
    }

    @Override
    public Category findCategoryByURI(String uri) {
        if (this.extensionManager != null) {
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((CategoryDaoExtensionHandler)this.extensionManager.getProxy()).findCategoryByURI(uri, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (Category)holder.getResult();
            }
        }
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_OUTGOING_URL");
        query.setParameter("currentDate", (Object)this.getCurrentDateAfterFactoringInDateResolution());
        query.setParameter("url", (Object)uri);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        List results = query.getResultList();
        if (results != null && !results.isEmpty()) {
            return (Category)results.get(0);
        }
        return null;
    }
}

