/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.site.domain.Catalog;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.search.dao.CatalogStructure;

public class SolrIndexCachedOperation {
    public static final Long DEFAULT_CATALOG_CACHE_KEY = 0L;
    private static final ThreadLocal<Map<Long, CatalogStructure>> CACHE = new ThreadLocal();

    public static CatalogStructure getCache() {
        Catalog currentCatalog;
        BroadleafRequestContext ctx = BroadleafRequestContext.getBroadleafRequestContext();
        Catalog catalog = currentCatalog = ctx == null ? null : ctx.getCurrentCatalog();
        if (currentCatalog != null) {
            return (CatalogStructure)MapUtils.getObject(CACHE.get(), (Object)currentCatalog.getId());
        }
        return (CatalogStructure)MapUtils.getObject(CACHE.get(), (Object)DEFAULT_CATALOG_CACHE_KEY);
    }

    public static void setCache(CatalogStructure cache) {
        BroadleafRequestContext ctx = BroadleafRequestContext.getBroadleafRequestContext();
        Catalog currentCatalog = ctx == null ? null : ctx.getCurrentCatalog();
        Map<Long, CatalogStructure> catalogCaches = CACHE.get();
        if (catalogCaches == null) {
            catalogCaches = new HashMap<Long, CatalogStructure>();
            CACHE.set(catalogCaches);
        }
        if (currentCatalog != null) {
            catalogCaches.put(currentCatalog.getId(), cache);
        } else {
            catalogCaches.put(DEFAULT_CATALOG_CACHE_KEY, cache);
        }
    }

    public static void clearCache() {
        CACHE.remove();
    }

    public static interface CacheOperation {
        public void execute() throws ServiceException;
    }
}

