/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jms.IllegalStateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.Group;
import org.apache.solr.client.solrj.response.GroupCommand;
import org.apache.solr.client.solrj.response.GroupResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.params.CoreAdminParams;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.util.BLCMapUtils;
import org.broadleafcommerce.common.util.TypedClosure;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.RequiredFacet;
import org.broadleafcommerce.core.search.domain.SearchCriteria;
import org.broadleafcommerce.core.search.domain.SearchFacet;
import org.broadleafcommerce.core.search.domain.SearchFacetDTO;
import org.broadleafcommerce.core.search.domain.SearchFacetRange;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="blSolrHelperService")
public class SolrHelperServiceImpl
implements SolrHelperService {
    private static final Log LOG = LogFactory.getLog(SolrHelperServiceImpl.class);
    protected static final String GLOBAL_FACET_TAG_FIELD = "a";
    protected static final String DEFAULT_NAMESPACE = "d";
    protected static final String[] specialCharacters = new String[]{"\\\\", "\\+", "-", "&&", "\\|\\|", "\\!", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", "\\^", "\"", "~", "\\*", "\\?", ":"};
    protected static final String PREFIX_SEPARATOR = "_";
    protected static Locale defaultLocale;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;

    @Override
    public synchronized void swapActiveCores() throws ServiceException {
        if (SolrContext.isSolrCloudMode()) {
            CloudSolrServer primary = (CloudSolrServer)SolrContext.getServer();
            CloudSolrServer reindex = (CloudSolrServer)SolrContext.getReindexServer();
            try {
                primary.connect();
                Aliases aliases = primary.getZkStateReader().getAliases();
                Map aliasCollectionMap = aliases.getCollectionAliasMap();
                if (aliasCollectionMap == null || !aliasCollectionMap.containsKey(primary.getDefaultCollection()) || !aliasCollectionMap.containsKey(reindex.getDefaultCollection())) {
                    throw new IllegalStateException("Could not determine the PRIMARY or REINDEX collection or collections from the Solr aliases.");
                }
                String primaryCollectionName = (String)aliasCollectionMap.get(primary.getDefaultCollection());
                primaryCollectionName = primaryCollectionName.split(",")[0];
                String reindexCollectionName = (String)aliasCollectionMap.get(reindex.getDefaultCollection());
                reindexCollectionName = reindexCollectionName.split(",")[0];
                CollectionAdminRequest.createAlias((String)primary.getDefaultCollection(), (String)reindexCollectionName, (SolrServer)primary);
                CollectionAdminRequest.createAlias((String)reindex.getDefaultCollection(), (String)primaryCollectionName, (SolrServer)primary);
            }
            catch (Exception e) {
                LOG.error((Object)"An exception occured swapping cores.", (Throwable)e);
                throw new ServiceException("Unable to swap SolrCloud collections after a full reindex.", (Throwable)e);
            }
        }
        if (SolrContext.isSingleCoreMode()) {
            LOG.debug((Object)"In single core mode. There are no cores to swap.");
        } else {
            LOG.debug((Object)"Swapping active cores");
            CoreAdminRequest car = new CoreAdminRequest();
            car.setCoreName("primary");
            car.setOtherCoreName("reindex");
            car.setAction(CoreAdminParams.CoreAdminAction.SWAP);
            try {
                SolrContext.getAdminServer().request((SolrRequest)car);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new ServiceException("Unable to swap cores", (Throwable)e);
            }
        }
    }

    @Override
    public String getCurrentNamespace() {
        return DEFAULT_NAMESPACE;
    }

    @Override
    public String getGlobalFacetTagField() {
        return GLOBAL_FACET_TAG_FIELD;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType, String prefix) {
        return prefix + field.getAbbreviation() + PREFIX_SEPARATOR + searchableFieldType.getType();
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field, String prefix) {
        if (field.getFacetFieldType() == null) {
            return null;
        }
        return prefix + field.getAbbreviation() + PREFIX_SEPARATOR + field.getFacetFieldType().getType();
    }

    @Override
    public List<FieldType> getSearchableFieldTypes(Field field) {
        ArrayList<FieldType> typesToConsider = new ArrayList<FieldType>();
        if (CollectionUtils.isNotEmpty(field.getSearchableFieldTypes())) {
            typesToConsider.addAll(field.getSearchableFieldTypes());
        }
        if (CollectionUtils.isEmpty(typesToConsider)) {
            typesToConsider.add(FieldType.TEXT);
        }
        return typesToConsider;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType) {
        ArrayList<String> prefixList = new ArrayList<String>();
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).buildPrefixListForSearchableField(field, searchableFieldType, prefixList);
        String prefix = this.convertPrefixListToString(prefixList);
        return this.getPropertyNameForFieldSearchable(field, searchableFieldType, prefix);
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field) {
        FieldType fieldType = field.getFacetFieldType();
        if (fieldType == null) {
            return null;
        }
        ArrayList<String> prefixList = new ArrayList<String>();
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).buildPrefixListForSearchableFacet(field, prefixList);
        String prefix = this.convertPrefixListToString(prefixList);
        return this.getPropertyNameForFieldFacet(field, prefix);
    }

    protected String convertPrefixListToString(List<String> prefixList) {
        StringBuilder prefixString = new StringBuilder();
        for (String prefix : prefixList) {
            if (prefix == null || prefix.isEmpty()) continue;
            prefixString = prefixString.append(prefix).append(PREFIX_SEPARATOR);
        }
        return prefixString.toString();
    }

    @Override
    public Long getCategoryId(Category category) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getCategoryId(category, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return category.getId();
    }

    @Override
    public Long getCategoryId(Long category) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getCategoryId(category, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return category;
    }

    @Override
    public Long getProductId(Product product) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getProductId(product, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return product.getId();
    }

    @Override
    public Long getSkuId(Sku sku) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getSkuId(sku, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return sku.getId();
    }

    @Override
    public String getSolrDocumentId(SolrInputDocument document, Product product) {
        String[] returnId = new String[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getSolrDocumentId(document, product, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return String.valueOf(product.getId());
    }

    @Override
    public String getSolrDocumentId(SolrInputDocument document, Sku sku) {
        return String.valueOf(sku.getId());
    }

    @Override
    public String getNamespaceFieldName() {
        return "namespace";
    }

    @Override
    public String getIdFieldName() {
        return "id";
    }

    @Override
    public String getProductIdFieldName() {
        return "productId";
    }

    @Override
    public String getSkuIdFieldName() {
        return "skuId";
    }

    @Override
    public String getCategoryFieldName() {
        return "category";
    }

    @Override
    public String getExplicitCategoryFieldName() {
        return "explicitCategory";
    }

    @Override
    public String getCatalogFieldName() {
        return "catalog_s";
    }

    @Override
    public String getCatalogOverridesFieldName() {
        return "catalog_overrides";
    }

    @Override
    public String getSandBoxFieldName() {
        return "sandboxId";
    }

    @Override
    public String getSandBoxPriorityFieldName() {
        return "sandboxPriority";
    }

    @Override
    public String getSandBoxChangeTypeFieldName() {
        return "sandboxChangeType_s";
    }

    @Override
    public String getCategorySortFieldName(Category category) {
        Long categoryId = this.getCategoryId(category);
        return this.getCategoryFieldName() + PREFIX_SEPARATOR + categoryId + PREFIX_SEPARATOR + "sort_d";
    }

    @Override
    public String getCategorySortFieldName(Long categoryId) {
        categoryId = this.getCategoryId(categoryId);
        return this.getCategoryFieldName() + PREFIX_SEPARATOR + categoryId + PREFIX_SEPARATOR + "sort_d";
    }

    @Override
    public String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + PREFIX_SEPARATOR;
        }
        return this.getDefaultLocalePrefix();
    }

    @Override
    public String getDefaultLocalePrefix() {
        return this.getDefaultLocale().getLocaleCode() + PREFIX_SEPARATOR;
    }

    @Override
    public Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = this.localeService.findDefaultLocale();
        }
        return defaultLocale;
    }

    @Override
    public Object getPropertyValue(Object object, Field field) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.getPropertyValue(object, field.getPropertyName());
    }

    @Override
    public Object getPropertyValue(Object object, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String[] components = propertyName.split("\\.");
        return this.getPropertyValueInternal(object, components, 0);
    }

    @Override
    public void optimizeIndex(SolrServer server) throws ServiceException, IOException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Optimizing the index...");
            }
            server.optimize();
        }
        catch (SolrServerException e) {
            throw new ServiceException("Could not optimize index", (Throwable)e);
        }
    }

    @Override
    public String scrubFacetValue(String facetValue) {
        String scrubbedFacetValue = facetValue;
        for (String character : specialCharacters) {
            scrubbedFacetValue = scrubbedFacetValue.replaceAll(character, "\\\\" + character);
        }
        return scrubbedFacetValue;
    }

    @Override
    public String sanitizeQuery(String query) {
        return query.replace("(", "").replace("%28", "").replace(")", "").replace("%29", "").replace(":", "").replace("%3A", "").replace("%3a", "").replace("&quot;", "\"");
    }

    @Override
    public List<SearchFacetDTO> buildSearchFacetDTOs(List<SearchFacet> searchFacets) {
        ArrayList<SearchFacetDTO> facets = new ArrayList<SearchFacetDTO>();
        Map requestParameters = BroadleafRequestContext.getRequestParameterMap();
        for (SearchFacet facet : searchFacets) {
            if (!this.isFacetAvailable(facet, requestParameters)) continue;
            SearchFacetDTO dto = new SearchFacetDTO();
            dto.setFacet(facet);
            dto.setShowQuantity(true);
            facets.add(dto);
        }
        return facets;
    }

    @Override
    public boolean isFacetAvailable(SearchFacet facet, Map<String, String[]> params) {
        if (CollectionUtils.isEmpty(facet.getRequiredFacets())) {
            return true;
        }
        if (MapUtils.isEmpty(params)) {
            return false;
        }
        int requiredMatches = facet.getRequiresAllDependentFacets() != false ? facet.getRequiredFacets().size() : 1;
        int matchesSoFar = 0;
        block0: for (RequiredFacet requiredFacet : facet.getRequiredFacets()) {
            if (requiredMatches == matchesSoFar) {
                return true;
            }
            for (Map.Entry<String, String[]> entry : params.entrySet()) {
                String key = entry.getKey();
                if (!key.equals(requiredFacet.getRequiredFacet().getField().getAbbreviation())) continue;
                ++matchesSoFar;
                continue block0;
            }
        }
        return requiredMatches == matchesSoFar;
    }

    @Override
    public String getSolrRangeString(String fieldName, BigDecimal minValue, BigDecimal maxValue) {
        StringBuilder sb = new StringBuilder();
        sb.append(fieldName).append(":[");
        if (minValue == null) {
            sb.append("*");
        } else {
            sb.append(minValue.toPlainString());
        }
        sb.append(" TO ");
        if (maxValue == null) {
            sb.append("*");
        } else {
            sb.append(maxValue.toPlainString());
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public String getSolrRangeFunctionString(BigDecimal minValue, BigDecimal maxValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("frange incl=false l=").append(minValue.toPlainString());
        if (maxValue != null) {
            sb.append(" u=").append(maxValue.toPlainString());
        }
        return sb.toString();
    }

    @Override
    public String getSolrFieldTag(String tagField, String tag, SearchFacetRange range) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)tag)) {
            sb.append("{!").append(tag).append("=").append(tagField);
            if (range != null) {
                sb.append("[").append(range.getMinValue().toPlainString()).append(":");
                if (range.getMaxValue() != null) {
                    sb.append(range.getMaxValue().toPlainString());
                } else {
                    sb.append("*");
                }
                sb.append("]");
                sb.append(" " + this.getSolrRangeFunctionString(range.getMinValue(), range.getMaxValue()));
            }
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public void setFacetResults(Map<String, SearchFacetDTO> namedFacetMap, QueryResponse response) {
        if (response.getFacetFields() != null) {
            for (FacetField facetField : response.getFacetFields()) {
                String facetFieldName = facetField.getName();
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                for (FacetField.Count value : facetField.getValues()) {
                    SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                    resultDTO.setFacet(facetDTO.getFacet());
                    resultDTO.setQuantity(new Long(value.getCount()).intValue());
                    resultDTO.setValue(value.getName());
                    facetDTO.getFacetValues().add(resultDTO);
                }
            }
        }
        if (response.getFacetQuery() != null) {
            for (Map.Entry entry : response.getFacetQuery().entrySet()) {
                String key = (String)entry.getKey();
                String facetFieldName = key.substring(0, key.indexOf("["));
                SearchFacetDTO facetDTO = namedFacetMap.get(facetFieldName);
                String minValue = key.substring(key.indexOf("[") + 1, key.indexOf(":"));
                String maxValue = key.substring(key.indexOf(":") + 1, key.indexOf("]"));
                if (maxValue.equals("*")) {
                    maxValue = null;
                }
                SearchFacetResultDTO resultDTO = new SearchFacetResultDTO();
                resultDTO.setFacet(facetDTO.getFacet());
                resultDTO.setQuantity((Integer)entry.getValue());
                resultDTO.setMinValue(new BigDecimal(minValue));
                resultDTO.setMaxValue(maxValue == null ? null : new BigDecimal(maxValue));
                facetDTO.getFacetValues().add(resultDTO);
            }
        }
    }

    @Override
    public void sortFacetResults(Map<String, SearchFacetDTO> namedFacetMap) {
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            Collections.sort(entry.getValue().getFacetValues(), new Comparator<SearchFacetResultDTO>(){

                @Override
                public int compare(SearchFacetResultDTO o1, SearchFacetResultDTO o2) {
                    if (o1.getValue() != null && o2.getValue() != null) {
                        return o1.getValue().compareTo(o2.getValue());
                    }
                    if (o1.getMinValue() != null && o2.getMinValue() != null) {
                        return o1.getMinValue().compareTo(o2.getMinValue());
                    }
                    return 0;
                }
            });
        }
    }

    @Override
    public void attachFacets(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap) {
        query.setFacet(true);
        for (Map.Entry<String, SearchFacetDTO> entry : namedFacetMap.entrySet()) {
            SearchFacetDTO dto = entry.getValue();
            ArrayList<SearchFacetRange> facetRanges = new ArrayList<SearchFacetRange>(dto.getFacet().getSearchFacetRanges());
            if (this.extensionManager != null) {
                ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).filterSearchFacetRanges(dto, facetRanges);
            }
            if (facetRanges != null && facetRanges.size() > 0) {
                for (SearchFacetRange range : facetRanges) {
                    query.addFacetQuery(this.getSolrTaggedFieldString(entry.getKey(), "key", range));
                }
                continue;
            }
            query.addFacetField(new String[]{this.getSolrTaggedFieldString(entry.getKey(), "ex", null)});
        }
    }

    @Override
    public String getSolrTaggedFieldString(String indexField, String tag, SearchFacetRange range) {
        return this.getSolrFieldTag(indexField, tag, range) + (range == null ? indexField : "field(" + indexField + ")");
    }

    @Override
    public List<SolrDocument> getResponseDocuments(QueryResponse response) {
        Object docs;
        if (response.getGroupResponse() == null) {
            docs = response.getResults();
        } else {
            docs = new ArrayList();
            GroupResponse gr = response.getGroupResponse();
            for (GroupCommand gc : gr.getValues()) {
                for (Group g : gc.getValues()) {
                    for (SolrDocument d : g.getResult()) {
                        docs.add(d);
                    }
                }
            }
        }
        return docs;
    }

    @Override
    public void attachSortClause(SolrQuery query, SearchCriteria searchCriteria, String defaultSort, List<Field> fields) {
        Map<String, String> solrFieldKeyMap = this.getSolrFieldKeyMap(searchCriteria, fields);
        String sortQuery = searchCriteria.getSortQuery();
        if (StringUtils.isBlank((String)sortQuery)) {
            sortQuery = defaultSort;
        }
        if (StringUtils.isNotBlank((String)sortQuery)) {
            String[] sortFields;
            for (String sortField : sortFields = sortQuery.split(",")) {
                String field = sortField.split(" ")[0];
                if (solrFieldKeyMap.containsKey(field)) {
                    field = solrFieldKeyMap.get(field);
                }
                SolrQuery.ORDER order = SolrQuery.ORDER.asc;
                String[] sortFieldsSegments = sortField.split(" ");
                if (sortFieldsSegments.length < 2) {
                    StringBuilder msg = new StringBuilder().append("Solr sortquery received was " + sortQuery + ", but no sorting tokens could be extracted.");
                    msg.append("\nDefaulting to ASCending");
                    LOG.warn((Object)msg.toString());
                } else if ("desc".equals(sortFieldsSegments[1])) {
                    order = SolrQuery.ORDER.desc;
                }
                if (field == null) continue;
                query.addSort(new SolrQuery.SortClause(field, order));
            }
        }
    }

    @Override
    public Map<String, String> getSolrFieldKeyMap(SearchCriteria searchCriteria, List<Field> fields) {
        HashMap<String, String> solrFieldKeyMap = new HashMap<String, String>();
        for (Field field : fields) {
            solrFieldKeyMap.put(field.getAbbreviation(), this.getPropertyNameForFieldFacet(field));
        }
        return solrFieldKeyMap;
    }

    @Override
    public Map<String, SearchFacetDTO> getNamedFacetMap(List<SearchFacetDTO> facets, SearchCriteria searchCriteria) {
        return BLCMapUtils.keyedMap(facets, (TypedClosure)new TypedClosure<String, SearchFacetDTO>(){

            public String getKey(SearchFacetDTO facet) {
                return SolrHelperServiceImpl.this.getPropertyNameForFieldFacet(facet.getFacet().getField());
            }
        });
    }

    @Override
    public void attachActiveFacetFilters(SolrQuery query, Map<String, SearchFacetDTO> namedFacetMap, SearchCriteria searchCriteria) {
        if (searchCriteria.getFilterCriteria() != null) {
            for (Map.Entry<String, String[]> entry : searchCriteria.getFilterCriteria().entrySet()) {
                String solrKey = null;
                for (Map.Entry<String, SearchFacetDTO> dtoEntry : namedFacetMap.entrySet()) {
                    if (!dtoEntry.getValue().getFacet().getField().getAbbreviation().equals(entry.getKey())) continue;
                    solrKey = dtoEntry.getKey();
                    dtoEntry.getValue().setActive(true);
                }
                if (solrKey == null) continue;
                Object[] selectedValues = (String[])entry.getValue().clone();
                boolean rangeQuery = false;
                for (int i = 0; i < selectedValues.length; ++i) {
                    if (selectedValues[i].contains("range[")) {
                        rangeQuery = true;
                        String rangeValue = selectedValues[i].substring(selectedValues[i].indexOf(91) + 1, ((String)selectedValues[i]).indexOf(93));
                        String[] rangeValues = StringUtils.split((String)rangeValue, (char)':');
                        BigDecimal minValue = new BigDecimal(rangeValues[0]);
                        BigDecimal maxValue = null;
                        if (!rangeValues[1].equals("null")) {
                            maxValue = new BigDecimal(rangeValues[1]);
                        }
                        selectedValues[i] = this.getSolrRangeString(solrKey, minValue, maxValue);
                        continue;
                    }
                    selectedValues[i] = "\"" + this.scrubFacetValue((String)selectedValues[i]) + "\"";
                }
                StringBuilder valueString = new StringBuilder();
                if (rangeQuery) {
                    valueString.append(solrKey).append(":(");
                    valueString.append(StringUtils.join((Object[])selectedValues, (String)" OR "));
                    valueString.append(")");
                } else {
                    valueString.append("{!tag=").append(solrKey).append("}");
                    valueString.append(solrKey).append(":(");
                    valueString.append(StringUtils.join((Object[])selectedValues, (String)" OR "));
                    valueString.append(")");
                }
                query.addFilterQuery(new String[]{valueString.toString()});
            }
        }
    }

    protected Object getPropertyValueInternal(Object object, String[] components, int currentPosition) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (object == null) {
            return null;
        }
        boolean isPropertyReadable = PropertyUtils.isReadable((Object)object, (String)components[currentPosition]);
        if (!isPropertyReadable) {
            LOG.debug((Object)String.format("Could not find %s on %s, assuming this exists elsewhere in the class hierarchy", components[currentPosition], object.getClass().getName()));
            return null;
        }
        HashSet<Object> propertyObject = PropertyUtils.getProperty((Object)object, (String)components[currentPosition]);
        if (propertyObject != null && currentPosition < components.length - 1) {
            if (Collection.class.isAssignableFrom(propertyObject.getClass())) {
                Collection collection = propertyObject;
                HashSet<Object> newCollection = new HashSet<Object>();
                for (Object item : collection) {
                    Object result = this.getPropertyValueInternal(item, components, currentPosition + 1);
                    if (result == null) continue;
                    this.copyPropertyToCollection(newCollection, result);
                }
                propertyObject = newCollection;
            } else if (Map.class.isAssignableFrom(propertyObject.getClass())) {
                Map map = (Map)((Object)propertyObject);
                HashSet<Object> newCollection = new HashSet<Object>();
                for (Object item : map.values()) {
                    Object result = this.getPropertyValueInternal(item, components, currentPosition + 1);
                    if (result == null) continue;
                    this.copyPropertyToCollection(newCollection, result);
                }
                propertyObject = newCollection;
            } else if (propertyObject.getClass().isArray()) {
                Object[] array = (Object[])propertyObject;
                HashSet<Object> newCollection = new HashSet<Object>();
                for (Object item : array) {
                    Object result = this.getPropertyValueInternal(item, components, currentPosition + 1);
                    if (result == null) continue;
                    this.copyPropertyToCollection(newCollection, result);
                }
                propertyObject = newCollection;
            } else {
                propertyObject = this.getPropertyValueInternal(propertyObject, components, currentPosition + 1);
            }
        }
        return propertyObject;
    }

    protected void copyPropertyToCollection(Collection<Object> collection, Object o) {
        if (o == null) {
            return;
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            collection.addAll((Collection)o);
        } else if (Map.class.isAssignableFrom(o.getClass())) {
            collection.addAll(((Map)o).values());
        } else if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            if (array.length > 0) {
                for (Object obj : array) {
                    collection.add(obj);
                }
            }
        } else {
            collection.add(o);
        }
    }
}

