/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.extension.ResultType;
import org.broadleafcommerce.common.i18n.domain.TranslatedEntity;
import org.broadleafcommerce.common.i18n.service.TranslationBatchReadCache;
import org.broadleafcommerce.common.i18n.service.TranslationConsiderationContext;
import org.broadleafcommerce.common.i18n.service.TranslationService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.AbstractSolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="blI18nSolrSearchServiceExtensionHandler")
public class I18nSolrSearchServiceExtensionHandler
extends AbstractSolrSearchServiceExtensionHandler
implements SolrSearchServiceExtensionHandler {
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    @Resource(name="blTranslationService")
    protected TranslationService translationService;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;

    protected boolean getTranslationEnabled() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"i18n.translation.enabled");
    }

    @PostConstruct
    public void init() {
        boolean shouldAdd = true;
        for (SolrSearchServiceExtensionHandler h : this.extensionManager.getHandlers()) {
            if (!(h instanceof I18nSolrSearchServiceExtensionHandler)) continue;
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            this.extensionManager.getHandlers().add(this);
        }
    }

    @Override
    public ExtensionResultStatusType buildPrefixListForSearchableFacet(Field field, List<String> prefixList) {
        return this.getLocalePrefix(field, prefixList);
    }

    @Override
    public ExtensionResultStatusType buildPrefixListForSearchableField(Field field, FieldType searchableFieldType, List<String> prefixList) {
        return this.getLocalePrefix(field, prefixList);
    }

    @Override
    public ExtensionResultStatusType addPropertyValues(Product product, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.addPropertyValues(product, null, false, field, fieldType, values, propertyName, locales);
    }

    @Override
    public ExtensionResultStatusType addPropertyValues(Sku sku, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.addPropertyValues(null, sku, true, field, fieldType, values, propertyName, locales);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExtensionResultStatusType addPropertyValues(Product product, Sku sku, boolean useSku, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashSet processedLocaleCodes = new HashSet();
        ExtensionResultStatusType result = ExtensionResultStatusType.NOT_HANDLED;
        if (field.getTranslatable().booleanValue()) {
            result = ExtensionResultStatusType.HANDLED;
            TranslationConsiderationContext.setTranslationConsiderationContext((Boolean)this.getTranslationEnabled());
            TranslationConsiderationContext.setTranslationService((TranslationService)this.translationService);
            BroadleafRequestContext tempContext = BroadleafRequestContext.getBroadleafRequestContext();
            if (tempContext == null) {
                tempContext = new BroadleafRequestContext();
                BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)tempContext);
            }
            Locale originalLocale = tempContext.getLocale();
            try {
                for (Locale locale : locales) {
                    int pos;
                    tempContext.setLocale(locale);
                    Object propertyValue = useSku ? this.shs.getPropertyValue((Object)sku, propertyName) : this.shs.getPropertyValue((Object)product, propertyName);
                    String localeCode = locale.getLocaleCode();
                    if (Boolean.FALSE.equals(locale.getUseCountryInSearchIndex()) && (pos = localeCode.indexOf("_")) > 0) {
                        localeCode = localeCode.substring(0, pos);
                    }
                    values.put(localeCode, propertyValue);
                }
            }
            finally {
                tempContext.setLocale(originalLocale);
            }
        }
        return result;
    }

    protected ExtensionResultStatusType getLocalePrefix(Field field, List<String> prefixList) {
        Locale locale;
        if (field.getTranslatable().booleanValue() && BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            int pos;
            String localeCode = locale.getLocaleCode();
            if (Boolean.FALSE.equals(locale.getUseCountryInSearchIndex()) && (pos = localeCode.indexOf("_")) > 0) {
                localeCode = localeCode.substring(0, pos);
            }
            prefixList.add(localeCode);
            return ExtensionResultStatusType.HANDLED_CONTINUE;
        }
        return ExtensionResultStatusType.NOT_HANDLED;
    }

    @Override
    public ExtensionResultStatusType startBatchEvent(List<Product> products) {
        ArrayList<String> skuIds = new ArrayList<String>(products.size());
        ArrayList<String> productIds = new ArrayList<String>();
        ArrayList<String> skuAttributeIds = new ArrayList<String>();
        ArrayList<String> productAttributeIds = new ArrayList<String>();
        for (Product indexable : products) {
            Sku sku = null;
            if (Product.class.isAssignableFrom(indexable.getClass())) {
                Product product = indexable;
                productIds.add(product.getId().toString());
                for (Map.Entry<String, ProductAttribute> attributeEntry : product.getProductAttributes().entrySet()) {
                    ProductAttribute attribute = attributeEntry.getValue();
                    productAttributeIds.add(attribute.getId().toString());
                }
                sku = product.getDefaultSku();
            }
            if (sku == null) continue;
            skuIds.add(sku.getId().toString());
            for (Map.Entry<String, SkuAttribute> attributeEntry : sku.getSkuAttributes().entrySet()) {
                SkuAttribute attribute = attributeEntry.getValue();
                skuAttributeIds.add(attribute.getId().toString());
            }
        }
        this.addEntitiesToTranslationCache(skuIds, TranslatedEntity.SKU);
        this.addEntitiesToTranslationCache(productIds, TranslatedEntity.PRODUCT);
        this.addEntitiesToTranslationCache(skuAttributeIds, TranslatedEntity.SKU_ATTRIBUTE);
        this.addEntitiesToTranslationCache(productAttributeIds, TranslatedEntity.PRODUCT_ATTRIBUTE);
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    protected void addEntitiesToTranslationCache(List<String> entityIds, TranslatedEntity translatedEntity) {
        List translations = this.translationService.findAllTranslationEntries(translatedEntity, ResultType.STANDARD, entityIds);
        TranslationBatchReadCache.addToCache((List)translations);
    }

    @Override
    public ExtensionResultStatusType endBatchEvent() {
        TranslationBatchReadCache.clearCache();
        return ExtensionResultStatusType.HANDLED_CONTINUE;
    }

    public int getPriority() {
        return 1000;
    }
}

