/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.domain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.FieldEntity;
import org.broadleafcommerce.core.search.domain.SearchConfig;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FIELD")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class FieldImpl
implements Field,
Serializable,
AdminMainEntity {
    private static final long serialVersionUID = 2915813511754425605L;
    @Id
    @GeneratedValue(generator="FieldId")
    @GenericGenerator(name="FieldId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="FieldImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.search.domain.FieldImpl")})
    @Column(name="FIELD_ID")
    @AdminPresentation(friendlyName="FieldImpl_ID", group="FieldImpl_descrpition", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @AdminPresentation(friendlyName="FieldImpl_EntityType", group="FieldImpl_descrpition", order=2, prominent=true)
    @Column(name="ENTITY_TYPE", nullable=false)
    @Index(name="ENTITY_TYPE_INDEX", columnNames={"ENTITY_TYPE"})
    protected String entityType;
    @Column(name="FRIENDLY_NAME")
    @AdminPresentation(friendlyName="FieldImpl_friendlyName", group="FieldImpl_descrpition", order=1, prominent=true, translatable=true)
    protected String friendlyName;
    @Column(name="PROPERTY_NAME", nullable=false)
    @AdminPresentation(friendlyName="FieldImpl_propertyName", group="FieldImpl_descrpition", order=2)
    protected String propertyName;
    @Column(name="ABBREVIATION")
    @AdminPresentation(friendlyName="FieldImpl_abbreviation", group="FieldImpl_descrpition", order=3)
    protected String abbreviation;
    @Column(name="SEARCHABLE")
    @AdminPresentation(friendlyName="FieldImpl_searchable", group="FieldImpl_descrpition", order=4)
    protected Boolean searchable = false;
    @Column(name="FACET_FIELD_TYPE")
    @AdminPresentation(friendlyName="FieldImpl_facetFieldType", group="FieldImpl_descrpition", excluded=true)
    protected String facetFieldType;
    @ElementCollection
    @CollectionTable(name="BLC_FIELD_SEARCH_TYPES", joinColumns={@JoinColumn(name="FIELD_ID")})
    @Column(name="SEARCHABLE_FIELD_TYPE")
    @Cascade(value={CascadeType.MERGE, CascadeType.PERSIST})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @BatchSize(size=50)
    protected List<String> searchableFieldTypes = new ArrayList<String>();
    @Column(name="TRANSLATABLE")
    @AdminPresentation(friendlyName="FieldImpl_translatable", group="FieldImpl_description")
    protected Boolean translatable = false;

    @Override
    public String getQualifiedFieldName() {
        return this.getEntityType().getFriendlyType() + "." + this.propertyName;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public FieldEntity getEntityType() {
        return FieldEntity.getInstance(this.entityType);
    }

    @Override
    public void setEntityType(FieldEntity entityType) {
        this.entityType = entityType.getType();
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getFriendlyName() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"friendlyName", (String)this.friendlyName);
    }

    @Override
    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Override
    public Boolean getSearchable() {
        return this.searchable;
    }

    @Override
    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public FieldType getFacetFieldType() {
        return FieldType.getInstance(this.facetFieldType);
    }

    @Override
    public void setFacetFieldType(FieldType facetFieldType) {
        this.facetFieldType = facetFieldType == null ? null : facetFieldType.getType();
    }

    @Override
    public List<FieldType> getSearchableFieldTypes() {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (String fieldType : this.searchableFieldTypes) {
            fieldTypes.add(FieldType.getInstance(fieldType));
        }
        return fieldTypes;
    }

    @Override
    public void setSearchableFieldTypes(List<FieldType> searchableFieldTypes) {
        ArrayList<String> fieldTypes = new ArrayList<String>();
        for (FieldType fieldType : searchableFieldTypes) {
            fieldTypes.add(fieldType.getType());
        }
        this.searchableFieldTypes = fieldTypes;
    }

    @Override
    public Boolean getTranslatable() {
        return this.translatable == null ? false : this.translatable;
    }

    @Override
    public void setTranslatable(Boolean translatable) {
        this.translatable = translatable;
    }

    @Override
    public List<SearchConfig> getSearchConfigs() {
        throw new UnsupportedOperationException("The default Field implementation does not support search configs");
    }

    @Override
    public void setSearchConfigs(List<SearchConfig> searchConfigs) {
        throw new UnsupportedOperationException("The default Field implementation does not support search configs");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        Field other = (Field)obj;
        return this.getEntityType().getType().equals(other.getEntityType().getType()) && this.getPropertyName().equals(other.getPropertyName());
    }

    public String getMainEntityName() {
        return this.getFriendlyName();
    }

    public <G extends Field> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        Field cloned = (Field)createResponse.getClone();
        cloned.setAbbreviation(this.abbreviation);
        cloned.setFacetFieldType(this.getFacetFieldType());
        cloned.setFriendlyName(this.friendlyName);
        cloned.setPropertyName(this.propertyName);
        cloned.setSearchable(this.searchable);
        cloned.setTranslatable(this.translatable);
        for (String entry : this.searchableFieldTypes) {
            ((FieldImpl)cloned).searchableFieldTypes.add(entry);
        }
        cloned.setEntityType(this.getEntityType());
        return createResponse;
    }
}

