/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.dao;

import com.google.common.collect.BiMap;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.search.dao.CatalogStructure;
import org.broadleafcommerce.core.search.dao.ParentCategoryByCategory;
import org.broadleafcommerce.core.search.dao.ParentCategoryByProduct;
import org.broadleafcommerce.core.search.dao.SolrIndexDao;
import org.springframework.stereotype.Repository;

@Repository(value="blSolrIndexDao")
public class SolrIndexDaoImpl
implements SolrIndexDao {
    protected static final Log LOG = LogFactory.getLog(SolrIndexDaoImpl.class);
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populateProductCatalogStructure(List<Long> productIds, CatalogStructure catalogStructure) {
        BroadleafRequestContext context = BroadleafRequestContext.getBroadleafRequestContext();
        Boolean oldIgnoreFilters = context.getInternalIgnoreFilters();
        context.setInternalIgnoreFilters(Boolean.valueOf(false));
        try {
            HashMap parentCategoriesByProduct = new HashMap();
            HashMap<Long, Set<Long>> parentCategoriesByCategory = new HashMap<Long, Set<Long>>();
            Long[] products = productIds.toArray(new Long[productIds.size()]);
            BiMap sandBoxProductToOriginalMap = this.sandBoxHelper.getSandBoxToOriginalMap(ProductImpl.class, products);
            int batchSize = 800;
            int count = 0;
            int pos = 0;
            while (pos < products.length) {
                int remaining = products.length - pos;
                int mySize = remaining > batchSize ? batchSize : remaining;
                Long[] temp = new Long[mySize];
                System.arraycopy(products, pos, temp, 0, mySize);
                TypedQuery query = this.em.createNamedQuery("BC_READ_PARENT_CATEGORY_IDS_BY_PRODUCTS", ParentCategoryByProduct.class);
                query.setParameter("productIds", (Object)this.sandBoxHelper.mergeCloneIds(ProductImpl.class, temp));
                List results = query.getResultList();
                for (ParentCategoryByProduct parentCategoryByProduct : results) {
                    Long sandBoxProductVal = parentCategoryByProduct.getProduct();
                    BiMap reverse = sandBoxProductToOriginalMap.inverse();
                    if (reverse.containsKey((Object)sandBoxProductVal)) {
                        sandBoxProductVal = (Long)reverse.get((Object)sandBoxProductVal);
                    }
                    if (!catalogStructure.getParentCategoriesByProduct().containsKey(sandBoxProductVal)) {
                        Long sandBoxVal;
                        if (!parentCategoriesByProduct.containsKey(sandBoxProductVal)) {
                            parentCategoriesByProduct.put(sandBoxProductVal, new HashSet());
                        }
                        if ((sandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, parentCategoryByProduct.getCategory())) == null) {
                            sandBoxVal = parentCategoryByProduct.getCategory();
                        }
                        ((Set)parentCategoriesByProduct.get(sandBoxProductVal)).add(sandBoxVal);
                    }
                    BigDecimal displayOrder = parentCategoryByProduct.getDisplayOrder() == null ? new BigDecimal("1.00000") : parentCategoryByProduct.getDisplayOrder();
                    catalogStructure.getDisplayOrdersByCategoryProduct().put(parentCategoryByProduct.getCategory() + "-" + parentCategoryByProduct.getProduct(), displayOrder);
                }
                for (Map.Entry entry : parentCategoriesByProduct.entrySet()) {
                    for (Long categoryId : (Set)entry.getValue()) {
                        if (catalogStructure.getParentCategoriesByCategory().containsKey(categoryId)) continue;
                        HashSet hierarchy = new HashSet();
                        parentCategoriesByCategory.put(categoryId, hierarchy);
                    }
                }
                pos = ++count * batchSize < products.length ? count * batchSize : products.length;
            }
            this.readFullCategoryHierarchy(parentCategoriesByCategory, new HashSet<Long>());
            catalogStructure.getParentCategoriesByProduct().putAll(parentCategoriesByProduct);
            catalogStructure.getParentCategoriesByCategory().putAll(parentCategoriesByCategory);
        }
        finally {
            context.setInternalIgnoreFilters(oldIgnoreFilters);
        }
    }

    protected void readFullCategoryHierarchy(Map<Long, Set<Long>> categoryHierarchy, Set<Long> builtCategories) {
        HashMap<Long, Set<Long>> nextLevel = new HashMap<Long, Set<Long>>();
        Long[] categoryIds = categoryHierarchy.keySet().toArray(new Long[categoryHierarchy.keySet().size()]);
        int batchSize = 800;
        int count = 0;
        int pos = 0;
        while (pos < categoryIds.length) {
            int remaining = categoryIds.length - pos;
            int mySize = remaining > batchSize ? batchSize : remaining;
            Long[] temp = new Long[mySize];
            System.arraycopy(categoryIds, pos, temp, 0, mySize);
            TypedQuery query = this.em.createNamedQuery("BC_READ_PARENT_CATEGORY_IDS_BY_CATEGORIES", ParentCategoryByCategory.class);
            query.setParameter("categoryIds", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, temp));
            List results = query.getResultList();
            for (ParentCategoryByCategory item : results) {
                Long sandBoxVal;
                Long childSandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, item.getChild());
                if (childSandBoxVal == null) {
                    childSandBoxVal = item.getChild();
                }
                if (builtCategories.contains(childSandBoxVal)) {
                    LOG.warn((Object)("Category circular reference identified for category id " + childSandBoxVal));
                    continue;
                }
                builtCategories.add(childSandBoxVal);
                Set<Long> hierarchy = categoryHierarchy.get(childSandBoxVal);
                if (item.getParent() != null) {
                    sandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, item.getParent());
                    if (sandBoxVal == null) {
                        sandBoxVal = item.getParent();
                    }
                    hierarchy.add(sandBoxVal);
                    if (!nextLevel.containsKey(sandBoxVal)) {
                        nextLevel.put(sandBoxVal, new HashSet());
                    }
                }
                if (item.getDefaultParent() == null) continue;
                sandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, item.getDefaultParent());
                if (sandBoxVal == null) {
                    sandBoxVal = item.getDefaultParent();
                }
                hierarchy.add(sandBoxVal);
                if (nextLevel.containsKey(sandBoxVal)) continue;
                nextLevel.put(sandBoxVal, new HashSet());
            }
            pos = ++count * batchSize < categoryIds.length ? count * batchSize : categoryIds.length;
        }
        if (!nextLevel.isEmpty()) {
            this.readFullCategoryHierarchy(nextLevel, builtCategories);
            nextLevel.keySet().removeAll(categoryHierarchy.keySet());
        }
        categoryHierarchy.putAll(nextLevel);
    }
}

