/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.payment.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentGatewayType;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderImpl;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.domain.PaymentTransactionImpl;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_PAYMENT")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="billingAddress", mergeEntries={@AdminPresentationMergeEntry(propertyType="tab", overrideValue="FulfillmentGroupImpl_Address_Tab"), @AdminPresentationMergeEntry(propertyType="tabOrder", intOverrideValue=4000)}), @AdminPresentationMergeOverride(name="billingAddress.isDefault", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="billingAddress.isActive", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="billingAddress.isBusiness", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="OrderPaymentImpl_baseOrderPayment")
@SQLDelete(sql="UPDATE BLC_ORDER_PAYMENT SET ARCHIVED = 'Y' WHERE ORDER_PAYMENT_ID = ?")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class OrderPaymentImpl
implements OrderPayment,
CurrencyCodeIdentifiable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderPaymentId")
    @GenericGenerator(name="OrderPaymentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderPaymentImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.payment.domain.OrderPaymentImpl")})
    @Column(name="ORDER_PAYMENT_ID")
    protected Long id;
    @ManyToOne(targetEntity=OrderImpl.class, optional=true)
    @JoinColumn(name="ORDER_ID", nullable=true)
    @Index(name="ORDERPAYMENT_ORDER_INDEX", columnNames={"ORDER_ID"})
    @AdminPresentation(excluded=true)
    protected Order order;
    @ManyToOne(targetEntity=AddressImpl.class, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="ADDRESS_ID")
    @Index(name="ORDERPAYMENT_ADDRESS_INDEX", columnNames={"ADDRESS_ID"})
    protected Address billingAddress;
    @Column(name="AMOUNT", precision=19, scale=5)
    @AdminPresentation(friendlyName="OrderPaymentImpl_Payment_Amount", order=2000, gridOrder=2000, prominent=true, fieldType=SupportedFieldType.MONEY)
    protected BigDecimal amount;
    @Column(name="REFERENCE_NUMBER")
    @Index(name="ORDERPAYMENT_REFERENCE_INDEX", columnNames={"REFERENCE_NUMBER"})
    @AdminPresentation(friendlyName="OrderPaymentImpl_Payment_Reference_Number")
    protected String referenceNumber;
    @Column(name="PAYMENT_TYPE", nullable=false)
    @Index(name="ORDERPAYMENT_TYPE_INDEX", columnNames={"PAYMENT_TYPE"})
    @AdminPresentation(friendlyName="OrderPaymentImpl_Payment_Type", order=3000, gridOrder=3000, prominent=true, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.common.payment.PaymentType")
    protected String type;
    @Column(name="GATEWAY_TYPE")
    @AdminPresentation(friendlyName="OrderPaymentImpl_Gateway_Type", order=1000, gridOrder=1000, prominent=true, fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.common.payment.PaymentGatewayType")
    protected String gatewayType;
    @OneToMany(mappedBy="orderPayment", targetEntity=PaymentTransactionImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @AdminPresentationCollection(friendlyName="OrderPaymentImpl_Details", tab="PaymentInfoImpl_Log_Tab", tabOrder=4000)
    protected List<PaymentTransaction> transactions = new ArrayList<PaymentTransaction>();
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Money getAmount() {
        return this.amount == null ? null : BroadleafCurrencyUtils.getMoney((BigDecimal)this.amount, (BroadleafCurrency)this.getOrder().getCurrency());
    }

    @Override
    public void setAmount(Money amount) {
        this.amount = Money.toAmount((Money)amount);
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Order order) {
        this.order = order;
    }

    @Override
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @Override
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    @Override
    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    @Override
    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    @Override
    public PaymentType getType() {
        return PaymentType.getInstance((String)this.type);
    }

    @Override
    public void setType(PaymentType type) {
        this.type = type == null ? null : type.getType();
    }

    @Override
    public PaymentGatewayType getGatewayType() {
        return PaymentGatewayType.getInstance((String)this.gatewayType);
    }

    @Override
    public void setPaymentGatewayType(PaymentGatewayType gatewayType) {
        this.gatewayType = gatewayType == null ? null : gatewayType.getType();
    }

    @Override
    public List<PaymentTransaction> getTransactions() {
        return this.transactions;
    }

    @Override
    public void setTransactions(List<PaymentTransaction> transactions) {
        this.transactions = transactions;
    }

    @Override
    public void addTransaction(PaymentTransaction transaction) {
        this.getTransactions().add(transaction);
    }

    @Override
    public List<PaymentTransaction> getTransactionsForType(PaymentTransactionType type) {
        ArrayList<PaymentTransaction> result = new ArrayList<PaymentTransaction>();
        for (PaymentTransaction tx : this.getTransactions()) {
            if (!tx.getType().equals((Object)type)) continue;
            result.add(tx);
        }
        return result;
    }

    @Override
    public PaymentTransaction getInitialTransaction() {
        for (PaymentTransaction tx : this.getTransactions()) {
            if (tx.getParentTransaction() != null) continue;
            return tx;
        }
        return null;
    }

    @Override
    public Money getTransactionAmountForType(PaymentTransactionType type) {
        Money amount = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrder().getCurrency());
        for (PaymentTransaction tx : this.getTransactions()) {
            if (!type.equals((Object)tx.getType())) continue;
            amount = amount.add(tx.getAmount());
        }
        return amount;
    }

    @Override
    public Money getSuccessfulTransactionAmountForType(PaymentTransactionType type) {
        Money amount = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getOrder().getCurrency());
        for (PaymentTransaction tx : this.getTransactions()) {
            if (!type.equals((Object)tx.getType()) || !tx.getSuccess().booleanValue()) continue;
            amount = amount.add(tx.getAmount());
        }
        return amount;
    }

    @Override
    public boolean isConfirmed() {
        for (PaymentTransaction tx : this.getTransactions()) {
            if (!PaymentTransactionType.AUTHORIZE_AND_CAPTURE.equals((Object)tx.getType()) && !PaymentTransactionType.AUTHORIZE.equals((Object)tx.getType()) || !tx.getSuccess().booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFinalPayment() {
        return this.getType().getIsFinalPayment();
    }

    @Override
    public BroadleafCurrency getCurrency() {
        if (this.order != null) {
            return this.order.getCurrency();
        }
        return null;
    }

    public String getCurrencyCode() {
        if (this.getCurrency() != null) {
            return this.getCurrency().getCurrencyCode();
        }
        return null;
    }

    public Character getArchived() {
        ArchiveStatus temp = this.archiveStatus == null ? new ArchiveStatus() : this.archiveStatus;
        return temp.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    public boolean isActive() {
        return 'Y' != this.getArchived().charValue();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass().isAssignableFrom(obj.getClass())) {
            OrderPaymentImpl that = (OrderPaymentImpl)obj;
            return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.referenceNumber, (Object)that.referenceNumber).append((Object)this.type, (Object)that.type).append((Object)this.archiveStatus, (Object)that.archiveStatus).build();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.referenceNumber).append((Object)this.type).append((Object)this.archiveStatus).build();
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int REFNUMBER = 3000;
        }

        public static class Group {

            public static class Order {
                public static final int Items = 1000;
            }

            public static class Name {
                public static final String Items = "PaymentInfoImpl_Items";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Address = 2000;
                public static final int Log = 4000;
                public static final int Advanced = 5000;
            }

            public static class Name {
                public static final String Address = "PaymentInfoImpl_Address_Tab";
                public static final String Log = "PaymentInfoImpl_Log_Tab";
                public static final String Advanced = "PaymentInfoImpl_Advanced_Tab";
            }
        }
    }
}

