/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.fulfillment.domain;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.clone.IgnoreEnterpriseBehavior;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.order.domain.FulfillmentOptionImpl;
import org.broadleafcommerce.core.order.fulfillment.domain.BandedPriceFulfillmentOption;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentPriceBand;
import org.broadleafcommerce.core.order.fulfillment.domain.FulfillmentPriceBandImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_FULFILLMENT_OPT_BANDED_PRC")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(friendlyName="Banded Price Fulfillment Option")
public class BandedPriceFulfillmentOptionImpl
extends FulfillmentOptionImpl
implements BandedPriceFulfillmentOption {
    private static final long serialVersionUID = 1L;
    @OneToMany(mappedBy="option", targetEntity=FulfillmentPriceBandImpl.class)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    @IgnoreEnterpriseBehavior
    protected List<FulfillmentPriceBand> bands = new ArrayList<FulfillmentPriceBand>();

    @Override
    public List<FulfillmentPriceBand> getBands() {
        return this.bands;
    }

    @Override
    public void setBands(List<FulfillmentPriceBand> bands) {
        this.bands = bands;
    }

    public CreateResponse<BandedPriceFulfillmentOption> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = super.createOrRetrieveCopyInstance(context);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        BandedPriceFulfillmentOption myClone = (BandedPriceFulfillmentOption)createResponse.getClone();
        for (FulfillmentPriceBand band : this.bands) {
            myClone.getBands().add(band);
        }
        return createResponse;
    }
}

