/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.core.order.domain.PersonalMessage;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PERSONAL_MESSAGE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class PersonalMessageImpl
implements PersonalMessage {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PersonalMessageId")
    @GenericGenerator(name="PersonalMessageId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="PersonalMessageImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.PersonalMessageImpl")})
    @Column(name="PERSONAL_MESSAGE_ID")
    protected Long id;
    @Column(name="MESSAGE_TO")
    @AdminPresentation(friendlyName="PersonalMessageImpl_Message_To", order=1, group="PersonalMessageImpl_Personal_Message")
    protected String messageTo;
    @Column(name="MESSAGE_FROM")
    @AdminPresentation(friendlyName="PersonalMessageImpl_Message_From", order=2, group="PersonalMessageImpl_Personal_Message")
    protected String messageFrom;
    @Column(name="MESSAGE")
    @AdminPresentation(friendlyName="PersonalMessageImpl_Message", order=3, group="PersonalMessageImpl_Personal_Message")
    protected String message;
    @Column(name="OCCASION")
    @AdminPresentation(friendlyName="PersonalMessageImpl_Occasion", order=4, group="PersonalMessageImpl_Personal_Message")
    protected String occasion;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getMessageTo() {
        return this.messageTo;
    }

    @Override
    public void setMessageTo(String messageTo) {
        this.messageTo = messageTo;
    }

    @Override
    public String getMessageFrom() {
        return this.messageFrom;
    }

    @Override
    public void setMessageFrom(String messageFrom) {
        this.messageFrom = messageFrom;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getOccasion() {
        return this.occasion;
    }

    @Override
    public void setOccasion(String occasion) {
        this.occasion = occasion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        result = 31 * result + (this.messageFrom == null ? 0 : this.messageFrom.hashCode());
        result = 31 * result + (this.messageTo == null ? 0 : this.messageTo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PersonalMessageImpl other = (PersonalMessageImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
            return false;
        }
        if (this.messageFrom == null ? other.messageFrom != null : !this.messageFrom.equals(other.messageFrom)) {
            return false;
        }
        return !(this.messageTo == null ? other.messageTo != null : !this.messageTo.equals(other.messageTo));
    }
}

