/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.common.currency.util.BroadleafCurrencyUtils;
import org.broadleafcommerce.common.currency.util.CurrencyCodeIdentifiable;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.client.AddMethodType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustment;
import org.broadleafcommerce.core.offer.domain.OrderItemPriceDetailAdjustmentImpl;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemImpl;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ORDER_ITEM_PRICE_DTL")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="", mergeEntries={@AdminPresentationMergeEntry(propertyType="readOnly", booleanOverrideValue=true)})})
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"multiTenantSite"})})
public class OrderItemPriceDetailImpl
implements OrderItemPriceDetail,
CurrencyCodeIdentifiable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OrderItemPriceDetailId")
    @GenericGenerator(name="OrderItemPriceDetailId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OrderItemPriceDetailImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.order.domain.OrderItemPriceDetailImpl")})
    @Column(name="ORDER_ITEM_PRICE_DTL_ID")
    @AdminPresentation(friendlyName="OrderItemPriceDetailImpl_Id", group="OrderItemPriceDetailImpl_Primary_Key", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @ManyToOne(targetEntity=OrderItemImpl.class)
    @JoinColumn(name="ORDER_ITEM_ID")
    @AdminPresentation(excluded=true)
    protected OrderItem orderItem;
    @OneToMany(mappedBy="orderItemPriceDetail", targetEntity=OrderItemPriceDetailAdjustmentImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
    @AdminPresentationCollection(addType=AddMethodType.PERSIST, friendlyName="OrderItemPriceDetailImpl_orderItemPriceDetailAdjustments")
    protected List<OrderItemPriceDetailAdjustment> orderItemPriceDetailAdjustments = new ArrayList<OrderItemPriceDetailAdjustment>();
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="OrderItemPriceDetailImpl_quantity", order=5, group="OrderItemPriceDetailImpl_Pricing", prominent=true)
    protected int quantity;
    @Column(name="USE_SALE_PRICE")
    @AdminPresentation(friendlyName="OrderItemPriceDetailImpl_useSalePrice", order=5, group="OrderItemPriceDetailImpl_Pricing", prominent=true)
    protected Boolean useSalePrice = true;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public OrderItem getOrderItem() {
        return this.orderItem;
    }

    @Override
    public void setOrderItem(OrderItem orderItem) {
        this.orderItem = orderItem;
    }

    @Override
    public List<OrderItemPriceDetailAdjustment> getOrderItemPriceDetailAdjustments() {
        return this.orderItemPriceDetailAdjustments;
    }

    @Override
    public void setOrderItemAdjustments(List<OrderItemPriceDetailAdjustment> orderItemPriceDetailAdjustments) {
        this.orderItemPriceDetailAdjustments = orderItemPriceDetailAdjustments;
    }

    @Override
    public int getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    protected BroadleafCurrency getCurrency() {
        return this.getOrderItem().getOrder().getCurrency();
    }

    @Override
    public Money getAdjustmentValue() {
        Money adjustmentValue = BroadleafCurrencyUtils.getMoney((BigDecimal)BigDecimal.ZERO, (BroadleafCurrency)this.getCurrency());
        for (OrderItemPriceDetailAdjustment adjustment : this.orderItemPriceDetailAdjustments) {
            adjustmentValue = adjustmentValue.add(adjustment.getValue());
        }
        return adjustmentValue;
    }

    @Override
    public Money getTotalAdjustmentValue() {
        return this.getAdjustmentValue().multiply(this.quantity);
    }

    @Override
    public Money getTotalAdjustedPrice() {
        Money basePrice = this.orderItem.getPriceBeforeAdjustments(this.getUseSalePrice());
        return basePrice.multiply(this.quantity).subtract(this.getTotalAdjustmentValue());
    }

    @Override
    public boolean getUseSalePrice() {
        if (this.useSalePrice == null) {
            return false;
        }
        return this.useSalePrice;
    }

    @Override
    public void setUseSalePrice(boolean useSalePrice) {
        this.useSalePrice = useSalePrice;
    }

    public String getCurrencyCode() {
        if (this.getCurrency() != null) {
            return this.getCurrency().getCurrencyCode();
        }
        return null;
    }

    public <G extends OrderItemPriceDetail> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        OrderItemPriceDetail cloned = (OrderItemPriceDetail)createResponse.getClone();
        cloned.setQuantity(this.quantity);
        cloned.setUseSalePrice(this.useSalePrice);
        cloned.setOrderItem(this.orderItem);
        for (OrderItemPriceDetailAdjustment entry : this.orderItemPriceDetailAdjustments) {
            OrderItemPriceDetailAdjustment clonedEntry = (OrderItemPriceDetailAdjustment)entry.createOrRetrieveCopyInstance(context).getClone();
            clonedEntry.setOrderItemPriceDetail(cloned);
            cloned.getOrderItemPriceDetailAdjustments().add(clonedEntry);
        }
        return createResponse;
    }
}

