/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.offer.dao.CustomerOfferDao;
import org.broadleafcommerce.core.offer.domain.CustomerOffer;
import org.broadleafcommerce.core.offer.domain.CustomerOfferImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerOfferDao")
public class CustomerOfferDaoImpl
implements CustomerOfferDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public CustomerOffer create() {
        return (CustomerOffer)this.entityConfiguration.createEntityInstance(CustomerOffer.class.getName());
    }

    @Override
    public void delete(CustomerOffer customerOffer) {
        if (!this.em.contains((Object)customerOffer)) {
            customerOffer = this.readCustomerOfferById(customerOffer.getId());
        }
        this.em.remove((Object)customerOffer);
    }

    @Override
    public CustomerOffer save(CustomerOffer customerOffer) {
        return (CustomerOffer)this.em.merge((Object)customerOffer);
    }

    @Override
    public CustomerOffer readCustomerOfferById(Long customerOfferId) {
        return (CustomerOffer)this.em.find(CustomerOfferImpl.class, (Object)customerOfferId);
    }

    @Override
    public List<CustomerOffer> readCustomerOffersByCustomer(Customer customer) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_OFFER_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customer.getId());
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Offer");
        return query.getResultList();
    }
}

