/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.inventory.service;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.inventory.service.ContextualInventoryService;
import org.broadleafcommerce.core.inventory.service.InventoryServiceExtensionHandler;
import org.broadleafcommerce.core.inventory.service.InventoryServiceExtensionManager;
import org.broadleafcommerce.core.inventory.service.InventoryUnavailableException;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blInventoryService")
public class InventoryServiceImpl
implements ContextualInventoryService {
    private static final Log LOG = LogFactory.getLog(InventoryServiceImpl.class);
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blInventoryServiceExtensionManager")
    protected InventoryServiceExtensionManager extensionManager;

    @Override
    public boolean checkBasicAvailablility(Sku sku) {
        Boolean available = sku.isAvailable();
        if (available == null) {
            available = true;
        }
        return sku != null && available != false && sku.isActive() && !InventoryType.UNAVAILABLE.equals(sku.getInventoryType());
    }

    @Override
    public Integer retrieveQuantityAvailable(Sku sku) {
        return this.retrieveQuantityAvailable(sku, null);
    }

    @Override
    public Map<Sku, Integer> retrieveQuantitiesAvailable(Collection<Sku> skus) {
        return this.retrieveQuantitiesAvailable(skus, null);
    }

    @Override
    public boolean isAvailable(Sku sku, int quantity) {
        return this.isAvailable(sku, quantity, null);
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={InventoryUnavailableException.class})
    public void decrementInventory(Sku sku, int quantity) throws InventoryUnavailableException {
        this.decrementInventory(sku, quantity, null);
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={InventoryUnavailableException.class})
    public void decrementInventory(Map<Sku, Integer> skuQuantities) throws InventoryUnavailableException {
        this.decrementInventory(skuQuantities, null);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void incrementInventory(Sku sku, int quantity) {
        this.incrementInventory(sku, quantity, null);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void incrementInventory(Map<Sku, Integer> skuQuantities) {
        this.incrementInventory(skuQuantities, null);
    }

    @Override
    public Integer retrieveQuantityAvailable(Sku sku, Map<String, Object> context) {
        return this.retrieveQuantitiesAvailable(Arrays.asList(sku), context).get(sku);
    }

    @Override
    public Map<Sku, Integer> retrieveQuantitiesAvailable(Collection<Sku> skus, Map<String, Object> context) {
        ExtensionResultHolder holder = new ExtensionResultHolder();
        ExtensionResultStatusType res = ((InventoryServiceExtensionHandler)this.extensionManager.getProxy()).retrieveQuantitiesAvailable(skus, context, (ExtensionResultHolder<Map<Sku, Integer>>)holder);
        if (ExtensionResultStatusType.NOT_HANDLED.equals((Object)res)) {
            HashMap<Sku, Integer> inventories = new HashMap<Sku, Integer>();
            for (Sku sku : skus) {
                if (this.checkBasicAvailablility(sku)) {
                    if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                        if (sku.getQuantityAvailable() != null) continue;
                        inventories.put(sku, 0);
                        continue;
                    }
                    if (sku.getInventoryType() == null || InventoryType.ALWAYS_AVAILABLE.equals(sku.getInventoryType())) {
                        inventories.put(sku, null);
                        continue;
                    }
                    inventories.put(sku, 0);
                    continue;
                }
                inventories.put(sku, 0);
            }
            return inventories;
        }
        return (Map)holder.getResult();
    }

    @Override
    public boolean isAvailable(Sku sku, int quantity, Map<String, Object> context) {
        if (quantity < 1) {
            throw new IllegalArgumentException("Quantity " + quantity + " is not valid. Must be greater than zero.");
        }
        if (this.checkBasicAvailablility(sku)) {
            if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                Integer quantityAvailable = this.retrieveQuantityAvailable(sku, context);
                return quantityAvailable != null && quantity <= quantityAvailable;
            }
            return true;
        }
        return false;
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={InventoryUnavailableException.class})
    public void decrementInventory(Sku sku, int quantity, Map<String, Object> context) throws InventoryUnavailableException {
        HashMap<Sku, Integer> quantities = new HashMap<Sku, Integer>();
        quantities.put(sku, quantity);
        this.decrementInventory(quantities, context);
    }

    @Override
    @Transactional(value="blTransactionManager", rollbackFor={InventoryUnavailableException.class})
    public void decrementInventory(Map<Sku, Integer> skuQuantities, Map<String, Object> context) throws InventoryUnavailableException {
        ExtensionResultStatusType res = ((InventoryServiceExtensionHandler)this.extensionManager.getProxy()).decrementInventory(skuQuantities, context);
        if (ExtensionResultStatusType.NOT_HANDLED.equals((Object)res)) {
            for (Map.Entry<Sku, Integer> entry : skuQuantities.entrySet()) {
                Sku sku = entry.getKey();
                Integer quantity = entry.getValue();
                if (quantity == null || quantity < 1) {
                    throw new IllegalArgumentException("Quantity " + quantity + " is not valid. Must be greater than zero and not null.");
                }
                if (this.checkBasicAvailablility(sku)) {
                    if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                        Integer inventoryAvailable = this.retrieveQuantityAvailable(sku, context);
                        if (inventoryAvailable == null) {
                            return;
                        }
                        if (inventoryAvailable < quantity) {
                            throw new InventoryUnavailableException("There was not enough inventory to fulfill this request.", sku.getId(), quantity, inventoryAvailable);
                        }
                        int newInventory = inventoryAvailable - quantity;
                        sku.setQuantityAvailable(newInventory);
                        this.catalogService.saveSku(sku);
                        continue;
                    }
                    LOG.info((Object)"Not decrementing inventory as the Sku has been marked as always available");
                    continue;
                }
                throw new InventoryUnavailableException("The Sku has been marked as unavailable", sku.getId(), quantity, 0);
            }
        }
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void incrementInventory(Sku sku, int quantity, Map<String, Object> context) {
        HashMap<Sku, Integer> quantities = new HashMap<Sku, Integer>();
        quantities.put(sku, quantity);
        this.incrementInventory(quantities, context);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void incrementInventory(Map<Sku, Integer> skuQuantities, Map<String, Object> context) {
        ExtensionResultStatusType res = ((InventoryServiceExtensionHandler)this.extensionManager.getProxy()).incrementInventory(skuQuantities, context);
        if (ExtensionResultStatusType.NOT_HANDLED.equals((Object)res)) {
            for (Map.Entry<Sku, Integer> entry : skuQuantities.entrySet()) {
                Sku sku = entry.getKey();
                Integer quantity = entry.getValue();
                if (quantity == null || quantity < 1) {
                    throw new IllegalArgumentException("Quantity " + quantity + " is not valid. Must be greater than zero and not null.");
                }
                if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
                    Integer currentInventoryAvailable = this.retrieveQuantityAvailable(sku, context);
                    if (currentInventoryAvailable == null) {
                        throw new IllegalArgumentException("The current inventory for this Sku is null");
                    }
                    int newInventory = currentInventoryAvailable + quantity;
                    sku.setQuantityAvailable(newInventory);
                    this.catalogService.saveSku(sku);
                    continue;
                }
                LOG.info((Object)"Not incrementing inventory as the Sku has been marked as always available");
            }
        }
    }
}

