/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.checkout.service.workflow;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.payment.PaymentTransactionType;
import org.broadleafcommerce.common.payment.PaymentType;
import org.broadleafcommerce.common.payment.dto.PaymentRequestDTO;
import org.broadleafcommerce.common.payment.dto.PaymentResponseDTO;
import org.broadleafcommerce.common.payment.service.PaymentGatewayCheckoutService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfigurationService;
import org.broadleafcommerce.common.payment.service.PaymentGatewayConfigurationServiceProvider;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutSeed;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.OrderPayment;
import org.broadleafcommerce.core.payment.domain.PaymentTransaction;
import org.broadleafcommerce.core.payment.domain.secure.CreditCardPayment;
import org.broadleafcommerce.core.payment.service.OrderPaymentService;
import org.broadleafcommerce.core.payment.service.OrderToPaymentRequestDTOService;
import org.broadleafcommerce.core.payment.service.SecureOrderPaymentService;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;
import org.broadleafcommerce.core.workflow.WorkflowException;
import org.broadleafcommerce.core.workflow.state.ActivityStateManagerImpl;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ValidateAndConfirmPaymentActivity
extends BaseActivity<ProcessContext<CheckoutSeed>> {
    protected static final Log LOG = LogFactory.getLog(ValidateAndConfirmPaymentActivity.class);
    public static final String ROLLBACK_TRANSACTIONS = "confirmedTransactions";
    public static final String FAILED_RESPONSES = "failedResponses";
    @Autowired(required=false)
    @Qualifier(value="blPaymentGatewayConfigurationServiceProvider")
    protected PaymentGatewayConfigurationServiceProvider paymentConfigurationServiceProvider;
    @Resource(name="blOrderToPaymentRequestDTOService")
    protected OrderToPaymentRequestDTOService orderToPaymentRequestService;
    @Resource(name="blOrderPaymentService")
    protected OrderPaymentService orderPaymentService;
    @Resource(name="blSecureOrderPaymentService")
    protected SecureOrderPaymentService secureOrderPaymentService;
    @Resource(name="blPaymentGatewayCheckoutService")
    protected PaymentGatewayCheckoutService paymentGatewayCheckoutService;

    @Override
    public ProcessContext<CheckoutSeed> execute(ProcessContext<CheckoutSeed> context) throws Exception {
        Order order = context.getSeedData().getOrder();
        HashMap<String, Object> rollbackState = new HashMap<String, Object>();
        HashMap<OrderPayment, PaymentTransaction> additionalTransactions = new HashMap<OrderPayment, PaymentTransaction>();
        ArrayList<ResponseTransactionPair> failedTransactions = new ArrayList<ResponseTransactionPair>();
        ArrayList<PaymentTransaction> confirmedTransactions = new ArrayList<PaymentTransaction>();
        HashMap<OrderPayment, PaymentTransactionType> additionalConfirmedTransactions = new HashMap<OrderPayment, PaymentTransactionType>();
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            for (PaymentTransaction tx : payment.getTransactions()) {
                if (PaymentTransactionType.UNCONFIRMED.equals((Object)tx.getType())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Transaction " + tx.getId() + " is not confirmed. Proceeding to confirm transaction."));
                    }
                    if (this.paymentConfigurationServiceProvider == null) {
                        String msg = "There are unconfirmed payment transactions on this payment but no payment gateway configuration or transaction confirmation service configured";
                        LOG.error((Object)msg);
                        throw new CheckoutException(msg, context.getSeedData());
                    }
                    PaymentGatewayConfigurationService cfg = this.paymentConfigurationServiceProvider.getGatewayConfigurationService(tx.getOrderPayment().getGatewayType());
                    PaymentResponseDTO responseDTO = null;
                    PaymentRequestDTO confirmationRequest = this.orderToPaymentRequestService.translatePaymentTransaction(payment.getAmount(), tx);
                    this.populateBillingAddressOnRequest(confirmationRequest, payment);
                    this.populateCustomerOnRequest(confirmationRequest, payment);
                    this.populateShippingAddressOnRequest(confirmationRequest, payment);
                    if (PaymentType.CREDIT_CARD.equals((Object)payment.getType())) {
                        this.populateCreditCardOnRequest(confirmationRequest, payment);
                        responseDTO = cfg.getConfiguration().isPerformAuthorizeAndCapture() ? cfg.getTransactionService().authorizeAndCapture(confirmationRequest) : cfg.getTransactionService().authorize(confirmationRequest);
                    } else {
                        responseDTO = cfg.getTransactionConfirmationService().confirmTransaction(confirmationRequest);
                    }
                    if (responseDTO == null) {
                        String msg = "Unable to Confirm/Authorize the UNCONFIRMED Transaction with id: " + tx.getId() + ". " + "The ResponseDTO returned from the Gateway was null. Please check your implementation";
                        LOG.error((Object)msg);
                        throw new CheckoutException(msg, context.getSeedData());
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Transaction Confirmation Raw Response: " + responseDTO.getRawResponse()));
                    }
                    if (responseDTO.getAmount() == null || responseDTO.getPaymentTransactionType() == null) {
                        LOG.error((Object)"The ResponseDTO returned from the Gateway does not contain either an Amount or Payment Transaction Type. Please check your implementation");
                    }
                    PaymentTransaction transaction = this.orderPaymentService.createTransaction();
                    transaction.setAmount(responseDTO.getAmount());
                    transaction.setRawResponse(responseDTO.getRawResponse());
                    transaction.setSuccess(responseDTO.isSuccessful());
                    transaction.setType(responseDTO.getPaymentTransactionType());
                    transaction.setParentTransaction(tx);
                    transaction.setOrderPayment(payment);
                    transaction.setAdditionalFields(responseDTO.getResponseMap());
                    transaction = this.orderPaymentService.save(transaction);
                    additionalTransactions.put(payment, transaction);
                    if (responseDTO.isSuccessful()) {
                        additionalConfirmedTransactions.put(payment, transaction.getType());
                        continue;
                    }
                    failedTransactions.add(new ResponseTransactionPair(responseDTO, transaction.getId()));
                    continue;
                }
                if (!PaymentTransactionType.AUTHORIZE.equals((Object)tx.getType()) && !PaymentTransactionType.AUTHORIZE_AND_CAPTURE.equals((Object)tx.getType())) continue;
                confirmedTransactions.add(tx);
            }
        }
        for (OrderPayment payment : order.getPayments()) {
            if (!additionalTransactions.containsKey(payment)) continue;
            PaymentTransactionType confirmedType = null;
            if (additionalConfirmedTransactions.containsKey(payment)) {
                confirmedType = (PaymentTransactionType)additionalConfirmedTransactions.get(payment);
            }
            payment.addTransaction((PaymentTransaction)additionalTransactions.get(payment));
            payment = this.orderPaymentService.save(payment);
            if (confirmedType == null) continue;
            List<PaymentTransaction> types = payment.getTransactionsForType(confirmedType);
            if (types.size() == 1) {
                confirmedTransactions.add(types.get(0));
                continue;
            }
            throw new IllegalArgumentException("There should only be one AUTHORIZE or AUTHORIZE_AND_CAPTURE transaction.There are more than one confirmed payment transactions for Order Payment:" + payment.getId());
        }
        rollbackState.put(ROLLBACK_TRANSACTIONS, confirmedTransactions);
        ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackHandler(), rollbackState);
        if (!failedTransactions.isEmpty()) {
            this.handleUnsuccessfulTransactions(failedTransactions, context);
        }
        Money paymentSum = new Money(BigDecimal.ZERO);
        for (OrderPayment payment : order.getPayments()) {
            if (!payment.isActive()) continue;
            paymentSum = paymentSum.add(payment.getSuccessfulTransactionAmountForType(PaymentTransactionType.AUTHORIZE)).add(payment.getSuccessfulTransactionAmountForType(PaymentTransactionType.AUTHORIZE_AND_CAPTURE));
        }
        if (paymentSum.lessThan(order.getTotal())) {
            throw new IllegalArgumentException("There are not enough payments to pay for the total order. The sum of the payments is " + paymentSum.getAmount().toPlainString() + " and the order total is " + order.getTotal().getAmount().toPlainString());
        }
        return context;
    }

    protected void handleUnsuccessfulTransactions(List<ResponseTransactionPair> failedTransactions, ProcessContext<CheckoutSeed> context) throws Exception {
        String msg = "Attempting to confirm/authorize an UNCONFIRMED transaction on the order was unsuccessful.";
        ArrayList<OrderPayment> invalidatedPayments = new ArrayList<OrderPayment>();
        ArrayList<PaymentTransaction> failedTransactionsToRollBack = new ArrayList<PaymentTransaction>();
        ArrayList<PaymentResponseDTO> failedResponses = new ArrayList<PaymentResponseDTO>();
        for (ResponseTransactionPair responseTransactionPair : failedTransactions) {
            PaymentTransaction tx = this.orderPaymentService.readTransactionById(responseTransactionPair.getTransactionId());
            if (this.shouldRollbackFailedTransaction(responseTransactionPair)) {
                failedTransactionsToRollBack.add(tx);
            } else if (!invalidatedPayments.contains(tx.getOrderPayment())) {
                this.paymentGatewayCheckoutService.markPaymentAsInvalid(tx.getOrderPayment().getId());
                OrderPayment payment = this.orderPaymentService.save(tx.getOrderPayment());
                invalidatedPayments.add(payment);
            }
            failedResponses.add(responseTransactionPair.getResponseDTO());
        }
        HashMap<String, Object> rollbackState = new HashMap<String, Object>();
        rollbackState.put(ROLLBACK_TRANSACTIONS, failedTransactionsToRollBack);
        context.getSeedData().getUserDefinedFields().put(FAILED_RESPONSES, failedResponses);
        ActivityStateManagerImpl.getStateManager().registerState(this, context, this.getRollbackHandler(), rollbackState);
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)msg);
        }
        if (LOG.isTraceEnabled()) {
            for (ResponseTransactionPair responseTransactionPair : failedTransactions) {
                LOG.trace((Object)responseTransactionPair.getResponseDTO().getRawResponse());
            }
        }
        throw new CheckoutException(msg, context.getSeedData());
    }

    protected boolean shouldRollbackFailedTransaction(ResponseTransactionPair failedTransactionPair) {
        return false;
    }

    protected void populateCreditCardOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) throws WorkflowException {
        CreditCardPayment creditCardPayment;
        if (payment.getReferenceNumber() != null && (creditCardPayment = (CreditCardPayment)this.secureOrderPaymentService.findSecurePaymentInfo(payment.getReferenceNumber(), PaymentType.CREDIT_CARD)) != null) {
            requestDTO.creditCard().creditCardHolderName(creditCardPayment.getNameOnCard()).creditCardNum(creditCardPayment.getPan()).creditCardExpDate(this.constructExpirationDate(creditCardPayment.getExpirationMonth(), creditCardPayment.getExpirationYear())).creditCardExpMonth(creditCardPayment.getExpirationMonth() + "").creditCardExpYear(creditCardPayment.getExpirationYear() + "").done();
        }
    }

    protected void populateBillingAddressOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) {
        if (payment != null && payment.getBillingAddress() != null) {
            this.orderToPaymentRequestService.populateBillTo(payment.getOrder(), requestDTO);
        }
    }

    protected void populateCustomerOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) {
        if (payment != null && payment.getOrder() != null && payment.getOrder().getCustomer() != null) {
            this.orderToPaymentRequestService.populateCustomerInfo(payment.getOrder(), requestDTO);
        }
    }

    protected void populateShippingAddressOnRequest(PaymentRequestDTO requestDTO, OrderPayment payment) {
        if (payment != null && payment.getOrder() != null) {
            this.orderToPaymentRequestService.populateShipTo(payment.getOrder(), requestDTO);
        }
    }

    protected String constructExpirationDate(Integer expMonth, Integer expYear) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.getGatewayExpirationDateFormat());
        DateTime exp = new DateTime().withYear(expYear.intValue()).withMonthOfYear(expMonth.intValue());
        return sdf.format(exp.toDate());
    }

    protected String getGatewayExpirationDateFormat() {
        String format = BLCSystemProperty.resolveSystemProperty((String)"gateway.config.global.expDateFormat");
        if (StringUtils.isBlank((String)format)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"The System Property 'gateway.config.global.expDateFormat' is not set. Defaulting to the format 'MM/YY' for the configured gateway.");
            }
            format = "MM/YY";
        }
        return format;
    }

    protected class ResponseTransactionPair {
        PaymentResponseDTO responseDTO;
        Long transactionId;

        ResponseTransactionPair() {
            this(null, null);
        }

        ResponseTransactionPair(PaymentResponseDTO responseDTO, Long transactionId) {
            this.responseDTO = responseDTO;
            this.transactionId = transactionId;
        }

        public PaymentResponseDTO getResponseDTO() {
            return this.responseDTO;
        }

        public Long getTransactionId() {
            return this.transactionId;
        }
    }
}

