/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service.dynamic;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.concurrent.ConcurrentHashMap;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.springframework.util.ReflectionUtils;

public class DefaultDynamicSkuPricingInvocationHandler
implements InvocationHandler {
    protected Sku delegate;
    protected Money retailPrice;
    protected Money salePrice;
    protected static final ConcurrentHashMap<String, Field> FIELD_CACHE = new ConcurrentHashMap();

    public DefaultDynamicSkuPricingInvocationHandler(Sku sku) {
        this.delegate = sku;
        try {
            Field retail = this.getSingleField(this.delegate.getClass(), "retailPrice");
            Object retailVal = retail.get(this.delegate);
            this.retailPrice = retailVal == null ? null : new Money((BigDecimal)retailVal);
            Field sale = this.getSingleField(this.delegate.getClass(), "salePrice");
            Object saleVal = sale.get(this.delegate);
            this.salePrice = saleVal == null ? null : new Money((BigDecimal)saleVal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DefaultDynamicSkuPricingInvocationHandler(Sku sku, BigDecimal salePriceOverride) {
        this(sku);
        if (salePriceOverride != null) {
            this.salePrice = new Money(salePriceOverride);
        }
    }

    public DefaultDynamicSkuPricingInvocationHandler(BigDecimal salePriceOverride) {
        this(new SkuImpl());
        if (salePriceOverride != null) {
            this.salePrice = new Money(salePriceOverride);
        }
    }

    public DefaultDynamicSkuPricingInvocationHandler(Sku sku, Money adjustments) {
        this(sku);
        if (adjustments != null) {
            this.salePrice = this.salePrice == null ? adjustments : this.salePrice.add(adjustments);
            this.retailPrice = this.retailPrice == null ? adjustments : this.retailPrice.add(adjustments);
        }
    }

    protected synchronized Field getSingleField(Class<?> clazz, String fieldName) throws IllegalStateException {
        String cacheKey = clazz.getName() + fieldName;
        if (FIELD_CACHE.containsKey(cacheKey)) {
            return FIELD_CACHE.get(cacheKey);
        }
        Field field = ReflectionUtils.findField(clazz, (String)fieldName);
        if (field != null) {
            field.setAccessible(true);
        }
        FIELD_CACHE.put(cacheKey, field);
        return field;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("getRetailPrice")) {
            return this.retailPrice;
        }
        if (method.getName().equals("getSalePrice")) {
            return this.salePrice;
        }
        return method.invoke((Object)this.delegate, args);
    }

    public void reset() {
        this.delegate = null;
        this.retailPrice = null;
        this.salePrice = null;
    }
}

