/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.common.file.service.BroadleafFileUtils;
import org.broadleafcommerce.common.sitemap.domain.SiteMapGeneratorConfiguration;
import org.broadleafcommerce.common.sitemap.service.SiteMapBuilder;
import org.broadleafcommerce.common.sitemap.service.SiteMapGenerator;
import org.broadleafcommerce.common.sitemap.service.type.SiteMapGeneratorType;
import org.broadleafcommerce.common.sitemap.wrapper.SiteMapURLWrapper;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="blSkuSiteMapGenerator")
public class SkuSiteMapGenerator
implements SiteMapGenerator {
    @Resource(name="blSkuDao")
    protected SkuDao skuDao;
    @Value(value="${sku.site.map.generator.row.limit}")
    protected int pageSize;

    public boolean canHandleSiteMapConfiguration(SiteMapGeneratorConfiguration siteMapGeneratorConfiguration) {
        return SiteMapGeneratorType.SKU.equals((Object)siteMapGeneratorConfiguration.getSiteMapGeneratorType());
    }

    public void addSiteMapEntries(SiteMapGeneratorConfiguration smgc, SiteMapBuilder siteMapBuilder) {
        List<Sku> skus;
        int pageNum = 0;
        do {
            skus = this.skuDao.readAllActiveSkus(pageNum++, this.pageSize);
            for (Sku sku : skus) {
                Product defaultProduct = sku.getDefaultProduct();
                if (defaultProduct != null && CollectionUtils.isNotEmpty(defaultProduct.getAdditionalSkus()) || defaultProduct instanceof ProductBundle || StringUtils.isEmpty((CharSequence)(sku.getProduct().getUrl() + sku.getUrlKey()))) continue;
                SiteMapURLWrapper siteMapUrl = new SiteMapURLWrapper();
                siteMapUrl.setLoc(this.generateUri(siteMapBuilder, sku));
                siteMapUrl.setChangeFreqType(smgc.getSiteMapChangeFreq());
                siteMapUrl.setPriorityType(smgc.getSiteMapPriority());
                siteMapUrl.setLastModDate(this.generateDate(sku));
                siteMapBuilder.addUrl(siteMapUrl);
            }
        } while (skus.size() == this.pageSize);
    }

    protected String generateUri(SiteMapBuilder smb, Sku sku) {
        String uri = null;
        uri = sku.getUrlKey() != null ? sku.getProduct().getUrl() + sku.getUrlKey() : sku.getProduct().getUrl();
        return BroadleafFileUtils.appendUnixPaths((String)smb.getBaseUrl(), (String)uri);
    }

    protected Date generateDate(Sku sku) {
        return new Date();
    }

    public SkuDao getSkuDao() {
        return this.skuDao;
    }

    public void setSkuDao(SkuDao skuDao) {
        this.skuDao = skuDao;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

