/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import com.google.common.base.Optional;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.client.utils.URIBuilder;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.service.CatalogURLService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="blCatalogURLService")
public class CatalogURLServiceImpl
implements CatalogURLService {
    @Value(value="${catalogUriService.appendIdToRelativeURI:true}")
    protected boolean appendIdToRelativeURI;
    @Value(value="${catalogUriService.useUrlKey:false}")
    protected boolean useUrlKey;
    @Value(value="${catalogUriService.productIdParam:productId}")
    protected String productIdParam;
    @Value(value="${catalogUriService.categoryIdParam:categoryId}")
    protected String categoryIdParam;

    @Override
    public String buildRelativeProductURL(String currentUrl, Product product) {
        String fragment = this.getProductUrlFragment(product);
        return this.buildRelativeUrlWithParam(currentUrl, fragment, this.productIdParam, String.valueOf(product.getId()));
    }

    @Override
    public String buildRelativeCategoryURL(String currentUrl, Category category) {
        String fragment = this.getCategoryUrlFragment(category);
        return this.buildRelativeUrlWithParam(currentUrl, fragment, this.categoryIdParam, String.valueOf(category.getId()));
    }

    protected String buildRelativeUrlWithParam(String currentUrl, String fragment, String idParam, String idValue) {
        try {
            URIBuilder builder = new URIBuilder(currentUrl);
            builder.setPath(builder.getPath() + "/" + fragment);
            if (this.appendIdToRelativeURI) {
                builder.setParameter(idParam, String.valueOf(idValue));
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            return currentUrl;
        }
    }

    protected String getProductUrlFragment(Product product) {
        if (this.useUrlKey) {
            return product.getUrlKey();
        }
        return this.getLastFragment(product.getUrl());
    }

    protected String getCategoryUrlFragment(Category category) {
        if (this.useUrlKey) {
            return category.getUrlKey();
        }
        return this.getLastFragment(category.getUrl());
    }

    protected String getLastFragment(String url) {
        URI uri = URI.create(url);
        String path = (String)Optional.fromNullable((Object)uri.getPath()).or((Object)"/");
        return path.substring(path.lastIndexOf(47) + 1);
    }
}

