/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductBundleImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.service.dynamic.DefaultDynamicSkuPricingInvocationHandler;
import org.broadleafcommerce.core.catalog.service.dynamic.DynamicSkuPrices;
import org.broadleafcommerce.core.catalog.service.dynamic.SkuPricingConsiderationContext;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.springframework.util.ClassUtils;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_BUNDLE_ITEM")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.FALSE)
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class SkuBundleItemImpl
implements SkuBundleItem {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuBundleItemId")
    @GenericGenerator(name="SkuBundleItemId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SkuBundleItemImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuBundleItemImpl")})
    @Column(name="SKU_BUNDLE_ITEM_ID")
    @AdminPresentation(friendlyName="SkuBundleItemImpl_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="bundleItemQuantity", prominent=true, requiredOverride=RequiredOverride.REQUIRED)
    protected Integer quantity;
    @Column(name="ITEM_SALE_PRICE", precision=19, scale=5)
    @AdminPresentation(friendlyName="bundleItemSalePrice", prominent=true, tooltip="bundleItemSalePriceTooltip", fieldType=SupportedFieldType.MONEY)
    protected BigDecimal itemSalePrice;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=ProductBundleImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PRODUCT_BUNDLE_ID", referencedColumnName="PRODUCT_ID")
    protected ProductBundle bundle;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=SkuImpl.class, optional=false)
    @JoinColumn(name="SKU_ID", referencedColumnName="SKU_ID")
    @AdminPresentation(friendlyName="Sku", prominent=true, order=0, gridOrder=0)
    @AdminPresentationToOneLookup
    protected Sku sku;
    @Transient
    protected DynamicSkuPrices dynamicPrices = null;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Money getDynamicSalePrice(Sku sku, BigDecimal salePrice) {
        Money returnPrice = null;
        if (SkuPricingConsiderationContext.hasDynamicPricing()) {
            if (this.dynamicPrices != null) {
                returnPrice = this.dynamicPrices.getSalePrice();
            } else {
                DefaultDynamicSkuPricingInvocationHandler handler = new DefaultDynamicSkuPricingInvocationHandler(sku, salePrice);
                Sku proxy = (Sku)Proxy.newProxyInstance(sku.getClass().getClassLoader(), ClassUtils.getAllInterfacesForClass(sku.getClass()), (InvocationHandler)handler);
                this.dynamicPrices = SkuPricingConsiderationContext.getSkuPricingService().getSkuPrices(proxy, SkuPricingConsiderationContext.getSkuPricingConsiderationContext());
                returnPrice = this.dynamicPrices.getSalePrice();
            }
        } else if (salePrice != null) {
            returnPrice = new Money(salePrice, Money.defaultCurrency());
        }
        return returnPrice;
    }

    @Override
    public void setSalePrice(Money salePrice) {
        this.itemSalePrice = salePrice != null ? salePrice.getAmount() : null;
    }

    @Override
    public Money getSalePrice() {
        if (this.itemSalePrice == null) {
            return this.sku.getSalePrice();
        }
        return this.getDynamicSalePrice(this.sku, this.itemSalePrice);
    }

    @Override
    public Money getRetailPrice() {
        return this.sku.getRetailPrice();
    }

    @Override
    public ProductBundle getBundle() {
        return this.bundle;
    }

    @Override
    public void setBundle(ProductBundle bundle) {
        this.bundle = bundle;
    }

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
    }

    @Override
    public void clearDynamicPrices() {
        this.dynamicPrices = null;
        this.sku.clearDynamicPrices();
    }

    public <G extends SkuBundleItem> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        SkuBundleItem cloned = (SkuBundleItem)createResponse.getClone();
        cloned.setQuantity(this.quantity);
        cloned.setSalePrice(this.getSalePrice());
        if (this.sku != null) {
            cloned.setSku((Sku)this.sku.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.bundle != null) {
            cloned.setBundle((ProductBundle)this.bundle.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

