/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.i18n.service.DynamicTranslationProvider;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_ATTRIBUTE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"}, skipOverlaps=true)})
public class SkuAttributeImpl
implements SkuAttribute {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuAttributeId")
    @GenericGenerator(name="SkuAttributeId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SkuAttributeImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuAttributeImpl")})
    @Column(name="SKU_ATTR_ID")
    protected Long id;
    @Column(name="NAME", nullable=false)
    @Index(name="SKUATTR_NAME_INDEX", columnNames={"NAME"})
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected String name;
    @Column(name="VALUE", nullable=false)
    @AdminPresentation(friendlyName="SkuAttributeImpl_Attribute_Value", order=2, group="SkuAttributeImpl_Description", prominent=true)
    protected String value;
    @Column(name="SEARCHABLE")
    @AdminPresentation(excluded=true)
    protected Boolean searchable = false;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="SKU_ID")
    @Index(name="SKUATTR_SKU_INDEX", columnNames={"SKU_ID"})
    protected Sku sku;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getValue() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"value", (String)this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getSearchable() {
        if (this.searchable == null) {
            return Boolean.FALSE;
        }
        return this.searchable;
    }

    public void setSearchable(Boolean searchable) {
        this.searchable = searchable;
    }

    @Override
    public String getName() {
        return DynamicTranslationProvider.getValue((Object)this, (String)"name", (String)this.name);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.value;
    }

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.sku == null ? 0 : this.sku.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        SkuAttributeImpl other = (SkuAttributeImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.sku == null ? other.sku != null : !this.sku.equals(other.sku)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public <G extends SkuAttribute> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        SkuAttribute cloned = (SkuAttribute)createResponse.getClone();
        cloned.setName(this.name);
        if (this.sku != null) {
            cloned.setSku((Sku)this.sku.createOrRetrieveCopyInstance(context).getClone());
        }
        cloned.setSearchable(this.getSearchable());
        cloned.setValue((Serializable)((Object)this.value));
        return createResponse;
    }
}

