/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.admin.domain.AdminMainEntity;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCloneable;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicy;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.persistence.ArchiveStatus;
import org.broadleafcommerce.common.persistence.Status;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationAdornedTargetCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.AdminPresentationMap;
import org.broadleafcommerce.common.presentation.AdminPresentationToOneLookup;
import org.broadleafcommerce.common.presentation.ConfigurationItem;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.ValidationConfiguration;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.common.template.TemplatePathContainer;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.vendor.service.type.ContainerShapeType;
import org.broadleafcommerce.common.vendor.service.type.ContainerSizeType;
import org.broadleafcommerce.common.web.Locatable;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl;
import org.broadleafcommerce.core.catalog.domain.CrossSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Dimension;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductAttributeImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.ProductOptionXref;
import org.broadleafcommerce.core.catalog.domain.ProductOptionXrefImpl;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.domain.UpSaleProductImpl;
import org.broadleafcommerce.core.catalog.domain.Weight;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.SQLDelete;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT")
@org.hibernate.annotations.Table(appliesTo="BLC_PRODUCT", indexes={@Index(name="PRODUCT_URL_INDEX", columnNames={"URL", "URL_KEY"})})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="defaultSku.displayTemplate", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="defaultSku.urlKey", mergeEntries={@AdminPresentationMergeEntry(propertyType="excluded", booleanOverrideValue=true)}), @AdminPresentationMergeOverride(name="defaultSku.retailPrice", mergeEntries={@AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="REQUIRED")}), @AdminPresentationMergeOverride(name="defaultSku.name", mergeEntries={@AdminPresentationMergeEntry(propertyType="requiredOverride", overrideValue="REQUIRED")}), @AdminPresentationMergeOverride(name="defaultSku.activeEndDate", mergeEntries={@AdminPresentationMergeEntry(propertyType="validationConfigurations", validationConfigurations={@ValidationConfiguration(validationImplementation="blAfterStartDateValidator", configurationItems={@ConfigurationItem(itemName="otherField", itemValue="defaultSku.activeStartDate")})})})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="baseProduct")
@SQLDelete(sql="UPDATE BLC_PRODUCT SET ARCHIVED = 'Y' WHERE PRODUCT_ID = ?")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class ProductImpl
implements Product,
Status,
AdminMainEntity,
Locatable,
TemplatePathContainer {
    private static final Log LOG = LogFactory.getLog(ProductImpl.class);
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductId")
    @GenericGenerator(name="ProductId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="ProductImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductImpl")})
    @Column(name="PRODUCT_ID")
    @AdminPresentation(friendlyName="ProductImpl_Product_ID", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="URL")
    @AdminPresentation(friendlyName="ProductImpl_Product_Url", order=7000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=3, columnWidth="200px", requiredOverride=RequiredOverride.REQUIRED, validationConfigurations={@ValidationConfiguration(validationImplementation="blUriPropertyValidator")})
    protected String url;
    @Column(name="OVERRIDE_GENERATED_URL")
    @AdminPresentation(friendlyName="ProductImpl_Override_Generated_Url", group="ProductImpl_Product_Description", order=7010)
    protected Boolean overrideGeneratedUrl = false;
    @Column(name="URL_KEY")
    @AdminPresentation(friendlyName="ProductImpl_Product_UrlKey", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Product_Description", groupOrder=1000, excluded=true)
    protected String urlKey;
    @Column(name="DISPLAY_TEMPLATE")
    @AdminPresentation(friendlyName="ProductImpl_Product_Display_Template", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected String displayTemplate;
    @Column(name="MODEL")
    @AdminPresentation(friendlyName="ProductImpl_Product_Model", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected String model;
    @Column(name="MANUFACTURE")
    @AdminPresentation(friendlyName="ProductImpl_Product_Manufacturer", order=6000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=4)
    protected String manufacturer;
    @Column(name="IS_FEATURED_PRODUCT", nullable=false)
    @AdminPresentation(friendlyName="ProductImpl_Is_Featured_Product", requiredOverride=RequiredOverride.NOT_REQUIRED, tab="ProductImpl_Marketing_Tab", tabOrder=2000, group="ProductImpl_Badges", groupOrder=1000)
    protected Boolean isFeaturedProduct = false;
    @OneToOne(targetEntity=SkuImpl.class, cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="DEFAULT_SKU_ID")
    @ClonePolicy(toOneProperty="defaultProduct")
    protected Sku defaultSku;
    @Column(name="CAN_SELL_WITHOUT_OPTIONS")
    @AdminPresentation(friendlyName="ProductImpl_Can_Sell_Without_Options", tab="ProductImpl_Advanced_Tab", tabOrder=7000, group="ProductImpl_Advanced", groupOrder=1000)
    protected Boolean canSellWithoutOptions = false;
    @Transient
    protected List<Sku> skus = new ArrayList<Sku>();
    @Transient
    protected String promoMessage;
    @OneToMany(mappedBy="product", targetEntity=CrossSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="crossSaleProductsTitle", order=1000, tab="ProductImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="relatedSaleProduct", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    protected List<RelatedProduct> crossSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(mappedBy="product", targetEntity=UpSaleProductImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @OrderBy(value="sequence")
    @AdminPresentationAdornedTargetCollection(friendlyName="upsaleProductsTitle", order=2000, tab="ProductImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="relatedSaleProduct", sortProperty="sequence", maintainedAdornedTargetFields={"promotionMessage"}, gridVisibleFields={"defaultSku.name", "promotionMessage"})
    protected List<RelatedProduct> upSaleProducts = new ArrayList<RelatedProduct>();
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SkuImpl.class, mappedBy="product", cascade={CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationCollection(friendlyName="ProductImpl_Additional_Skus", order=1000, tab="ProductImpl_Product_Options_Tab", tabOrder=4000)
    protected List<Sku> additionalSkus = new ArrayList<Sku>();
    @ManyToOne(targetEntity=CategoryImpl.class)
    @JoinColumn(name="DEFAULT_CATEGORY_ID")
    @Index(name="PRODUCT_CATEGORY_INDEX", columnNames={"DEFAULT_CATEGORY_ID"})
    @AdminPresentation(friendlyName="ProductImpl_Product_Default_Category", order=5000, group="ProductImpl_Product_Description", groupOrder=1000, prominent=true, gridOrder=2, requiredOverride=RequiredOverride.REQUIRED)
    @AdminPresentationToOneLookup
    @Deprecated
    protected Category defaultCategory;
    @OneToMany(targetEntity=CategoryProductXrefImpl.class, mappedBy="product", orphanRemoval=true, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @OrderBy(value="displayOrder")
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(friendlyName="allParentCategoriesTitle", order=3000, tab="ProductImpl_Marketing_Tab", tabOrder=2000, targetObjectProperty="category", parentObjectProperty="product", gridVisibleFields={"name"})
    protected List<CategoryProductXref> allParentCategoryXrefs = new ArrayList<CategoryProductXref>();
    @OneToMany(mappedBy="product", targetEntity=ProductAttributeImpl.class, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @MapKey(name="name")
    @BatchSize(size=50)
    @AdminPresentationMap(friendlyName="productAttributesTitle", tab="ProductImpl_Advanced_Tab", tabOrder=7000, deleteEntityUponRemove=true, forceFreeFormKeys=true, keyPropertyFriendlyName="ProductAttributeImpl_Attribute_Name")
    protected Map<String, ProductAttribute> productAttributes = new HashMap<String, ProductAttribute>();
    @OneToMany(targetEntity=ProductOptionXrefImpl.class, mappedBy="product", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationAdornedTargetCollection(friendlyName="productOptionsTitle", tab="ProductImpl_Product_Options_Tab", tabOrder=4000, joinEntityClass="org.broadleafcommerce.core.catalog.domain.ProductOptionXrefImpl", targetObjectProperty="productOption", parentObjectProperty="product", gridVisibleFields={"label", "required"})
    protected List<ProductOptionXref> productOptions = new ArrayList<ProductOptionXref>();
    @Transient
    protected Map<String, Set<String>> productOptionMap;
    @Embedded
    protected ArchiveStatus archiveStatus = new ArchiveStatus();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.getDefaultSku().getName();
    }

    @Override
    public void setName(String name) {
        this.getDefaultSku().setName(name);
    }

    @Override
    public String getDescription() {
        return this.getDefaultSku().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getDefaultSku().setDescription(description);
    }

    @Override
    public String getLongDescription() {
        return this.getDefaultSku().getLongDescription();
    }

    @Override
    public void setLongDescription(String longDescription) {
        this.getDefaultSku().setLongDescription(longDescription);
    }

    @Override
    public Date getActiveStartDate() {
        return this.getDefaultSku().getActiveStartDate();
    }

    @Override
    public void setActiveStartDate(Date activeStartDate) {
        this.getDefaultSku().setActiveStartDate(activeStartDate);
    }

    @Override
    public Date getActiveEndDate() {
        return this.getDefaultSku().getActiveEndDate();
    }

    @Override
    public void setActiveEndDate(Date activeEndDate) {
        this.getDefaultSku().setActiveEndDate(activeEndDate);
    }

    @Override
    public boolean isActive() {
        if (LOG.isDebugEnabled()) {
            if (!DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true)) {
                LOG.debug((Object)("product, " + this.id + ", inactive due to date"));
            }
            if ('Y' == this.getArchived().charValue()) {
                LOG.debug((Object)("product, " + this.id + ", inactive due to archived status"));
            }
        }
        return DateUtil.isActive((Date)this.getActiveStartDate(), (Date)this.getActiveEndDate(), (boolean)true) && 'Y' != this.getArchived().charValue();
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    public boolean isFeaturedProduct() {
        return this.isFeaturedProduct;
    }

    @Override
    public void setFeaturedProduct(boolean isFeaturedProduct) {
        this.isFeaturedProduct = isFeaturedProduct;
    }

    @Override
    public boolean hasRetailPrice() {
        return this.getRetailPrice() != null;
    }

    @Override
    public Money getRetailPrice() {
        if (this.defaultSku == null) {
            return null;
        }
        return this.defaultSku.getRetailPrice();
    }

    @Override
    public Money getSalePrice() {
        return this.getRetailPrice();
    }

    @Override
    public Sku getDefaultSku() {
        return this.defaultSku;
    }

    @Override
    public Boolean getCanSellWithoutOptions() {
        return this.canSellWithoutOptions == null ? false : this.canSellWithoutOptions;
    }

    @Override
    public void setCanSellWithoutOptions(Boolean canSellWithoutOptions) {
        this.canSellWithoutOptions = canSellWithoutOptions;
    }

    @Override
    public void setDefaultSku(Sku defaultSku) {
        if (defaultSku != null) {
            defaultSku.setDefaultProduct(this);
        }
        this.defaultSku = defaultSku;
    }

    @Override
    public String getPromoMessage() {
        return this.promoMessage;
    }

    @Override
    public void setPromoMessage(String promoMessage) {
        this.promoMessage = promoMessage;
    }

    @Override
    public List<Sku> getAllSkus() {
        ArrayList<Sku> allSkus = new ArrayList<Sku>();
        allSkus.add(this.getDefaultSku());
        for (Sku additionalSku : this.additionalSkus) {
            if (additionalSku.getId().equals(this.getDefaultSku().getId())) continue;
            allSkus.add(additionalSku);
        }
        return Collections.unmodifiableList(allSkus);
    }

    @Override
    @Deprecated
    public List<Sku> getSkus() {
        if (this.skus.size() == 0) {
            List<Sku> additionalSkus = this.getAdditionalSkus();
            for (Sku sku : additionalSkus) {
                if (!sku.isActive()) continue;
                this.skus.add(sku);
            }
        }
        return Collections.unmodifiableList(this.skus);
    }

    @Override
    public List<Sku> getAdditionalSkus() {
        return this.additionalSkus;
    }

    @Override
    @Deprecated
    public void setAdditionalSkus(List<Sku> skus) {
        this.additionalSkus.clear();
        for (Sku sku : skus) {
            this.additionalSkus.add(sku);
        }
    }

    @Override
    @Deprecated
    public Category getDefaultCategory() {
        Category response = this.defaultCategory != null ? this.defaultCategory : this.getCategory();
        return response;
    }

    @Override
    @Deprecated
    public void setDefaultCategory(Category defaultCategory) {
        this.defaultCategory = defaultCategory;
    }

    @Override
    public Category getCategory() {
        Category response = null;
        List<CategoryProductXref> xrefs = this.getAllParentCategoryXrefs();
        if (!CollectionUtils.isEmpty(xrefs)) {
            for (CategoryProductXref xref : xrefs) {
                if (!xref.getCategory().isActive() || xref.getDefaultReference() == null || !xref.getDefaultReference().booleanValue()) continue;
                response = xref.getCategory();
                break;
            }
        }
        if (response == null && !CollectionUtils.isEmpty(xrefs)) {
            for (CategoryProductXref xref : xrefs) {
                if (!xref.getCategory().isActive()) continue;
                response = xref.getCategory();
                break;
            }
        }
        return response;
    }

    @Override
    public void setCategory(Category category) {
        List<CategoryProductXref> xrefs = this.getAllParentCategoryXrefs();
        boolean found = false;
        for (CategoryProductXref xref : xrefs) {
            if (xref.getCategory().equals(category)) {
                xref.setDefaultReference(true);
                found = true;
                continue;
            }
            if (xref.getDefaultReference() == null || !xref.getDefaultReference().booleanValue()) continue;
            xref.setDefaultReference(null);
        }
        if (!found && category != null) {
            CategoryProductXrefImpl xref = new CategoryProductXrefImpl();
            xref.setProduct(this);
            xref.setCategory(category);
            xref.setDefaultReference(true);
            this.allParentCategoryXrefs.add(xref);
        }
    }

    @Override
    public Map<String, Media> getMedia() {
        return this.getDefaultSku().getSkuMedia();
    }

    @Override
    public void setMedia(Map<String, Media> media) {
        this.getDefaultSku().setSkuMedia(media);
    }

    @Override
    public Map<String, Media> getAllSkuMedia() {
        HashMap<String, Media> result = new HashMap<String, Media>();
        result.putAll(this.getMedia());
        for (Sku additionalSku : this.getAdditionalSkus()) {
            if (additionalSku.getId().equals(this.getDefaultSku().getId())) continue;
            result.putAll(additionalSku.getSkuMedia());
        }
        return result;
    }

    @Override
    public List<CategoryProductXref> getAllParentCategoryXrefs() {
        return this.allParentCategoryXrefs;
    }

    @Override
    public void setAllParentCategoryXrefs(List<CategoryProductXref> allParentCategories) {
        this.allParentCategoryXrefs.clear();
        this.allParentCategoryXrefs.addAll(allParentCategories);
    }

    @Override
    @Deprecated
    public List<Category> getAllParentCategories() {
        ArrayList<Category> parents = new ArrayList<Category>();
        for (CategoryProductXref xref : this.allParentCategoryXrefs) {
            parents.add(xref.getCategory());
        }
        return Collections.unmodifiableList(parents);
    }

    @Override
    @Deprecated
    public void setAllParentCategories(List<Category> allParentCategories) {
        throw new UnsupportedOperationException("Not Supported - Use setAllParentCategoryXrefs()");
    }

    @Override
    public Dimension getDimension() {
        return this.getDefaultSku().getDimension();
    }

    @Override
    public void setDimension(Dimension dimension) {
        this.getDefaultSku().setDimension(dimension);
    }

    @Override
    public BigDecimal getWidth() {
        return this.getDefaultSku().getDimension().getWidth();
    }

    @Override
    public void setWidth(BigDecimal width) {
        this.getDefaultSku().getDimension().setWidth(width);
    }

    @Override
    public BigDecimal getHeight() {
        return this.getDefaultSku().getDimension().getHeight();
    }

    @Override
    public void setHeight(BigDecimal height) {
        this.getDefaultSku().getDimension().setHeight(height);
    }

    @Override
    public BigDecimal getDepth() {
        return this.getDefaultSku().getDimension().getDepth();
    }

    @Override
    public void setDepth(BigDecimal depth) {
        this.getDefaultSku().getDimension().setDepth(depth);
    }

    @Override
    public BigDecimal getGirth() {
        return this.getDefaultSku().getDimension().getGirth();
    }

    @Override
    public void setGirth(BigDecimal girth) {
        this.getDefaultSku().getDimension().setGirth(girth);
    }

    @Override
    public ContainerSizeType getSize() {
        return this.getDefaultSku().getDimension().getSize();
    }

    @Override
    public void setSize(ContainerSizeType size) {
        this.getDefaultSku().getDimension().setSize(size);
    }

    @Override
    public ContainerShapeType getContainer() {
        return this.getDefaultSku().getDimension().getContainer();
    }

    @Override
    public void setContainer(ContainerShapeType container) {
        this.getDefaultSku().getDimension().setContainer(container);
    }

    @Override
    public String getDimensionString() {
        return this.getDefaultSku().getDimension().getDimensionString();
    }

    @Override
    public Weight getWeight() {
        return this.getDefaultSku().getWeight();
    }

    @Override
    public void setWeight(Weight weight) {
        this.getDefaultSku().setWeight(weight);
    }

    @Override
    public List<RelatedProduct> getCrossSaleProducts() {
        return this.crossSaleProducts;
    }

    @Override
    public void setCrossSaleProducts(List<RelatedProduct> crossSaleProducts) {
        this.crossSaleProducts.clear();
        for (RelatedProduct relatedProduct : crossSaleProducts) {
            this.crossSaleProducts.add(relatedProduct);
        }
    }

    @Override
    public List<RelatedProduct> getUpSaleProducts() {
        return this.upSaleProducts;
    }

    @Override
    public void setUpSaleProducts(List<RelatedProduct> upSaleProducts) {
        this.upSaleProducts.clear();
        for (RelatedProduct relatedProduct : upSaleProducts) {
            this.upSaleProducts.add(relatedProduct);
        }
        this.upSaleProducts = upSaleProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeCrossSaleProducts() {
        List<RelatedProduct> categoryProducts;
        List<RelatedProduct> returnProducts = this.getCrossSaleProducts();
        if (this.defaultCategory != null && (categoryProducts = this.defaultCategory.getCumulativeCrossSaleProducts()) != null) {
            returnProducts.addAll(categoryProducts);
        }
        Iterator<RelatedProduct> itr = returnProducts.iterator();
        while (itr.hasNext()) {
            RelatedProduct relatedProduct = itr.next();
            if (!relatedProduct.getRelatedProduct().equals(this)) continue;
            itr.remove();
        }
        return returnProducts;
    }

    @Override
    public List<RelatedProduct> getCumulativeUpSaleProducts() {
        List<RelatedProduct> categoryProducts;
        List<RelatedProduct> returnProducts = this.getUpSaleProducts();
        if (this.defaultCategory != null && (categoryProducts = this.defaultCategory.getCumulativeUpSaleProducts()) != null) {
            returnProducts.addAll(categoryProducts);
        }
        Iterator<RelatedProduct> itr = returnProducts.iterator();
        while (itr.hasNext()) {
            RelatedProduct relatedProduct = itr.next();
            if (!relatedProduct.getRelatedProduct().equals(this)) continue;
            itr.remove();
        }
        return returnProducts;
    }

    @Override
    public Map<String, ProductAttribute> getProductAttributes() {
        return this.productAttributes;
    }

    @Override
    public void setProductAttributes(Map<String, ProductAttribute> productAttributes) {
        this.productAttributes = productAttributes;
    }

    @Override
    public List<ProductOptionXref> getProductOptionXrefs() {
        ArrayList<ProductOptionXref> sorted = new ArrayList<ProductOptionXref>(this.productOptions);
        Collections.sort(sorted, new Comparator<ProductOptionXref>(){

            @Override
            public int compare(ProductOptionXref o1, ProductOptionXref o2) {
                return ObjectUtils.compare((Comparable)o1.getProductOption().getDisplayOrder(), (Comparable)o2.getProductOption().getDisplayOrder(), (boolean)true);
            }
        });
        return sorted;
    }

    @Override
    public void setProductOptionXrefs(List<ProductOptionXref> productOptions) {
        this.productOptions = productOptions;
    }

    @Override
    public List<ProductOption> getProductOptions() {
        ArrayList<ProductOption> response = new ArrayList<ProductOption>();
        for (ProductOptionXref xref : this.getProductOptionXrefs()) {
            response.add(xref.getProductOption());
        }
        return Collections.unmodifiableList(response);
    }

    @Override
    public void setProductOptions(List<ProductOption> productOptions) {
        throw new UnsupportedOperationException("Use setProductOptionXrefs(..) instead");
    }

    @Override
    public String getUrl() {
        if (this.url == null) {
            return this.getGeneratedUrl();
        }
        return this.url;
    }

    @Override
    public Boolean getOverrideGeneratedUrl() {
        return this.overrideGeneratedUrl == null ? false : this.overrideGeneratedUrl;
    }

    @Override
    public void setOverrideGeneratedUrl(Boolean overrideGeneratedUrl) {
        this.overrideGeneratedUrl = overrideGeneratedUrl == null ? false : overrideGeneratedUrl;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getDisplayTemplate() {
        return this.displayTemplate;
    }

    @Override
    public void setDisplayTemplate(String displayTemplate) {
        this.displayTemplate = displayTemplate;
    }

    public Character getArchived() {
        ArchiveStatus temp = this.archiveStatus == null ? new ArchiveStatus() : this.archiveStatus;
        return temp.getArchived();
    }

    public void setArchived(Character archived) {
        if (this.archiveStatus == null) {
            this.archiveStatus = new ArchiveStatus();
        }
        this.archiveStatus.setArchived(archived);
    }

    @Override
    public Map<String, Set<String>> getProductOptionValuesMap() {
        if (this.productOptionMap == null) {
            this.productOptionMap = new HashMap<String, Set<String>>();
            List<ProductOptionXref> xrefs = this.getProductOptionXrefs();
            if (xrefs != null) {
                for (ProductOptionXref xref : xrefs) {
                    List<ProductOptionValue> productOptionValues = xref.getProductOption().getAllowedValues();
                    if (productOptionValues == null || productOptionValues.isEmpty()) continue;
                    HashSet<String> values = new HashSet<String>();
                    for (ProductOptionValue value : productOptionValues) {
                        values.add(value.getAttributeValue());
                    }
                    this.productOptionMap.put(xref.getProductOption().getAttributeName(), values);
                }
            }
        }
        return this.productOptionMap;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.skus == null ? 0 : this.skus.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        ProductImpl other = (ProductImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.skus == null ? other.skus != null : !this.skus.equals(other.skus));
    }

    @Override
    public String getUrlKey() {
        if (this.urlKey != null) {
            return this.urlKey;
        }
        if (this.getName() != null) {
            String returnKey = this.getName().toLowerCase();
            returnKey = returnKey.replaceAll(" ", "-");
            return returnKey.replaceAll("[^A-Za-z0-9/-]", "");
        }
        return null;
    }

    @Override
    public void setUrlKey(String urlKey) {
        this.urlKey = urlKey;
    }

    @Override
    public String getGeneratedUrl() {
        if (this.getDefaultCategory() != null && this.getDefaultCategory().getGeneratedUrl() != null) {
            String generatedUrl = this.getDefaultCategory().getGeneratedUrl();
            if (generatedUrl.endsWith("//")) {
                return generatedUrl + this.getUrlKey();
            }
            return generatedUrl + "//" + this.getUrlKey();
        }
        return null;
    }

    @Override
    public void clearDynamicPrices() {
        for (Sku sku : this.getAllSkus()) {
            sku.clearDynamicPrices();
        }
    }

    public String getMainEntityName() {
        return this.getName();
    }

    public <G extends Product> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        MultiTenantCloneable<Sku> clonedEntry;
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        Product cloned = (Product)createResponse.getClone();
        cloned.setCanSellWithoutOptions(this.canSellWithoutOptions);
        cloned.setFeaturedProduct(this.isFeaturedProduct);
        cloned.setUrl(this.url);
        cloned.setUrlKey(this.urlKey);
        cloned.setManufacturer(this.manufacturer);
        cloned.setPromoMessage(this.promoMessage);
        if (this.defaultCategory != null) {
            cloned.setDefaultCategory((Category)this.defaultCategory.createOrRetrieveCopyInstance(context).getClone());
        }
        cloned.setModel(this.model);
        if (this.defaultSku != null) {
            cloned.setDefaultSku((Sku)this.defaultSku.createOrRetrieveCopyInstance(context).getClone());
        }
        for (Sku sku : this.additionalSkus) {
            clonedEntry = (Sku)sku.createOrRetrieveCopyInstance(context).getClone();
            cloned.getAdditionalSkus().add((Sku)clonedEntry);
        }
        for (ProductOptionXref productOptionXref : this.productOptions) {
            clonedEntry = (ProductOptionXref)productOptionXref.createOrRetrieveCopyInstance(context).getClone();
            cloned.getProductOptionXrefs().add((ProductOptionXref)clonedEntry);
        }
        for (Map.Entry entry : this.productAttributes.entrySet()) {
            clonedEntry = (ProductAttribute)((ProductAttribute)entry.getValue()).createOrRetrieveCopyInstance(context).getClone();
            cloned.getProductAttributes().put((String)entry.getKey(), (ProductAttribute)clonedEntry);
        }
        return createResponse;
    }

    @Override
    public String getTaxCode() {
        return this.getDefaultSku().getTaxCode();
    }

    @Override
    public void setTaxCode(String taxCode) {
        this.getDefaultSku().setTaxCode(taxCode);
    }

    public String getLocation() {
        return this.getUrl();
    }

    public static class Presentation {

        public static class FieldOrder {
            public static final int NAME = 1000;
            public static final int SHORT_DESCRIPTION = 2000;
            public static final int PRIMARY_MEDIA = 3000;
            public static final int LONG_DESCRIPTION = 4000;
            public static final int DEFAULT_CATEGORY = 5000;
            public static final int MANUFACTURER = 6000;
            public static final int URL = 7000;
        }

        public static class Group {

            public static class Order {
                public static final int General = 1000;
                public static final int Price = 2000;
                public static final int ActiveDateRange = 3000;
                public static final int Advanced = 1000;
                public static final int Inventory = 1000;
                public static final int Badges = 1000;
                public static final int Shipping = 1000;
            }

            public static class Name {
                public static final String General = "ProductImpl_Product_Description";
                public static final String Price = "SkuImpl_Price";
                public static final String ActiveDateRange = "ProductImpl_Product_Active_Date_Range";
                public static final String Advanced = "ProductImpl_Advanced";
                public static final String Inventory = "SkuImpl_Sku_Inventory";
                public static final String Badges = "ProductImpl_Badges";
                public static final String Shipping = "ProductWeight_Shipping";
                public static final String Financial = "ProductImpl_Financial";
            }
        }

        public static class Tab {

            public static class Order {
                public static final int Marketing = 2000;
                public static final int Media = 3000;
                public static final int ProductOptions = 4000;
                public static final int Inventory = 5000;
                public static final int Shipping = 6000;
                public static final int Advanced = 7000;
            }

            public static class Name {
                public static final String Marketing = "ProductImpl_Marketing_Tab";
                public static final String Media = "SkuImpl_Media_Tab";
                public static final String ProductOptions = "ProductImpl_Product_Options_Tab";
                public static final String Inventory = "ProductImpl_Inventory_Tab";
                public static final String Shipping = "ProductImpl_Shipping_Tab";
                public static final String Advanced = "ProductImpl_Advanced_Tab";
            }
        }
    }
}

