/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.money.BankersRounding;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.AdminPresentationCollection;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.RequiredOverride;
import org.broadleafcommerce.common.presentation.client.SupportedFieldType;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItemImpl;
import org.broadleafcommerce.core.catalog.service.type.ProductBundlePricingModelType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_BUNDLE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="ProductImpl_bundleProduct")
public class ProductBundleImpl
extends ProductImpl
implements ProductBundle {
    private static final long serialVersionUID = 1L;
    @Column(name="PRICING_MODEL")
    @AdminPresentation(friendlyName="productBundlePricingModel", group="SkuImpl_Price", order=1, helpText="productBundlePricingModelHelp", fieldType=SupportedFieldType.BROADLEAF_ENUMERATION, broadleafEnumeration="org.broadleafcommerce.core.catalog.service.type.ProductBundlePricingModelType", requiredOverride=RequiredOverride.REQUIRED)
    protected String pricingModel;
    @Column(name="AUTO_BUNDLE")
    @AdminPresentation(excluded=true)
    protected Boolean autoBundle = false;
    @Column(name="ITEMS_PROMOTABLE")
    @AdminPresentation(excluded=true)
    protected Boolean itemsPromotable = false;
    @Column(name="BUNDLE_PROMOTABLE")
    @AdminPresentation(excluded=true)
    protected Boolean bundlePromotable = false;
    @Column(name="BUNDLE_PRIORITY")
    @AdminPresentation(excluded=true, friendlyName="productBundlePriority", group="productBundleGroup")
    protected Integer priority = 99;
    @OneToMany(mappedBy="bundle", targetEntity=SkuBundleItemImpl.class, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
    @BatchSize(size=50)
    @AdminPresentationCollection(friendlyName="skuBundleItemsTitle")
    protected List<SkuBundleItem> skuBundleItems = new ArrayList<SkuBundleItem>();

    @Override
    public boolean isOnSale() {
        Money retailPrice = this.getRetailPrice();
        Money salePrice = this.getSalePrice();
        return salePrice != null && !salePrice.isZero() && salePrice.lessThan(retailPrice);
    }

    @Override
    public ProductBundlePricingModelType getPricingModel() {
        return ProductBundlePricingModelType.getInstance(this.pricingModel);
    }

    @Override
    public void setPricingModel(ProductBundlePricingModelType pricingModel) {
        this.pricingModel = pricingModel == null ? null : pricingModel.getType();
    }

    @Override
    public Money getRetailPrice() {
        if (ProductBundlePricingModelType.ITEM_SUM.equals(this.getPricingModel())) {
            return this.getBundleItemsRetailPrice();
        }
        if (ProductBundlePricingModelType.BUNDLE.equals(this.getPricingModel())) {
            return super.getDefaultSku().getRetailPrice();
        }
        return null;
    }

    @Override
    public Money getSalePrice() {
        if (ProductBundlePricingModelType.ITEM_SUM.equals(this.getPricingModel())) {
            return this.getBundleItemsSalePrice();
        }
        if (ProductBundlePricingModelType.BUNDLE.equals(this.getPricingModel())) {
            return super.getDefaultSku().getSalePrice();
        }
        return null;
    }

    @Override
    public Money getBundleItemsRetailPrice() {
        Money price = Money.ZERO;
        for (SkuBundleItem item : this.getSkuBundleItems()) {
            price = price.add(item.getRetailPrice().multiply(item.getQuantity().intValue()));
        }
        return price;
    }

    @Override
    public Money getBundleItemsSalePrice() {
        Money price = Money.ZERO;
        for (SkuBundleItem item : this.getSkuBundleItems()) {
            if (item.getSalePrice() != null) {
                price = price.add(item.getSalePrice().multiply(item.getQuantity().intValue()));
                continue;
            }
            price = price.add(item.getRetailPrice().multiply(item.getQuantity().intValue()));
        }
        return price;
    }

    @Override
    public void clearDynamicPrices() {
        super.clearDynamicPrices();
        for (SkuBundleItem bundleItem : this.getSkuBundleItems()) {
            bundleItem.clearDynamicPrices();
        }
    }

    @Override
    public Boolean getAutoBundle() {
        return this.autoBundle == null ? false : this.autoBundle;
    }

    @Override
    public void setAutoBundle(Boolean autoBundle) {
        this.autoBundle = autoBundle;
    }

    @Override
    public Boolean getItemsPromotable() {
        return this.itemsPromotable == null ? false : this.itemsPromotable;
    }

    @Override
    public void setItemsPromotable(Boolean itemsPromotable) {
        this.itemsPromotable = itemsPromotable;
    }

    @Override
    public Boolean getBundlePromotable() {
        return this.bundlePromotable == null ? false : this.bundlePromotable;
    }

    @Override
    public void setBundlePromotable(Boolean bundlePromotable) {
        this.bundlePromotable = bundlePromotable;
    }

    @Override
    public List<SkuBundleItem> getSkuBundleItems() {
        return this.skuBundleItems;
    }

    @Override
    public void setSkuBundleItems(List<SkuBundleItem> skuBundleItems) {
        this.skuBundleItems = skuBundleItems;
    }

    @Override
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    @Override
    public BigDecimal getPotentialSavings() {
        if (this.skuBundleItems != null) {
            Money totalNormalPrice = new Money(BankersRounding.zeroAmount());
            Money totalBundlePrice = new Money(BankersRounding.zeroAmount());
            for (SkuBundleItem skuBundleItem : this.skuBundleItems) {
                Sku sku = skuBundleItem.getSku();
                if (sku != null && sku.getRetailPrice() != null) {
                    totalNormalPrice = totalNormalPrice.add(sku.getRetailPrice().multiply(skuBundleItem.getQuantity().intValue()));
                }
                if (!ProductBundlePricingModelType.ITEM_SUM.equals(this.getPricingModel())) continue;
                if (skuBundleItem.getSalePrice() != null) {
                    totalBundlePrice = totalBundlePrice.add(skuBundleItem.getSalePrice().multiply(skuBundleItem.getQuantity().intValue()));
                    continue;
                }
                totalBundlePrice = totalBundlePrice.add(skuBundleItem.getRetailPrice().multiply(skuBundleItem.getQuantity().intValue()));
            }
            if (ProductBundlePricingModelType.BUNDLE.equals(this.getPricingModel())) {
                totalBundlePrice = this.getSalePrice() != null ? this.getSalePrice() : this.getRetailPrice();
            }
            return totalNormalPrice.subtract(totalBundlePrice).getAmount();
        }
        return BigDecimal.ZERO;
    }

    public CreateResponse<ProductBundle> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = super.createOrRetrieveCopyInstance(context);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        ProductBundle cloned = (ProductBundle)createResponse.getClone();
        cloned.setAutoBundle(this.autoBundle);
        cloned.setBundlePromotable(this.bundlePromotable);
        cloned.setItemsPromotable(this.itemsPromotable);
        cloned.setPriority(this.priority);
        cloned.setPricingModel(this.getPricingModel());
        for (SkuBundleItem item : this.skuBundleItems) {
            cloned.getSkuBundleItems().add((SkuBundleItem)item.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

