/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.core.catalog.dao.ProductOptionDao;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValueImpl;
import org.broadleafcommerce.core.catalog.domain.SkuProductOptionValueXrefImpl;
import org.broadleafcommerce.core.catalog.domain.dto.AssignedProductOptionDTO;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository(value="blProductOptionDao")
public class ProductOptionDaoImpl
implements ProductOptionDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;

    @Override
    public List<ProductOption> readAllProductOptions() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_PRODUCT_OPTIONS", ProductOption.class);
        return query.getResultList();
    }

    @Override
    public ProductOption saveProductOption(ProductOption option) {
        return (ProductOption)this.em.merge((Object)option);
    }

    @Override
    public ProductOption readProductOptionById(Long id) {
        return (ProductOption)this.em.find(ProductOptionImpl.class, (Object)id);
    }

    @Override
    public ProductOptionValue readProductOptionValueById(Long id) {
        return (ProductOptionValue)this.em.find(ProductOptionValueImpl.class, (Object)id);
    }

    @Override
    public List<AssignedProductOptionDTO> findAssignedProductOptionsByProductId(Long productId) {
        Session session = (Session)this.em.unwrap(Session.class);
        Criteria criteria = session.createCriteria(SkuProductOptionValueXrefImpl.class);
        List dtoList = criteria.createAlias("sku", "sku").createAlias("sku.product", "product").createAlias("productOptionValue", "productOptionValue").createAlias("productOptionValue.productOption", "productOption").setProjection(Projections.distinct((Projection)Projections.projectionList().add((Projection)Projections.property((String)"product.id"), "productId").add((Projection)Projections.property((String)"productOption.attributeName"), "productOptionAttrName").add((Projection)Projections.property((String)"productOptionValue"), "productOptionValue").add((Projection)Projections.property((String)"sku"), "sku"))).setResultTransformer(Transformers.aliasToBean(AssignedProductOptionDTO.class)).add((Criterion)Restrictions.eq((String)"product.id", (Object)productId)).addOrder(Order.asc((String)"productOption.attributeName")).list();
        ArrayList<AssignedProductOptionDTO> results = new ArrayList<AssignedProductOptionDTO>();
        for (Object o : dtoList) {
            AssignedProductOptionDTO dto = (AssignedProductOptionDTO)o;
            if (!dto.getSku().isActive()) continue;
            results.add(dto);
        }
        return results;
    }

    @Override
    public List<AssignedProductOptionDTO> findAssignedProductOptionsByProduct(Product product) {
        return this.findAssignedProductOptionsByProductId(product.getId());
    }

    @Override
    public Long countAllowedValuesForProductOptionById(Long productOptionId) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root root = criteria.from(ProductOptionValueImpl.class);
        criteria.select((Selection)builder.count((Expression)root));
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        List mergedIds = this.sandBoxHelper.mergeCloneIds(ProductOptionImpl.class, new Long[]{productOptionId});
        restrictions.add(root.get("productOption").in((Collection)mergedIds));
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        TypedQuery query = this.em.createQuery(criteria);
        return (Long)query.getSingleResult();
    }
}

