/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.broadleafcommerce.core.search.domain.SearchCriteria;

public interface ProductDao {
    @Nonnull
    public Product readProductById(@Nonnull Long var1);

    public Product readProductByExternalId(String var1);

    public List<Product> readProductsByIds(@Nonnull List<Long> var1);

    @Nonnull
    public Product save(@Nonnull Product var1);

    @Nonnull
    public List<Product> readProductsByName(@Nonnull String var1);

    @Nonnull
    public List<Product> readProductsByName(@Nonnull String var1, @Nonnull int var2, @Nonnull int var3);

    public List<Product> readActiveProductsByCategory(@Nonnull Long var1);

    public List<Product> readActiveProductsByCategory(@Nonnull Long var1, @Nonnull int var2, @Nonnull int var3);

    @Nonnull
    public List<Product> readFilteredActiveProductsByCategory(Long var1, SearchCriteria var2);

    @Nonnull
    public List<Product> readFilteredActiveProductsByQuery(String var1, SearchCriteria var2);

    @Deprecated
    @Nonnull
    public List<Product> readFilteredActiveProductsByCategory(Long var1, Date var2, SearchCriteria var3);

    @Deprecated
    @Nonnull
    public List<Product> readActiveProductsByCategory(@Nonnull Long var1, @Nonnull Date var2);

    @Deprecated
    @Nonnull
    public List<Product> readFilteredActiveProductsByQuery(String var1, Date var2, SearchCriteria var3);

    @Deprecated
    @Nonnull
    public List<Product> readActiveProductsByCategory(@Nonnull Long var1, @Nonnull Date var2, @Nonnull int var3, @Nonnull int var4);

    @Nonnull
    public List<Product> readProductsByCategory(@Nonnull Long var1);

    @Nonnull
    public List<Product> readProductsByCategory(@Nonnull Long var1, @Nonnull int var2, @Nonnull int var3);

    public void delete(@Nonnull Product var1);

    public Product create(ProductType var1);

    public List<ProductBundle> readAutomaticProductBundles();

    public List<Product> findProductByURI(String var1);

    public List<Product> readAllActiveProducts();

    @Deprecated
    public List<Product> readAllActiveProducts(@Nonnull Date var1);

    public List<Product> readAllActiveProducts(int var1, int var2);

    public List<Product> readAllActiveProducts(Integer var1, Long var2);

    @Deprecated
    public List<Product> readAllActiveProducts(int var1, int var2, Date var3);

    public Long readCountAllActiveProducts();

    @Deprecated
    public Long readCountAllActiveProducts(Date var1);

    public Long getCurrentDateResolution();

    public void setCurrentDateResolution(Long var1);
}

