/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.broadleafcommerce.core.offer.dao.OfferDao;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferImpl;
import org.broadleafcommerce.core.offer.domain.OfferQualifyingCriteriaXref;
import org.broadleafcommerce.core.offer.service.OfferDataItemProvider;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactory;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableItemFactoryImpl;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.processor.OfferTimeZoneProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferDiscountType;
import org.easymock.classextension.EasyMock;

public class OrderOfferProcessorTest
extends TestCase {
    protected OfferDao offerDaoMock;
    protected OrderOfferProcessorImpl orderProcessor;
    protected OfferDataItemProvider dataProvider = new OfferDataItemProvider();
    protected OfferTimeZoneProcessor offerTimeZoneProcessorMock;

    protected void setUp() throws Exception {
        this.offerDaoMock = (OfferDao)EasyMock.createMock(OfferDao.class);
        this.offerTimeZoneProcessorMock = (OfferTimeZoneProcessor)EasyMock.createMock(OfferTimeZoneProcessor.class);
        this.orderProcessor = new OrderOfferProcessorImpl();
        this.orderProcessor.setOfferDao(this.offerDaoMock);
        this.orderProcessor.setOfferTimeZoneProcessor(this.offerTimeZoneProcessorMock);
        this.orderProcessor.setPromotableItemFactory((PromotableItemFactory)new PromotableItemFactoryImpl());
    }

    public void replay() {
        EasyMock.expect((Object)this.offerTimeZoneProcessorMock.getTimeZone((Offer)EasyMock.isA(OfferImpl.class))).andReturn((Object)TimeZone.getTimeZone("CST")).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.offerDaoMock});
        EasyMock.replay((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void verify() {
        EasyMock.verify((Object[])new Object[]{this.offerDaoMock});
        EasyMock.verify((Object[])new Object[]{this.offerTimeZoneProcessorMock});
    }

    public void testFilterOffers() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createCustomerBasedOffer("customer.registered==true", this.dataProvider.yesterday(), this.dataProvider.yesterday(), OfferDiscountType.PERCENT_OFF);
        this.orderProcessor.filterOffers(offers, order.getOrder().getCustomer());
        OrderOfferProcessorTest.assertTrue((offers.size() == 0 ? 1 : 0) != 0);
        offers = this.dataProvider.createCustomerBasedOffer("customer.registered==true", this.dataProvider.yesterday(), this.dataProvider.tomorrow(), OfferDiscountType.PERCENT_OFF);
        this.orderProcessor.filterOffers(offers, order.getOrder().getCustomer());
        OrderOfferProcessorTest.assertTrue((offers.size() == 1 ? 1 : 0) != 0);
        offers = this.dataProvider.createCustomerBasedOffer("customer.registered==false", this.dataProvider.yesterday(), this.dataProvider.tomorrow(), OfferDiscountType.PERCENT_OFF);
        this.orderProcessor.filterOffers(offers, order.getOrder().getCustomer());
        OrderOfferProcessorTest.assertTrue((offers.size() == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testFilterOrderLevelOffer() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        ArrayList qualifiedOffers = new ArrayList();
        List<Offer> offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF);
        this.orderProcessor.filterOrderLevelOffer(order, qualifiedOffers, offers.get(0));
        OrderOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateOrderOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createOrderBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        this.orderProcessor.filterOrderLevelOffer(order, qualifiedOffers, offers.get(0));
        OrderOfferProcessorTest.assertTrue((qualifiedOffers.size() == 1 && ((PromotableCandidateOrderOffer)qualifiedOffers.get(0)).getOffer().equals(offers.get(0)) ? 1 : 0) != 0);
        qualifiedOffers = new ArrayList();
        offers = this.dataProvider.createOrderBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([5,6] contains discreteOrderItem.category.id.intValue())");
        this.orderProcessor.filterOrderLevelOffer(order, qualifiedOffers, offers.get(0));
        OrderOfferProcessorTest.assertTrue((qualifiedOffers.size() == 0 ? 1 : 0) != 0);
        this.verify();
    }

    public void testCouldOfferApplyToOrder() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF);
        boolean couldApply = this.orderProcessor.couldOfferApplyToOrder(offers.get(0), order, (PromotableOrderItem)order.getDiscountableOrderItems().get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        OrderOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createOrderBasedOffer("order.subTotal.getAmount()==0", OfferDiscountType.PERCENT_OFF);
        couldApply = this.orderProcessor.couldOfferApplyToOrder(offers.get(0), order, (PromotableOrderItem)order.getDiscountableOrderItems().get(0), (PromotableFulfillmentGroup)order.getFulfillmentGroups().get(0));
        OrderOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOrderItemMeetOfferRequirement() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createOrderBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        OfferQualifyingCriteriaXref xref = (OfferQualifyingCriteriaXref)offers.get(0).getQualifyingItemCriteriaXref().iterator().next();
        boolean couldApply = this.orderProcessor.couldOrderItemMeetOfferRequirement(xref.getOfferItemCriteria(), (PromotableOrderItem)order.getDiscountableOrderItems().get(0));
        OrderOfferProcessorTest.assertTrue((boolean)couldApply);
        offers = this.dataProvider.createOrderBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        xref = (OfferQualifyingCriteriaXref)offers.get(0).getQualifyingItemCriteriaXref().iterator().next();
        couldApply = this.orderProcessor.couldOrderItemMeetOfferRequirement(xref.getOfferItemCriteria(), (PromotableOrderItem)order.getDiscountableOrderItems().get(0));
        OrderOfferProcessorTest.assertFalse((boolean)couldApply);
        this.verify();
    }

    public void testCouldOfferApplyToOrderItems() throws Exception {
        this.replay();
        PromotableOrder order = this.dataProvider.createBasicPromotableOrder();
        List<Offer> offers = this.dataProvider.createOrderBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test1\"), MVEL.eval(\"toUpperCase()\",\"test2\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        ArrayList<PromotableOrderItem> orderItems = new ArrayList<PromotableOrderItem>();
        for (PromotableOrderItem orderItem : order.getDiscountableOrderItems()) {
            orderItems.add(orderItem);
        }
        CandidatePromotionItems candidates = this.orderProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        OrderOfferProcessorTest.assertTrue((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        offers = this.dataProvider.createOrderBasedOfferWithItemCriteria("order.subTotal.getAmount()>20", OfferDiscountType.PERCENT_OFF, "([MVEL.eval(\"toUpperCase()\",\"test5\"), MVEL.eval(\"toUpperCase()\",\"test6\")] contains MVEL.eval(\"toUpperCase()\", discreteOrderItem.category.name))");
        candidates = this.orderProcessor.couldOfferApplyToOrderItems(offers.get(0), orderItems);
        OrderOfferProcessorTest.assertFalse((candidates.isMatchedQualifier() && candidates.getCandidateQualifiersMap().size() == 1 ? 1 : 0) != 0);
        this.verify();
    }
}

