/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jms.IllegalStateException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.params.CoreAdminParams;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.SolrContext;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="blSolrHelperService")
public class SolrHelperServiceImpl
implements SolrHelperService {
    private static final Log LOG = LogFactory.getLog(SolrHelperServiceImpl.class);
    protected static final String GLOBAL_FACET_TAG_FIELD = "a";
    protected static final String DEFAULT_NAMESPACE = "d";
    protected static final String PREFIX_SEPARATOR = "_";
    protected static Locale defaultLocale;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;

    @Override
    public synchronized void swapActiveCores() throws ServiceException {
        if (SolrContext.isSolrCloudMode()) {
            CloudSolrServer primary = (CloudSolrServer)SolrContext.getServer();
            CloudSolrServer reindex = (CloudSolrServer)SolrContext.getReindexServer();
            try {
                primary.connect();
                Aliases aliases = primary.getZkStateReader().getAliases();
                Map aliasCollectionMap = aliases.getCollectionAliasMap();
                if (aliasCollectionMap == null || !aliasCollectionMap.containsKey(primary.getDefaultCollection()) || !aliasCollectionMap.containsKey(reindex.getDefaultCollection())) {
                    throw new IllegalStateException("Could not determine the PRIMARY or REINDEX collection or collections from the Solr aliases.");
                }
                String primaryCollectionName = (String)aliasCollectionMap.get(primary.getDefaultCollection());
                primaryCollectionName = primaryCollectionName.split(",")[0];
                String reindexCollectionName = (String)aliasCollectionMap.get(reindex.getDefaultCollection());
                reindexCollectionName = reindexCollectionName.split(",")[0];
                CollectionAdminRequest.createAlias((String)primary.getDefaultCollection(), (String)reindexCollectionName, (SolrServer)primary);
                CollectionAdminRequest.createAlias((String)reindex.getDefaultCollection(), (String)primaryCollectionName, (SolrServer)primary);
            }
            catch (Exception e) {
                LOG.error((Object)"An exception occured swapping cores.", (Throwable)e);
                throw new ServiceException("Unable to swap SolrCloud collections after a full reindex.", (Throwable)e);
            }
        }
        if (SolrContext.isSingleCoreMode()) {
            LOG.debug((Object)"In single core mode. There are no cores to swap.");
        } else {
            LOG.debug((Object)"Swapping active cores");
            CoreAdminRequest car = new CoreAdminRequest();
            car.setCoreName("primary");
            car.setOtherCoreName("reindex");
            car.setAction(CoreAdminParams.CoreAdminAction.SWAP);
            try {
                SolrContext.getAdminServer().request((SolrRequest)car);
            }
            catch (Exception e) {
                LOG.error((Object)e);
                throw new ServiceException("Unable to swap cores", (Throwable)e);
            }
        }
    }

    @Override
    public String getCurrentNamespace() {
        return DEFAULT_NAMESPACE;
    }

    @Override
    public String getGlobalFacetTagField() {
        return GLOBAL_FACET_TAG_FIELD;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType, String prefix) {
        return prefix + field.getAbbreviation() + PREFIX_SEPARATOR + searchableFieldType.getType();
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field, String prefix) {
        if (field.getFacetFieldType() == null) {
            return null;
        }
        return prefix + field.getAbbreviation() + PREFIX_SEPARATOR + field.getFacetFieldType().getType();
    }

    @Override
    public List<FieldType> getSearchableFieldTypes(Field field) {
        ArrayList<FieldType> typesToConsider = new ArrayList<FieldType>();
        if (CollectionUtils.isNotEmpty(field.getSearchableFieldTypes())) {
            typesToConsider.addAll(field.getSearchableFieldTypes());
        }
        if (CollectionUtils.isEmpty(typesToConsider)) {
            typesToConsider.add(FieldType.TEXT);
        }
        return typesToConsider;
    }

    @Override
    public String getPropertyNameForFieldSearchable(Field field, FieldType searchableFieldType) {
        ArrayList<String> prefixList = new ArrayList<String>();
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).buildPrefixListForSearchableField(field, searchableFieldType, prefixList);
        String prefix = this.convertPrefixListToString(prefixList);
        return this.getPropertyNameForFieldSearchable(field, searchableFieldType, prefix);
    }

    @Override
    public String getPropertyNameForFieldFacet(Field field) {
        FieldType fieldType = field.getFacetFieldType();
        if (fieldType == null) {
            return null;
        }
        ArrayList<String> prefixList = new ArrayList<String>();
        ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).buildPrefixListForSearchableFacet(field, prefixList);
        String prefix = this.convertPrefixListToString(prefixList);
        return this.getPropertyNameForFieldFacet(field, prefix);
    }

    protected String convertPrefixListToString(List<String> prefixList) {
        StringBuilder prefixString = new StringBuilder();
        for (String prefix : prefixList) {
            if (prefix == null || prefix.isEmpty()) continue;
            prefixString = prefixString.append(prefix).append(PREFIX_SEPARATOR);
        }
        return prefixString.toString();
    }

    @Override
    public Long getCategoryId(Long tentativeCategoryId) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getCategoryId(tentativeCategoryId, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return tentativeCategoryId;
    }

    @Override
    public Long getProductId(Long tentativeProductId) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getProductId(tentativeProductId, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return tentativeProductId;
    }

    @Override
    public Long getSkuId(Long tentativeSkuId) {
        Long[] returnId = new Long[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getSkuId(tentativeSkuId, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return tentativeSkuId;
    }

    @Override
    public String getSolrDocumentId(SolrInputDocument document, Product product) {
        String[] returnId = new String[1];
        ExtensionResultStatusType result = ((SolrSearchServiceExtensionHandler)this.extensionManager.getProxy()).getSolrDocumentId(document, product, returnId);
        if (result.equals((Object)ExtensionResultStatusType.HANDLED)) {
            return returnId[0];
        }
        return String.valueOf(product.getId());
    }

    @Override
    public String getSolrDocumentId(SolrInputDocument document, Sku sku) {
        return String.valueOf(sku.getId());
    }

    @Override
    public String getNamespaceFieldName() {
        return "namespace";
    }

    @Override
    public String getIdFieldName() {
        return "id";
    }

    @Override
    public String getProductIdFieldName() {
        return "productId";
    }

    @Override
    public String getSkuIdFieldName() {
        return "skuId";
    }

    @Override
    public String getCategoryFieldName() {
        return "category";
    }

    @Override
    public String getExplicitCategoryFieldName() {
        return "explicitCategory";
    }

    @Override
    public String getCategorySortFieldName(Category category) {
        Long categoryId = this.getCategoryId(category.getId());
        return this.getCategoryFieldName() + PREFIX_SEPARATOR + categoryId + PREFIX_SEPARATOR + "sort_d";
    }

    @Override
    public String getCategorySortFieldName(Long categoryId) {
        categoryId = this.getCategoryId(categoryId);
        return this.getCategoryFieldName() + PREFIX_SEPARATOR + categoryId + PREFIX_SEPARATOR + "sort_d";
    }

    @Override
    public String getLocalePrefix() {
        Locale locale;
        if (BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            return locale.getLocaleCode() + PREFIX_SEPARATOR;
        }
        return this.getDefaultLocalePrefix();
    }

    @Override
    public String getDefaultLocalePrefix() {
        return this.getDefaultLocale().getLocaleCode() + PREFIX_SEPARATOR;
    }

    @Override
    public Locale getDefaultLocale() {
        if (defaultLocale == null) {
            defaultLocale = this.localeService.findDefaultLocale();
        }
        return defaultLocale;
    }

    @Override
    public Object getPropertyValue(Object object, Field field) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.getPropertyValue(object, field.getPropertyName());
    }

    @Override
    public Object getPropertyValue(Object object, String propertyName) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String[] components = propertyName.split("\\.");
        return this.getPropertyValueInternal(object, components, 0);
    }

    protected Object getPropertyValueInternal(Object object, String[] components, int currentPosition) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (object == null) {
            return null;
        }
        HashSet<Object> propertyObject = PropertyUtils.getProperty((Object)object, (String)components[currentPosition]);
        if (propertyObject != null && currentPosition < components.length - 1) {
            if (Collection.class.isAssignableFrom(propertyObject.getClass())) {
                Collection collection = propertyObject;
                HashSet<Object> newCollection = new HashSet<Object>();
                for (Object item : collection) {
                    Object result = this.getPropertyValueInternal(item, components, currentPosition + 1);
                    if (result == null) continue;
                    this.copyPropertyToCollection(newCollection, result);
                }
                propertyObject = newCollection;
            } else if (Map.class.isAssignableFrom(propertyObject.getClass())) {
                Map map = (Map)((Object)propertyObject);
                HashSet<Object> newCollection = new HashSet<Object>();
                for (Object item : map.values()) {
                    Object result = this.getPropertyValueInternal(item, components, currentPosition + 1);
                    if (result == null) continue;
                    this.copyPropertyToCollection(newCollection, result);
                }
                propertyObject = newCollection;
            } else if (propertyObject.getClass().isArray()) {
                Object[] array = (Object[])propertyObject;
                HashSet<Object> newCollection = new HashSet<Object>();
                for (Object item : array) {
                    Object result = this.getPropertyValueInternal(item, components, currentPosition + 1);
                    if (result == null) continue;
                    this.copyPropertyToCollection(newCollection, result);
                }
                propertyObject = newCollection;
            } else {
                propertyObject = this.getPropertyValueInternal(propertyObject, components, currentPosition + 1);
            }
        }
        return propertyObject;
    }

    protected void copyPropertyToCollection(Collection<Object> collection, Object o) {
        if (o == null) {
            return;
        }
        if (Collection.class.isAssignableFrom(o.getClass())) {
            collection.addAll((Collection)o);
        } else if (Map.class.isAssignableFrom(o.getClass())) {
            collection.addAll(((Map)o).values());
        } else if (o.getClass().isArray()) {
            Object[] array = (Object[])o;
            if (array.length > 0) {
                for (Object obj : array) {
                    collection.add(obj);
                }
            }
        } else {
            collection.add(o);
        }
    }
}

