/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.service.solr;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.beanutils.PropertyUtils;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.i18n.service.TranslationConsiderationContext;
import org.broadleafcommerce.common.i18n.service.TranslationService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.service.LocaleService;
import org.broadleafcommerce.common.util.BLCSystemProperty;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.search.domain.Field;
import org.broadleafcommerce.core.search.domain.solr.FieldType;
import org.broadleafcommerce.core.search.service.solr.AbstractSolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrHelperService;
import org.broadleafcommerce.core.search.service.solr.SolrIndexServiceImpl;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionHandler;
import org.broadleafcommerce.core.search.service.solr.SolrSearchServiceExtensionManager;
import org.springframework.stereotype.Service;

@Service(value="blI18nSolrSearchServiceExtensionHandler")
public class I18nSolrSearchServiceExtensionHandler
extends AbstractSolrSearchServiceExtensionHandler
implements SolrSearchServiceExtensionHandler {
    @Resource(name="blSolrHelperService")
    protected SolrHelperService shs;
    @Resource(name="blSolrSearchServiceExtensionManager")
    protected SolrSearchServiceExtensionManager extensionManager;
    @Resource(name="blTranslationService")
    protected TranslationService translationService;
    @Resource(name="blLocaleService")
    protected LocaleService localeService;
    private static String PRODUCT_ATTR_MAP = SolrIndexServiceImpl.PRODUCT_ATTR_MAP;
    private static String SKU_ATTR_MAP = SolrIndexServiceImpl.SKU_ATTR_MAP;

    protected boolean getTranslationEnabled() {
        return BLCSystemProperty.resolveBooleanSystemProperty((String)"i18n.translation.enabled");
    }

    @PostConstruct
    public void init() {
        boolean shouldAdd = true;
        for (SolrSearchServiceExtensionHandler h : this.extensionManager.getHandlers()) {
            if (!(h instanceof I18nSolrSearchServiceExtensionHandler)) continue;
            shouldAdd = false;
            break;
        }
        if (shouldAdd) {
            this.extensionManager.getHandlers().add(this);
        }
    }

    @Override
    public ExtensionResultStatusType buildPrefixListForSearchableFacet(Field field, List<String> prefixList) {
        return this.getLocalePrefix(field, prefixList);
    }

    @Override
    public ExtensionResultStatusType buildPrefixListForSearchableField(Field field, FieldType searchableFieldType, List<String> prefixList) {
        return this.getLocalePrefix(field, prefixList);
    }

    @Override
    public ExtensionResultStatusType addPropertyValues(Product product, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.addPropertyValues(product, null, false, field, fieldType, values, propertyName, locales);
    }

    @Override
    public ExtensionResultStatusType addPropertyValues(Sku sku, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.addPropertyValues(null, sku, true, field, fieldType, values, propertyName, locales);
    }

    protected ExtensionResultStatusType addPropertyValues(Product product, Sku sku, boolean useSku, Field field, FieldType fieldType, Map<String, Object> values, String propertyName, List<Locale> locales) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        HashSet<String> processedLocaleCodes = new HashSet<String>();
        ExtensionResultStatusType result = ExtensionResultStatusType.NOT_HANDLED;
        if (field.getTranslatable().booleanValue()) {
            result = ExtensionResultStatusType.HANDLED;
            for (Locale locale : locales) {
                int pos;
                String localeCode = locale.getLocaleCode();
                if (!Boolean.TRUE.equals(locale.getUseCountryInSearchIndex()) && (pos = localeCode.indexOf("_")) > 0) {
                    if (processedLocaleCodes.contains(localeCode = localeCode.substring(0, pos))) continue;
                    locale = this.localeService.findLocaleByCode(localeCode);
                }
                processedLocaleCodes.add(localeCode);
                TranslationConsiderationContext.setTranslationConsiderationContext((Boolean)this.getTranslationEnabled());
                TranslationConsiderationContext.setTranslationService((TranslationService)this.translationService);
                BroadleafRequestContext tempContext = BroadleafRequestContext.getBroadleafRequestContext();
                if (tempContext == null) {
                    tempContext = new BroadleafRequestContext();
                }
                tempContext.setLocale(locale);
                BroadleafRequestContext.setBroadleafRequestContext((BroadleafRequestContext)tempContext);
                Object propertyValue = useSku ? (propertyName.contains(SKU_ATTR_MAP) ? PropertyUtils.getMappedProperty((Object)sku, (String)SKU_ATTR_MAP, (String)propertyName.substring(SKU_ATTR_MAP.length() + 1)) : this.shs.getPropertyValue((Object)sku, propertyName)) : (propertyName.contains(PRODUCT_ATTR_MAP) ? PropertyUtils.getMappedProperty((Object)product, (String)PRODUCT_ATTR_MAP, (String)propertyName.substring(PRODUCT_ATTR_MAP.length() + 1)) : this.shs.getPropertyValue((Object)product, propertyName));
                values.put(localeCode, propertyValue);
            }
        }
        return result;
    }

    protected ExtensionResultStatusType getLocalePrefix(Field field, List<String> prefixList) {
        Locale locale;
        if (field.getTranslatable().booleanValue() && BroadleafRequestContext.getBroadleafRequestContext() != null && (locale = BroadleafRequestContext.getBroadleafRequestContext().getLocale()) != null) {
            int pos;
            String localeCode = locale.getLocaleCode();
            if (!Boolean.TRUE.equals(locale.getUseCountryInSearchIndex()) && (pos = localeCode.indexOf("_")) > 0) {
                localeCode = localeCode.substring(0, pos);
            }
            prefixList.add(localeCode);
            return ExtensionResultStatusType.HANDLED_CONTINUE;
        }
        return ExtensionResultStatusType.NOT_HANDLED;
    }

    public int getPriority() {
        return 1000;
    }
}

