/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.search.dao;

import com.google.common.collect.BiMap;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.common.util.BLCCollectionUtils;
import org.broadleafcommerce.common.util.TypedTransformer;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.search.dao.CatalogStructure;
import org.broadleafcommerce.core.search.dao.ParentCategoryByCategory;
import org.broadleafcommerce.core.search.dao.ParentCategoryByProduct;
import org.broadleafcommerce.core.search.dao.ProductsByCategoryWithOrder;
import org.broadleafcommerce.core.search.dao.SolrIndexDao;
import org.springframework.stereotype.Repository;

@Repository(value="blSolrIndexDao")
public class SolrIndexDaoImpl
implements SolrIndexDao {
    protected static final Log LOG = LogFactory.getLog(SolrIndexDaoImpl.class);
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;

    @Override
    public void populateProductCatalogStructure(List<Long> productIds, CatalogStructure catalogStructure) {
        HashMap parentCategoriesByProduct = new HashMap();
        HashMap<Long, Set<Long>> parentCategoriesByCategory = new HashMap<Long, Set<Long>>();
        Long[] products = productIds.toArray(new Long[productIds.size()]);
        BiMap sandBoxProductToOriginalMap = this.sandBoxHelper.getSandBoxToOriginalMap(ProductImpl.class, products);
        int batchSize = 800;
        int count = 0;
        int pos = 0;
        while (pos < products.length) {
            int remaining = products.length - pos;
            int mySize = remaining > batchSize ? batchSize : remaining;
            Long[] temp = new Long[mySize];
            System.arraycopy(products, pos, temp, 0, mySize);
            TypedQuery query = this.em.createNamedQuery("BC_READ_PARENT_CATEGORY_IDS_BY_PRODUCTS", ParentCategoryByProduct.class);
            query.setParameter("productIds", (Object)this.sandBoxHelper.mergeCloneIds(ProductImpl.class, temp));
            List results = query.getResultList();
            for (ParentCategoryByProduct parentCategoryByProduct : results) {
                Long sandBoxVal;
                Long sandBoxProductVal = parentCategoryByProduct.getProduct();
                BiMap reverse = sandBoxProductToOriginalMap.inverse();
                if (reverse.containsKey((Object)sandBoxProductVal)) {
                    sandBoxProductVal = (Long)reverse.get((Object)sandBoxProductVal);
                }
                if (catalogStructure.getParentCategoriesByProduct().containsKey(sandBoxProductVal)) continue;
                if (!parentCategoriesByProduct.containsKey(sandBoxProductVal)) {
                    parentCategoriesByProduct.put(sandBoxProductVal, new HashSet());
                }
                if ((sandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, parentCategoryByProduct.getParent())) == null) {
                    sandBoxVal = parentCategoryByProduct.getParent();
                }
                ((Set)parentCategoriesByProduct.get(sandBoxProductVal)).add(sandBoxVal);
            }
            for (Map.Entry entry : parentCategoriesByProduct.entrySet()) {
                for (Long categoryId : (Set)entry.getValue()) {
                    if (!catalogStructure.getParentCategoriesByCategory().containsKey(categoryId)) {
                        HashSet hierarchy = new HashSet();
                        parentCategoriesByCategory.put(categoryId, hierarchy);
                    }
                    if (catalogStructure.getProductsByCategory().containsKey(categoryId)) continue;
                    List<ProductsByCategoryWithOrder> categoryChildren = this.readProductIdsByCategory(categoryId);
                    BigDecimal displayOrder = new BigDecimal("1.00000");
                    for (ProductsByCategoryWithOrder child : categoryChildren) {
                        catalogStructure.getDisplayOrdersByCategoryProduct().put(categoryId + "-" + child.getProductId(), child.getDisplayOrder() == null ? displayOrder : child.getDisplayOrder());
                        if (child.getDisplayOrder() != null) {
                            displayOrder = child.displayOrder;
                        }
                        displayOrder = displayOrder.add(new BigDecimal("1.00000"));
                    }
                    for (Map.Entry sandBoxProduct : sandBoxProductToOriginalMap.entrySet()) {
                        for (ProductsByCategoryWithOrder child : categoryChildren) {
                            if (!child.getProductId().equals(sandBoxProduct.getValue())) continue;
                            child.setProductId((Long)sandBoxProduct.getKey());
                        }
                    }
                    List categoryChildProductIds = BLCCollectionUtils.collectList(categoryChildren, (TypedTransformer)new TypedTransformer<Long>(){

                        public Long transform(Object input) {
                            return ((ProductsByCategoryWithOrder)input).getProductId();
                        }
                    });
                    catalogStructure.getProductsByCategory().put(categoryId, categoryChildProductIds);
                }
            }
            pos = ++count * batchSize < products.length ? count * batchSize : products.length;
        }
        this.readFullCategoryHierarchy(parentCategoriesByCategory, new HashSet<Long>());
        catalogStructure.getParentCategoriesByProduct().putAll(parentCategoriesByProduct);
        catalogStructure.getParentCategoriesByCategory().putAll(parentCategoriesByCategory);
    }

    protected List<ProductsByCategoryWithOrder> readProductIdsByCategory(Long categoryId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_PRODUCT_IDS_BY_CATEGORY_WITH_ORDER", ProductsByCategoryWithOrder.class);
        query.setParameter("categoryIds", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, new Long[]{categoryId}));
        return query.getResultList();
    }

    protected void readFullCategoryHierarchy(Map<Long, Set<Long>> categoryHierarchy, Set<Long> builtCategories) {
        HashMap<Long, Set<Long>> nextLevel = new HashMap<Long, Set<Long>>();
        Long[] categoryIds = categoryHierarchy.keySet().toArray(new Long[categoryHierarchy.keySet().size()]);
        int batchSize = 800;
        int count = 0;
        int pos = 0;
        while (pos < categoryIds.length) {
            int remaining = categoryIds.length - pos;
            int mySize = remaining > batchSize ? batchSize : remaining;
            Long[] temp = new Long[mySize];
            System.arraycopy(categoryIds, pos, temp, 0, mySize);
            TypedQuery query = this.em.createNamedQuery("BC_READ_PARENT_CATEGORY_IDS_BY_CATEGORIES", ParentCategoryByCategory.class);
            query.setParameter("categoryIds", (Object)this.sandBoxHelper.mergeCloneIds(CategoryImpl.class, temp));
            List results = query.getResultList();
            for (ParentCategoryByCategory item : results) {
                Long sandBoxVal;
                Long childSandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, item.getChild());
                if (childSandBoxVal == null) {
                    childSandBoxVal = item.getChild();
                }
                if (builtCategories.contains(childSandBoxVal)) {
                    LOG.warn((Object)("Category circular reference identified for category id " + childSandBoxVal));
                    continue;
                }
                builtCategories.add(childSandBoxVal);
                Set<Long> hierarchy = categoryHierarchy.get(childSandBoxVal);
                if (item.getParent() != null) {
                    sandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, item.getParent());
                    if (sandBoxVal == null) {
                        sandBoxVal = item.getParent();
                    }
                    hierarchy.add(sandBoxVal);
                    if (!nextLevel.containsKey(sandBoxVal)) {
                        nextLevel.put(sandBoxVal, new HashSet());
                    }
                }
                if (item.getDefaultParent() == null) continue;
                sandBoxVal = this.sandBoxHelper.getSandBoxVersionId(CategoryImpl.class, item.getDefaultParent());
                if (sandBoxVal == null) {
                    sandBoxVal = item.getDefaultParent();
                }
                hierarchy.add(sandBoxVal);
                if (nextLevel.containsKey(sandBoxVal)) continue;
                nextLevel.put(sandBoxVal, new HashSet());
            }
            pos = ++count * batchSize < categoryIds.length ? count * batchSize : categoryIds.length;
        }
        if (!nextLevel.isEmpty()) {
            this.readFullCategoryHierarchy(nextLevel, builtCategories);
        }
        categoryHierarchy.putAll(nextLevel);
    }
}

