/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.service.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Offer;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.broadleafcommerce.core.offer.service.OfferServiceExtensionHandler;
import org.broadleafcommerce.core.offer.service.discount.CandidatePromotionItems;
import org.broadleafcommerce.core.offer.service.discount.ItemOfferComparator;
import org.broadleafcommerce.core.offer.service.discount.ItemOfferQtyOneComparator;
import org.broadleafcommerce.core.offer.service.discount.OrderOfferComparator;
import org.broadleafcommerce.core.offer.service.discount.PromotionDiscount;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateItemOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableCandidateOrderOffer;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableFulfillmentGroup;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrder;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItem;
import org.broadleafcommerce.core.offer.service.discount.domain.PromotableOrderItemPriceDetail;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferMarkTargets;
import org.broadleafcommerce.core.offer.service.processor.ItemOfferProcessor;
import org.broadleafcommerce.core.offer.service.processor.OrderOfferProcessorImpl;
import org.broadleafcommerce.core.offer.service.type.OfferType;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.dto.OrderItemHolder;
import org.springframework.stereotype.Service;

@Service(value="blItemOfferProcessor")
public class ItemOfferProcessorImpl
extends OrderOfferProcessorImpl
implements ItemOfferProcessor,
ItemOfferMarkTargets {
    protected static final Log LOG = LogFactory.getLog(ItemOfferProcessorImpl.class);

    @Override
    public void filterItemLevelOffer(PromotableOrder order, List<PromotableCandidateItemOffer> qualifiedItemOffers, Offer offer) {
        boolean isNewFormat = CollectionUtils.isNotEmpty(offer.getQualifyingItemCriteriaXref()) || CollectionUtils.isNotEmpty(offer.getTargetItemCriteriaXref());
        boolean itemLevelQualification = false;
        boolean offerCreated = false;
        block0: for (PromotableOrderItem promotableOrderItem : order.getDiscountableOrderItems()) {
            if (this.couldOfferApplyToOrder(offer, order, promotableOrderItem)) {
                if (!isNewFormat) {
                    PromotableCandidateItemOffer candidate = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                    if (!candidate.getLegacyCandidateTargets().contains(promotableOrderItem)) {
                        candidate.getLegacyCandidateTargets().add(promotableOrderItem);
                    }
                    offerCreated = true;
                    continue;
                }
                itemLevelQualification = true;
                break;
            }
            for (PromotableFulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
                if (!this.couldOfferApplyToOrder(offer, order, promotableOrderItem, fulfillmentGroup)) continue;
                if (!isNewFormat) {
                    PromotableCandidateItemOffer candidate = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                    if (!candidate.getLegacyCandidateTargets().contains(promotableOrderItem)) {
                        candidate.getLegacyCandidateTargets().add(promotableOrderItem);
                    }
                    offerCreated = true;
                    continue;
                }
                itemLevelQualification = true;
                continue block0;
            }
        }
        if (itemLevelQualification && !offerCreated) {
            CandidatePromotionItems candidates = this.couldOfferApplyToOrderItems(offer, order.getDiscountableOrderItems(offer.getApplyDiscountToSalePrice()));
            PromotableCandidateItemOffer candidateOffer = null;
            if (candidates.isMatchedQualifier()) {
                candidateOffer = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                candidateOffer.getCandidateQualifiersMap().putAll(candidates.getCandidateQualifiersMap());
            }
            if (candidates.isMatchedTarget() && candidates.isMatchedQualifier()) {
                if (candidateOffer == null) {
                    candidateOffer = this.createCandidateItemOffer(qualifiedItemOffers, offer, order);
                }
                candidateOffer.getCandidateTargetsMap().putAll(candidates.getCandidateTargetsMap());
            }
        }
    }

    protected PromotableCandidateItemOffer createCandidateItemOffer(List<PromotableCandidateItemOffer> qualifiedItemOffers, Offer offer, PromotableOrder promotableOrder) {
        PromotableCandidateItemOffer promotableCandidateItemOffer = this.promotableItemFactory.createPromotableCandidateItemOffer(promotableOrder, offer);
        qualifiedItemOffers.add(promotableCandidateItemOffer);
        return promotableCandidateItemOffer;
    }

    @Override
    public void applyAllItemOffers(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        for (PromotableCandidateItemOffer itemOffer : itemOffers) {
            if (!this.offerMeetsSubtotalRequirements(order, itemOffer)) continue;
            this.applyItemOffer(order, itemOffer);
        }
    }

    protected boolean offerMeetsSubtotalRequirements(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        return itemOffer.getOffer().getQualifyingItemSubTotal() == null || itemOffer.getOffer().getQualifyingItemSubTotal().lessThanOrEqual(Money.ZERO);
    }

    protected boolean isTotalitarianOfferAppliedToAnyItem(PromotableOrder order) {
        List<PromotableOrderItemPriceDetail> allPriceDetails = order.getAllPromotableOrderItemPriceDetails();
        for (PromotableOrderItemPriceDetail targetItem : allPriceDetails) {
            if (!targetItem.isTotalitarianOfferApplied()) continue;
            return true;
        }
        return false;
    }

    protected void applyAdjustments(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        List<PromotableOrderItemPriceDetail> itemPriceDetails = order.getAllPromotableOrderItemPriceDetails();
        this.offerServiceUtilities.applyAdjustmentsForItemPriceDetails(itemOffer, itemPriceDetails);
    }

    protected void applyLegacyAdjustments(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        for (PromotableOrderItem item : itemOffer.getLegacyCandidateTargets()) {
            for (PromotableOrderItemPriceDetail itemPriceDetail : item.getPromotableOrderItemPriceDetails()) {
                if (!itemOffer.getOffer().isStackable() || !itemOffer.getOffer().isCombinableWithOtherOffers() ? itemPriceDetail.getCandidateItemAdjustments().size() != 0 : itemPriceDetail.hasNonCombinableAdjustments()) continue;
                this.offerServiceUtilities.applyOrderItemAdjustment(itemOffer, itemPriceDetail);
            }
        }
    }

    protected Boolean applyItemOfferExtension(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (this.extensionManager != null) {
            ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).applyItemOffer(order, itemOffer, contextMap);
            if (contextMap.get("stopProcessing") != null) {
                return !Boolean.TRUE.equals(contextMap.get("stopProcessing"));
            }
        }
        return Boolean.TRUE;
    }

    protected void applyItemOffer(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        if (this.applyItemOfferExtension(order, itemOffer).booleanValue() && this.offerServiceUtilities.itemOfferCanBeApplied(itemOffer, order.getAllPromotableOrderItemPriceDetails())) {
            this.applyItemQualifiersAndTargets(itemOffer, order);
            if (itemOffer.isLegacyOffer()) {
                this.applyLegacyAdjustments(order, itemOffer);
            } else {
                this.applyAdjustments(order, itemOffer);
            }
        }
    }

    protected void chooseSaleOrRetailAdjustments(PromotableOrder order) {
        List<PromotableOrderItemPriceDetail> itemPriceDetails = order.getAllPromotableOrderItemPriceDetails();
        for (PromotableOrderItemPriceDetail itemDetail : itemPriceDetails) {
            itemDetail.chooseSaleOrRetailAdjustments();
        }
        this.mergePriceDetails(order);
    }

    protected void mergePriceDetails(PromotableOrder order) {
        List<PromotableOrderItem> items = order.getAllOrderItems();
        for (PromotableOrderItem item : items) {
            item.mergeLikeDetails();
        }
    }

    protected void applyItemQualifiersAndTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        if (itemOffer.isLegacyOffer()) {
            LOG.warn((Object)("The item offer with id " + itemOffer.getOffer().getId() + " is a legacy offer which means that it" + " does not have any item qualifier criteria AND does not have any target item criteria. As a result," + " we are skipping the marking of qualifiers and targets which will cause issues if you are relying on" + " 'maxUsesPerOrder' behavior. To resolve this, qualifier criteria is not required but you must at least" + " create some target item criteria for this offer."));
            return;
        }
        this.markQualifiersAndTargets(order, itemOffer);
        this.splitDetailsIfNecessary(order.getAllPromotableOrderItemPriceDetails());
    }

    protected List<PromotableOrderItemPriceDetail> buildPriceDetailListFromOrderItems(List<PromotableOrderItem> items) {
        ArrayList<PromotableOrderItemPriceDetail> itemPriceDetails = new ArrayList<PromotableOrderItemPriceDetail>();
        for (PromotableOrderItem item : items) {
            for (PromotableOrderItemPriceDetail detail : item.getPromotableOrderItemPriceDetails()) {
                itemPriceDetails.add(detail);
            }
        }
        return itemPriceDetails;
    }

    protected boolean markQualifiers(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        for (OfferItemCriteria itemCriteria : itemOffer.getCandidateQualifiersMap().keySet()) {
            List<PromotableOrderItem> promotableItems;
            List<PromotableOrderItemPriceDetail> priceDetails;
            int qualifierQtyNeeded = this.offerServiceUtilities.markQualifiersForCriteria(itemOffer, itemCriteria, priceDetails = this.buildPriceDetailListFromOrderItems(promotableItems = itemOffer.getCandidateQualifiersMap().get(itemCriteria)));
            if (qualifierQtyNeeded == 0) continue;
            return false;
        }
        return true;
    }

    protected boolean markTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order, OrderItem relatedQualifier) {
        return this.markTargets(itemOffer, order, relatedQualifier, false);
    }

    @Override
    public boolean markTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order, OrderItem relatedQualifier, boolean checkOnly) {
        Offer promotion = itemOffer.getOffer();
        if (itemOffer.getCandidateTargetsMap().keySet().isEmpty()) {
            return false;
        }
        OrderItem relatedQualifierRoot = this.offerServiceUtilities.findRelatedQualifierRoot(relatedQualifier);
        for (OfferItemCriteria itemCriteria : itemOffer.getCandidateTargetsMap().keySet()) {
            List<PromotableOrderItem> promotableItems = itemOffer.getCandidateTargetsMap().get(itemCriteria);
            List<PromotableOrderItemPriceDetail> priceDetails = this.buildPriceDetailListFromOrderItems(promotableItems);
            this.offerServiceUtilities.sortTargetItemDetails(priceDetails, itemOffer.getOffer().getApplyDiscountToSalePrice());
            int targetQtyNeeded = itemCriteria.getQuantity();
            if ((targetQtyNeeded = this.offerServiceUtilities.markTargetsForCriteria(itemOffer, relatedQualifier, checkOnly, promotion, relatedQualifierRoot, itemCriteria, priceDetails, targetQtyNeeded)) == 0) continue;
            return false;
        }
        if (!checkOnly) {
            itemOffer.addUse();
        }
        return true;
    }

    protected boolean markRelatedQualifiersAndTargets(PromotableCandidateItemOffer itemOffer, PromotableOrder order) {
        OrderItemHolder orderItemHolder = new OrderItemHolder(null);
        for (Map.Entry<OfferItemCriteria, List<PromotableOrderItem>> entry : itemOffer.getCandidateQualifiersMap().entrySet()) {
            List<PromotableOrderItem> promotableItems;
            List<PromotableOrderItemPriceDetail> priceDetails;
            OfferItemCriteria itemCriteria = entry.getKey();
            int qualifierQtyNeeded = this.offerServiceUtilities.markRelatedQualifiersAndTargetsForItemCriteria(itemOffer, order, orderItemHolder, itemCriteria, priceDetails = this.buildPriceDetailListFromOrderItems(promotableItems = entry.getValue()), this);
            if (qualifierQtyNeeded == 0) continue;
            return false;
        }
        return this.markTargets(itemOffer, order, orderItemHolder.getOrderItem(), false);
    }

    @Override
    public void filterOffers(PromotableOrder order, List<Offer> filteredOffers, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        order.setOrderSubTotalToPriceWithoutAdjustments();
        for (Offer offer : filteredOffers) {
            if (offer.getType().equals(OfferType.ORDER)) {
                this.filterOrderLevelOffer(order, qualifiedOrderOffers, offer);
                continue;
            }
            if (!offer.getType().equals(OfferType.ORDER_ITEM)) continue;
            this.filterItemLevelOffer(order, qualifiedItemOffers, offer);
        }
    }

    protected Money calculatePotentialSavingsForOrderItem(PromotableCandidateItemOffer itemOffer, PromotableOrderItem item, int quantity) {
        if (this.extensionManager != null) {
            HashMap<String, Object> contextMap = new HashMap<String, Object>();
            ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).calculatePotentialSavings(itemOffer, item, quantity, contextMap);
            Object o = contextMap.get("savings");
            if (o != null && o instanceof Money) {
                return (Money)o;
            }
            o = contextMap.get("quantity");
            if (o != null && o instanceof Integer) {
                quantity = (Integer)o;
            }
        }
        return itemOffer.calculateSavingsForOrderItem(item, quantity);
    }

    protected void calculatePotentialSavings(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        if (itemOffers.size() > 1) {
            for (PromotableCandidateItemOffer itemOffer : itemOffers) {
                Money potentialSavings = new Money(order.getOrderCurrency());
                if (itemOffer.isLegacyOffer()) {
                    for (PromotableOrderItem item : itemOffer.getLegacyCandidateTargets()) {
                        Money savings = itemOffer.calculateSavingsForOrderItem(item, item.getQuantity());
                        potentialSavings = potentialSavings.add(savings);
                    }
                } else {
                    this.markQualifiersAndTargets(order, itemOffer);
                    for (PromotableOrderItemPriceDetail detail : order.getAllPromotableOrderItemPriceDetails()) {
                        PromotableOrderItem item = detail.getPromotableOrderItem();
                        for (PromotionDiscount discount : detail.getPromotionDiscounts()) {
                            Money itemSavings = this.calculatePotentialSavingsForOrderItem(itemOffer, item, discount.getQuantity());
                            potentialSavings = potentialSavings.add(itemSavings);
                        }
                        detail.getPromotionDiscounts().clear();
                        detail.getPromotionQualifiers().clear();
                    }
                }
                itemOffer.setPotentialSavings(potentialSavings);
                if (itemOffer.getUses() == 0) {
                    itemOffer.setPotentialSavingsQtyOne(potentialSavings);
                    continue;
                }
                itemOffer.setPotentialSavingsQtyOne(potentialSavings.divide(itemOffer.getUses()));
            }
        }
    }

    protected void markQualifiersAndTargets(PromotableOrder order, PromotableCandidateItemOffer itemOffer) {
        boolean matchFound = true;
        if (itemOffer.isLegacyOffer()) {
            return;
        }
        boolean count = true;
        do {
            boolean qualifiersFound = false;
            boolean targetsFound = false;
            if (itemOffer.getOffer().getRequiresRelatedTargetAndQualifiers().booleanValue()) {
                boolean qualifiersAndTargetsFound;
                qualifiersFound = qualifiersAndTargetsFound = this.markRelatedQualifiersAndTargets(itemOffer, order);
                targetsFound = qualifiersAndTargetsFound;
            } else {
                qualifiersFound = this.markQualifiers(itemOffer, order);
                targetsFound = this.markTargets(itemOffer, order, null);
            }
            if (!qualifiersFound || !targetsFound) {
                this.clearAllNonFinalizedQuantities(order.getAllPromotableOrderItemPriceDetails());
                matchFound = false;
                break;
            }
            this.finalizeQuantities(order.getAllPromotableOrderItemPriceDetails());
        } while (matchFound);
    }

    protected boolean offerListStartsWithNonCombinable(List<PromotableCandidateItemOffer> offerList) {
        PromotableCandidateItemOffer offer;
        return offerList.size() > 1 && ((offer = offerList.get(0)).getOffer().isTotalitarianOffer() != false || !offer.getOffer().isCombinableWithOtherOffers());
    }

    protected List<List<PromotableCandidateItemOffer>> buildItemOfferPermutations(List<PromotableCandidateItemOffer> offers) {
        ArrayList<List<PromotableCandidateItemOffer>> listOfOfferLists = new ArrayList<List<PromotableCandidateItemOffer>>();
        listOfOfferLists.add(offers);
        if (offers.size() > 1) {
            ArrayList<PromotableCandidateItemOffer> qtyOneOffers = new ArrayList<PromotableCandidateItemOffer>(offers);
            Collections.sort(qtyOneOffers, ItemOfferQtyOneComparator.INSTANCE);
            for (int i = 0; i < qtyOneOffers.size(); ++i) {
                if (qtyOneOffers.get(i) == offers.get(i)) continue;
                listOfOfferLists.add(qtyOneOffers);
                break;
            }
        }
        if (this.offerListStartsWithNonCombinable(offers)) {
            ArrayList<PromotableCandidateItemOffer> listWithoutTotalitarianOrNonCombinables = new ArrayList<PromotableCandidateItemOffer>(offers);
            Iterator offerIterator = listWithoutTotalitarianOrNonCombinables.iterator();
            while (offerIterator.hasNext()) {
                PromotableCandidateItemOffer offer = (PromotableCandidateItemOffer)offerIterator.next();
                if (!offer.getOffer().isTotalitarianOffer().booleanValue() && offer.getOffer().isCombinableWithOtherOffers()) continue;
                offerIterator.remove();
            }
            if (listWithoutTotalitarianOrNonCombinables.size() > 0) {
                listOfOfferLists.add(listWithoutTotalitarianOrNonCombinables);
            }
        }
        return listOfOfferLists;
    }

    protected void restPriceDetails(PromotableOrderItem item) {
        item.resetPriceDetails();
        if (this.extensionManager != null) {
            ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).resetPriceDetails(item);
        }
    }

    protected void determineBestPermutation(List<PromotableCandidateItemOffer> itemOffers, PromotableOrder order) {
        List<List<PromotableCandidateItemOffer>> permutations = this.buildItemOfferPermutations(itemOffers);
        List<PromotableCandidateItemOffer> bestOfferList = null;
        Money lowestSubtotal = null;
        if (permutations.size() > 1) {
            for (List<PromotableCandidateItemOffer> offerList : permutations) {
                for (PromotableCandidateItemOffer offer : offerList) {
                    offer.resetUses();
                }
                this.applyAllItemOffers(offerList, order);
                this.chooseSaleOrRetailAdjustments(order);
                Money testSubtotal = order.calculateSubtotalWithAdjustments();
                if (lowestSubtotal == null || testSubtotal.lessThan(lowestSubtotal)) {
                    lowestSubtotal = testSubtotal;
                    bestOfferList = offerList;
                }
                for (PromotableOrderItem item : order.getDiscountableOrderItems()) {
                    item.resetPriceDetails();
                }
            }
        } else {
            bestOfferList = permutations.get(0);
        }
        for (PromotableCandidateItemOffer offer : bestOfferList) {
            offer.resetUses();
        }
        this.applyAllItemOffers(bestOfferList, order);
    }

    @Override
    public void applyAndCompareOrderAndItemOffers(PromotableOrder order, List<PromotableCandidateOrderOffer> qualifiedOrderOffers, List<PromotableCandidateItemOffer> qualifiedItemOffers) {
        if (!qualifiedItemOffers.isEmpty()) {
            this.calculatePotentialSavings(qualifiedItemOffers, order);
            for (PromotableCandidateItemOffer itemOffer : qualifiedItemOffers) {
                itemOffer.resetUses();
            }
            Collections.sort(qualifiedItemOffers, ItemOfferComparator.INSTANCE);
            if (qualifiedItemOffers.size() > 1) {
                this.determineBestPermutation(qualifiedItemOffers, order);
            } else {
                this.applyAllItemOffers(qualifiedItemOffers, order);
            }
        }
        this.chooseSaleOrRetailAdjustments(order);
        if (this.extensionManager != null) {
            ((OfferServiceExtensionHandler)this.extensionManager.getProxy()).chooseSaleOrRetailAdjustments(order);
        }
        order.setOrderSubTotalToPriceWithAdjustments();
        if (!qualifiedOrderOffers.isEmpty()) {
            Collections.sort(qualifiedOrderOffers, OrderOfferComparator.INSTANCE);
            this.applyAllOrderOffers(qualifiedOrderOffers, order);
        }
        order.setOrderSubTotalToPriceWithAdjustments();
        if (!qualifiedOrderOffers.isEmpty() && !qualifiedItemOffers.isEmpty()) {
            ArrayList<PromotableCandidateOrderOffer> finalQualifiedOrderOffers = new ArrayList<PromotableCandidateOrderOffer>();
            order.removeAllCandidateOrderOfferAdjustments();
            for (PromotableCandidateOrderOffer candidateOrderOffer : qualifiedOrderOffers) {
                if (!this.couldOfferApplyToOrder(candidateOrderOffer.getOffer(), order)) continue;
                finalQualifiedOrderOffers.add(candidateOrderOffer);
            }
            Collections.sort(finalQualifiedOrderOffers, OrderOfferComparator.INSTANCE);
            if (!finalQualifiedOrderOffers.isEmpty()) {
                this.applyAllOrderOffers(finalQualifiedOrderOffers, order);
                order.setOrderSubTotalToPriceWithAdjustments();
            }
        }
    }
}

