/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.offer.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.offer.domain.OfferItemCriteria;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BLC_OFFER_ITEM_CRITERIA")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blOffers")
@AdminPresentationClass(friendlyName="OfferItemCriteriaImpl_baseOfferItemCriteria")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class OfferItemCriteriaImpl
implements OfferItemCriteria {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OfferItemCriteriaId")
    @GenericGenerator(name="OfferItemCriteriaId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="OfferItemCriteriaImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.OfferItemCriteriaImpl")})
    @Column(name="OFFER_ITEM_CRITERIA_ID")
    @AdminPresentation(friendlyName="OfferItemCriteriaImpl_Item_Criteria_Id", group="OfferItemCriteriaImpl_Description", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="OfferItemCriteriaImpl_Quantity", group="OfferItemCriteriaImpl_Description", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Integer quantity;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="ORDER_ITEM_MATCH_RULE", length=0x7FFFFFFE)
    @AdminPresentation(friendlyName="OfferItemCriteriaImpl_Order_Item_Match_Rule", group="OfferItemCriteriaImpl_Description", visibility=VisibilityEnum.HIDDEN_ALL)
    protected String orderItemMatchRule;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer receiveQuantity) {
        this.quantity = receiveQuantity;
    }

    public String getMatchRule() {
        return this.orderItemMatchRule;
    }

    public void setMatchRule(String matchRule) {
        this.orderItemMatchRule = matchRule;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.orderItemMatchRule == null ? 0 : this.orderItemMatchRule.hashCode());
        result = 31 * result + (this.quantity == null ? 0 : this.quantity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        OfferItemCriteriaImpl other = (OfferItemCriteriaImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.orderItemMatchRule == null ? other.orderItemMatchRule != null : !this.orderItemMatchRule.equals(other.orderItemMatchRule)) {
            return false;
        }
        return !(this.quantity == null ? other.quantity != null : !this.quantity.equals(other.quantity));
    }

    public <G extends OfferItemCriteria> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        OfferItemCriteria cloned = (OfferItemCriteria)createResponse.getClone();
        cloned.setQuantity(this.quantity);
        cloned.setMatchRule(this.orderItemMatchRule);
        return createResponse;
    }
}

