/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionValue;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.service.type.ProductType;
import org.broadleafcommerce.core.search.domain.SearchCriteria;

public interface CatalogService {
    public Product saveProduct(Product var1);

    public Product findProductById(Long var1);

    public Product findProductByExternalId(String var1);

    public List<Product> findProductsByName(String var1);

    public List<Product> findProductsByName(String var1, int var2, int var3);

    public List<Product> findActiveProductsByCategory(Category var1);

    @Deprecated
    public List<Product> findActiveProductsByCategory(Category var1, Date var2);

    public List<Product> findFilteredActiveProductsByCategory(Category var1, SearchCriteria var2);

    public List<Product> findFilteredActiveProductsByCategory(Category var1, Date var2, SearchCriteria var3);

    public List<Product> findFilteredActiveProductsByQuery(String var1, SearchCriteria var2);

    public List<Product> findFilteredActiveProductsByQuery(String var1, Date var2, SearchCriteria var3);

    public List<Product> findActiveProductsByCategory(Category var1, int var2, int var3);

    @Deprecated
    public List<Product> findActiveProductsByCategory(Category var1, Date var2, int var3, int var4);

    public List<ProductBundle> findAutomaticProductBundles();

    public Category saveCategory(Category var1);

    public void removeCategory(Category var1);

    public void removeProduct(Product var1);

    public void removeSku(Sku var1);

    public Category findCategoryById(Long var1);

    public Category findCategoryByExternalId(String var1);

    @Deprecated
    public Category findCategoryByName(String var1);

    public List<Category> findCategoriesByName(String var1);

    public List<Category> findCategoriesByName(String var1, int var2, int var3);

    public List<Category> findAllCategories();

    public List<Category> findAllCategories(int var1, int var2);

    public List<Product> findAllProducts();

    public List<Product> findAllProducts(int var1, int var2);

    public List<Product> findProductsForCategory(Category var1);

    public List<Product> findProductsForCategory(Category var1, int var2, int var3);

    public Sku saveSku(Sku var1);

    public SkuFee saveSkuFee(SkuFee var1);

    public List<Sku> findAllSkus();

    public List<Sku> findSkusByIds(List<Long> var1);

    public Sku findSkuById(Long var1);

    public Sku findSkuByExternalId(String var1);

    public Sku findSkuByUpc(String var1);

    @Deprecated
    public Map<String, List<Long>> getChildCategoryURLMapByCategoryId(Long var1);

    public Category createCategory();

    public Sku createSku();

    public Product createProduct(ProductType var1);

    public List<Category> findAllParentCategories();

    public List<Category> findAllSubCategories(Category var1);

    public List<Category> findAllSubCategories(Category var1, int var2, int var3);

    public List<Category> findActiveSubCategoriesByCategory(Category var1);

    public List<Category> findActiveSubCategoriesByCategory(Category var1, int var2, int var3);

    public List<ProductOption> readAllProductOptions();

    public ProductOption saveProductOption(ProductOption var1);

    public ProductOption findProductOptionById(Long var1);

    public ProductOptionValue findProductOptionValueById(Long var1);

    public Category findCategoryByURI(String var1);

    public Product findProductByURI(String var1);

    public Sku findSkuByURI(String var1);
}

