/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCloneable;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.clone.ClonePolicy;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.media.domain.MediaImpl;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.util.UnknownUnwrapTypeException;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.broadleafcommerce.core.catalog.domain.SkuMediaXref;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_SKU_MEDIA_MAP")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@AdminPresentationClass(excludeFromPolymorphism=false, populateToOneFields=PopulateToOneFieldsEnum.TRUE)
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class SkuMediaXrefImpl
implements SkuMediaXref,
Media,
MultiTenantCloneable<SkuMediaXrefImpl> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SkuMediaId")
    @GenericGenerator(name="SkuMediaId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="SkuMediaXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.SkuMediaXrefImpl")})
    @Column(name="SKU_MEDIA_ID")
    protected Long id;
    @ManyToOne(targetEntity=SkuImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="BLC_SKU_SKU_ID")
    @AdminPresentation(excluded=true)
    protected Sku sku;
    @ManyToOne(targetEntity=MediaImpl.class, cascade={CascadeType.ALL})
    @JoinColumn(name="MEDIA_ID")
    @ClonePolicy
    protected Media media;
    @Column(name="MAP_KEY", nullable=false)
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected String key;

    public SkuMediaXrefImpl(Sku sku, Media media, String key) {
        this.sku = sku;
        this.media = media;
        this.key = key;
    }

    public SkuMediaXrefImpl() {
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Sku getSku() {
        return this.sku;
    }

    @Override
    public void setSku(Sku sku) {
        this.sku = sku;
    }

    @Override
    public Media getMedia() {
        return this.media;
    }

    @Override
    public void setMedia(Media media) {
        this.media = media;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getUrl() {
        this.createEntityInstance();
        return this.media.getUrl();
    }

    public void setUrl(String url) {
        this.createEntityInstance();
        this.media.setUrl(url);
    }

    public String getTitle() {
        this.createEntityInstance();
        return this.media.getTitle();
    }

    public void setTitle(String title) {
        this.createEntityInstance();
        this.media.setTitle(title);
    }

    public String getAltText() {
        this.createEntityInstance();
        return this.media.getAltText();
    }

    public void setAltText(String altText) {
        this.createEntityInstance();
        this.media.setAltText(altText);
    }

    public String getTags() {
        this.createEntityInstance();
        return this.media.getTags();
    }

    public void setTags(String tags) {
        this.createEntityInstance();
        this.media.setTags(tags);
    }

    protected void createEntityInstance() {
        if (this.media == null) {
            this.media = new MediaImpl();
        }
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return Media.class.equals((Object)unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (this.isUnwrappableAs(unwrapType)) {
            return (T)this.media;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public <G extends SkuMediaXrefImpl> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        SkuMediaXrefImpl cloned = (SkuMediaXrefImpl)createResponse.getClone();
        if (this.media != null) {
            cloned.setMedia((Media)((MediaImpl)this.media).createOrRetrieveCopyInstance(context).getClone());
        }
        cloned.setAltText(this.getAltText());
        cloned.setKey(this.key);
        if (this.sku != null) {
            cloned.setSku((Sku)this.sku.createOrRetrieveCopyInstance(context).getClone());
        }
        cloned.setTags(this.getTags());
        cloned.setUrl(this.getUrl());
        cloned.setTitle(this.getTitle());
        return createResponse;
    }
}

