/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.catalog.domain.ProductOptionImpl;
import org.broadleafcommerce.core.catalog.domain.ProductOptionXref;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PRODUCT_OPTION_XREF")
@AdminPresentationClass(excludeFromPolymorphism=false)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blProducts")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class ProductOptionXrefImpl
implements ProductOptionXref {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="ProductOptionXrefId")
    @GenericGenerator(name="ProductOptionXrefId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="ProductOptionXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.ProductOptionXrefImpl")})
    @Column(name="PRODUCT_OPTION_XREF_ID")
    protected Long id;
    @ManyToOne(targetEntity=ProductImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PRODUCT_ID")
    protected Product product = new ProductImpl();
    @ManyToOne(targetEntity=ProductOptionImpl.class, optional=false)
    @JoinColumn(name="PRODUCT_OPTION_ID")
    protected ProductOption productOption = new ProductOptionImpl();

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public ProductOption getProductOption() {
        return this.productOption;
    }

    @Override
    public void setProductOption(ProductOption productOption) {
        this.productOption = productOption;
    }

    public <G extends ProductOptionXref> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        ProductOptionXref cloned = (ProductOptionXref)createResponse.getClone();
        if (this.product != null) {
            cloned.setProduct((Product)this.product.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.productOption != null) {
            cloned.setProductOption((ProductOption)this.productOption.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

