/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.domain;

import java.math.BigDecimal;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.copy.CreateResponse;
import org.broadleafcommerce.common.copy.MultiTenantCopyContext;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransform;
import org.broadleafcommerce.common.extensibility.jpa.copy.DirectCopyTransformMember;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryImpl;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CATEGORY_PRODUCT_XREF")
@AdminPresentationClass(excludeFromPolymorphism=false)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCategories")
@DirectCopyTransform(value={@DirectCopyTransformMember(templateTokens={"sandbox"}, skipOverlaps=true), @DirectCopyTransformMember(templateTokens={"multiTenantCatalog"})})
public class CategoryProductXrefImpl
implements CategoryProductXref {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CategoryProductId")
    @GenericGenerator(name="CategoryProductId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CategoryProductXrefImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.catalog.domain.CategoryProductXrefImpl")})
    @Column(name="CATEGORY_PRODUCT_ID")
    protected Long id;
    @ManyToOne(targetEntity=CategoryImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="CATEGORY_ID")
    protected Category category = new CategoryImpl();
    @ManyToOne(targetEntity=ProductImpl.class, optional=false, cascade={CascadeType.REFRESH})
    @JoinColumn(name="PRODUCT_ID")
    protected Product product = new ProductImpl();
    @Column(name="DISPLAY_ORDER", precision=10, scale=6)
    @AdminPresentation(visibility=VisibilityEnum.HIDDEN_ALL)
    protected BigDecimal displayOrder;

    @Override
    public BigDecimal getDisplayOrder() {
        return this.displayOrder;
    }

    @Override
    public void setDisplayOrder(BigDecimal displayOrder) {
        this.displayOrder = displayOrder;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(Category category) {
        this.category = category;
    }

    @Override
    public Product getProduct() {
        return this.product;
    }

    @Override
    public void setProduct(Product product) {
        this.product = product;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(o.getClass())) {
            return false;
        }
        CategoryProductXrefImpl that = (CategoryProductXrefImpl)o;
        if (this.category != null ? !this.category.equals(that.category) : that.category != null) {
            return false;
        }
        return !(this.product != null ? !this.product.equals(that.product) : that.product != null);
    }

    public int hashCode() {
        int result = this.category != null ? this.category.hashCode() : 0;
        result = 31 * result + (this.product != null ? this.product.hashCode() : 0);
        return result;
    }

    public <G extends CategoryProductXref> CreateResponse<G> createOrRetrieveCopyInstance(MultiTenantCopyContext context) throws CloneNotSupportedException {
        CreateResponse createResponse = context.createOrRetrieveCopyInstance((Object)this);
        if (createResponse.isAlreadyPopulated()) {
            return createResponse;
        }
        CategoryProductXref cloned = (CategoryProductXref)createResponse.getClone();
        cloned.setDisplayOrder(this.displayOrder);
        if (this.product != null) {
            cloned.setProduct((Product)this.product.createOrRetrieveCopyInstance(context).getClone());
        }
        if (this.category != null) {
            cloned.setCategory((Category)this.category.createOrRetrieveCopyInstance(context).getClone());
        }
        return createResponse;
    }
}

