/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.broadleafcommerce.common.extension.ExtensionResultHolder;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.common.logging.SupportLogManager;
import org.broadleafcommerce.common.logging.SupportLogger;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.common.sandbox.SandBoxHelper;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.common.util.DateUtil;
import org.broadleafcommerce.common.util.DialectHelper;
import org.broadleafcommerce.common.util.dao.TypedQueryBuilder;
import org.broadleafcommerce.core.catalog.dao.SkuDao;
import org.broadleafcommerce.core.catalog.dao.SkuDaoExtensionHandler;
import org.broadleafcommerce.core.catalog.dao.SkuDaoExtensionManager;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuFee;
import org.broadleafcommerce.core.catalog.domain.SkuImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blSkuDao")
public class SkuDaoImpl
implements SkuDao {
    private static final SupportLogger logger = SupportLogManager.getLogger((String)"Enterprise", SkuDaoImpl.class);
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    @Resource(name="blSandBoxHelper")
    protected SandBoxHelper sandBoxHelper;
    @Resource(name="blDialectHelper")
    protected DialectHelper dialectHelper;
    @Resource(name="blSkuDaoExtensionManager")
    protected SkuDaoExtensionManager extensionManager;
    protected Long currentDateResolution = 10000L;
    protected Date cachedDate = SystemTime.asDate();

    @Override
    public Sku save(Sku sku) {
        return (Sku)this.em.merge((Object)sku);
    }

    @Override
    public SkuFee saveSkuFee(SkuFee fee) {
        return (SkuFee)this.em.merge((Object)fee);
    }

    @Override
    public Sku readSkuById(Long skuId) {
        return (Sku)this.em.find(SkuImpl.class, (Object)skuId);
    }

    @Override
    public Sku readSkuByExternalId(String externalId) {
        TypedQuery query = new TypedQueryBuilder(Sku.class, "sku").addRestriction("sku.externalId", "=", (Object)externalId).toQuery(this.em);
        try {
            return (Sku)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Sku readSkuByUpc(String upc) {
        TypedQuery query = new TypedQueryBuilder(Sku.class, "sku").addRestriction("sku.upc", "=", (Object)upc).toQuery(this.em);
        try {
            return (Sku)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public Sku readFirstSku() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_FIRST_SKU", Sku.class);
        return (Sku)query.getSingleResult();
    }

    @Override
    public List<Sku> readAllSkus() {
        TypedQuery query = this.em.createNamedQuery("BC_READ_ALL_SKUS", Sku.class);
        return query.getResultList();
    }

    @Override
    public List<Sku> readSkusByIds(List<Long> skuIds) {
        if (skuIds == null || skuIds.size() == 0) {
            return null;
        }
        if (skuIds.size() > 100) {
            logger.warn((Object)("Not recommended to use the readSkusByIds method for long lists of skuIds, since Hibernate is required to transform the distinct results. The list of requestedsku ids was (" + skuIds.size() + ") in length."));
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Sku.class);
        Root sku = criteria.from(SkuImpl.class);
        criteria.select((Selection)sku);
        criteria.where((Expression)sku.get("id").as(Long.class).in((Collection)this.sandBoxHelper.mergeCloneIds(SkuImpl.class, skuIds.toArray(new Long[skuIds.size()]))));
        if (!this.dialectHelper.isOracle() && !this.dialectHelper.isSqlServer()) {
            criteria.distinct(true);
        }
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.getResultList();
    }

    @Override
    public void delete(Sku sku) {
        if (!this.em.contains((Object)sku)) {
            sku = this.readSkuById(sku.getId());
        }
        this.em.remove((Object)sku);
    }

    @Override
    public Sku create() {
        return (Sku)this.entityConfiguration.createEntityInstance(Sku.class.getName());
    }

    @Override
    public Long readCountAllActiveSkus() {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readCountAllActiveSkusInternal(currentDate);
    }

    protected Long readCountAllActiveSkusInternal(Date currentDate) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Long.class);
        Root sku = criteria.from(SkuImpl.class);
        criteria.select((Selection)builder.count((Expression)sku));
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        restrictions.add(builder.lessThan(sku.get("activeStartDate").as(Date.class), (Comparable)currentDate));
        restrictions.add(builder.or((Expression)builder.isNull((Expression)sku.get("activeEndDate")), (Expression)builder.greaterThan(sku.get("activeEndDate").as(Date.class), (Comparable)currentDate)));
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return (Long)query.getSingleResult();
    }

    @Override
    public List<Sku> readAllActiveSkus(int page, int pageSize) {
        Date currentDate = DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution);
        return this.readAllActiveSkusInternal(page, pageSize, currentDate);
    }

    protected List<Sku> readAllActiveSkusInternal(int page, int pageSize, Date currentDate) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(Sku.class);
        Root sku = criteria.from(SkuImpl.class);
        criteria.select((Selection)sku);
        ArrayList<Predicate> restrictions = new ArrayList<Predicate>();
        restrictions.add(builder.lessThan(sku.get("activeStartDate").as(Date.class), (Comparable)currentDate));
        restrictions.add(builder.or((Expression)builder.isNull((Expression)sku.get("activeEndDate")), (Expression)builder.greaterThan(sku.get("activeEndDate").as(Date.class), (Comparable)currentDate)));
        criteria.where(restrictions.toArray(new Predicate[restrictions.size()]));
        int firstResult = page * pageSize;
        TypedQuery query = this.em.createQuery(criteria);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        return query.setFirstResult(firstResult).setMaxResults(pageSize).getResultList();
    }

    @Override
    public Long getCurrentDateResolution() {
        return this.currentDateResolution;
    }

    @Override
    public void setCurrentDateResolution(Long currentDateResolution) {
        this.currentDateResolution = currentDateResolution;
    }

    @Override
    public List<Sku> findSkuByURI(String uri) {
        if (this.extensionManager != null) {
            ExtensionResultHolder holder = new ExtensionResultHolder();
            ExtensionResultStatusType result = ((SkuDaoExtensionHandler)this.extensionManager.getProxy()).findSkuByURI(uri, holder);
            if (ExtensionResultStatusType.HANDLED.equals((Object)result)) {
                return (List)holder.getResult();
            }
        }
        String skuUrlKey = uri.substring(uri.lastIndexOf(47));
        String productUrl = uri.substring(0, uri.lastIndexOf(47));
        Query query = this.em.createNamedQuery("BC_READ_SKU_BY_OUTGOING_URL");
        query.setParameter("url", (Object)uri);
        query.setParameter("productUrl", (Object)productUrl);
        query.setParameter("skuUrlKey", (Object)skuUrlKey);
        query.setParameter("currentDate", (Object)DateUtil.getCurrentDateAfterFactoringInDateResolution((Date)this.cachedDate, (Long)this.currentDateResolution));
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Catalog");
        List results = query.getResultList();
        return results;
    }
}

