/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.catalog.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.core.catalog.dao.CategoryXrefDao;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.broadleafcommerce.core.catalog.domain.CategoryXrefImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blCategoryXrefDao")
public class CategoryXrefDaoImpl
implements CategoryXrefDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public List<CategoryXref> readXrefsByCategoryId(Long categoryId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CATEGORY_XREF_BY_CATEGORYID", CategoryXref.class);
        query.setParameter("categoryId", (Object)categoryId);
        return query.getResultList();
    }

    @Override
    public List<CategoryXref> readXrefsBySubCategoryId(Long subCategoryId) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CATEGORY_XREF_BY_SUBCATEGORYID", CategoryXref.class);
        query.setParameter("subCategoryId", (Object)subCategoryId);
        return query.getResultList();
    }

    @Override
    public CategoryXref readXrefByIds(Long categoryId, Long subCategoryId) {
        Query query = this.em.createNamedQuery("BC_READ_CATEGORY_XREF_BY_IDS");
        query.setParameter("categoryId", (Object)categoryId);
        query.setParameter("subCategoryId", (Object)subCategoryId);
        return (CategoryXref)query.getSingleResult();
    }

    @Override
    public CategoryXref save(CategoryXrefImpl categoryXref) {
        return (CategoryXref)this.em.merge((Object)categoryXref);
    }

    @Override
    public void delete(CategoryXref categoryXref) {
        if (!this.em.contains((Object)categoryXref)) {
            categoryXref = this.readXrefByIds(categoryXref.getCategory().getId(), categoryXref.getSubCategory().getId());
        }
        this.em.remove((Object)categoryXref);
    }

    @Override
    public CategoryProductXref save(CategoryProductXref categoryProductXref) {
        return (CategoryProductXref)this.em.merge((Object)categoryProductXref);
    }
}

