/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.dao.FulfillmentGroupItemDao;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.type.FulfillmentType;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.order.strategy.FulfillmentGroupItemStrategy;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.springframework.stereotype.Service;

@Service(value="blFulfillmentGroupItemStrategy")
public class FulfillmentGroupItemStrategyImpl
implements FulfillmentGroupItemStrategy {
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blFulfillmentGroupItemDao")
    protected FulfillmentGroupItemDao fgItemDao;
    protected boolean removeEmptyFulfillmentGroups = true;

    @Override
    public CartOperationRequest onItemAdded(CartOperationRequest request) throws PricingException {
        Order order = request.getOrder();
        OrderItem orderItem = request.getOrderItem();
        HashMap<FulfillmentType, FulfillmentGroup> fulfillmentGroups = new HashMap<FulfillmentType, FulfillmentGroup>();
        FulfillmentGroup nullFulfillmentTypeGroup = null;
        if (order.getFulfillmentGroups() != null) {
            for (FulfillmentGroup group : order.getFulfillmentGroups()) {
                if (group.getType() == null) {
                    if (nullFulfillmentTypeGroup != null) continue;
                    nullFulfillmentTypeGroup = group;
                    continue;
                }
                if (fulfillmentGroups.get(group.getType()) != null) continue;
                fulfillmentGroups.put(group.getType(), group);
            }
        }
        if (orderItem instanceof BundleOrderItem) {
            ArrayList<DiscreteOrderItem> itemsToAdd = new ArrayList<DiscreteOrderItem>(((BundleOrderItem)orderItem).getDiscreteOrderItems());
            for (DiscreteOrderItem doi : itemsToAdd) {
                FulfillmentGroup fulfillmentGroup = null;
                FulfillmentType type = this.resolveFulfillmentType(doi);
                if (type == null) {
                    fulfillmentGroup = nullFulfillmentTypeGroup;
                } else {
                    if (FulfillmentType.PHYSICAL_PICKUP_OR_SHIP.equals(type)) {
                        type = FulfillmentType.PHYSICAL_SHIP;
                    }
                    fulfillmentGroup = (FulfillmentGroup)fulfillmentGroups.get(type);
                }
                if (fulfillmentGroup == null) {
                    fulfillmentGroup = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
                    fulfillmentGroup.setType(type);
                    fulfillmentGroup.setOrder(order);
                    order.getFulfillmentGroups().add(fulfillmentGroup);
                }
                fulfillmentGroup = this.addItemToFulfillmentGroup(order, doi, doi.getQuantity() * orderItem.getQuantity(), fulfillmentGroup);
            }
        } else if (orderItem instanceof DiscreteOrderItem) {
            DiscreteOrderItem doi = (DiscreteOrderItem)orderItem;
            FulfillmentGroup fulfillmentGroup = null;
            FulfillmentType type = this.resolveFulfillmentType(doi);
            if (type == null) {
                fulfillmentGroup = nullFulfillmentTypeGroup;
            } else {
                if (FulfillmentType.PHYSICAL_PICKUP_OR_SHIP.equals(type)) {
                    type = FulfillmentType.PHYSICAL_SHIP;
                }
                fulfillmentGroup = (FulfillmentGroup)fulfillmentGroups.get(type);
            }
            if (fulfillmentGroup == null) {
                fulfillmentGroup = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
                fulfillmentGroup.setType(type);
                fulfillmentGroup.setOrder(order);
                order.getFulfillmentGroups().add(fulfillmentGroup);
            }
            fulfillmentGroup = this.addItemToFulfillmentGroup(order, orderItem, fulfillmentGroup);
            order = fulfillmentGroup.getOrder();
        } else {
            FulfillmentGroup fulfillmentGroup = nullFulfillmentTypeGroup;
            if (fulfillmentGroup == null) {
                fulfillmentGroup = this.fulfillmentGroupService.createEmptyFulfillmentGroup();
                fulfillmentGroup.setOrder(order);
                order.getFulfillmentGroups().add(fulfillmentGroup);
            }
            fulfillmentGroup = this.addItemToFulfillmentGroup(order, orderItem, fulfillmentGroup);
        }
        return request;
    }

    protected FulfillmentType resolveFulfillmentType(DiscreteOrderItem discreteOrderItem) {
        return this.resolveFulfillmentType(discreteOrderItem.getSku());
    }

    protected FulfillmentType resolveFulfillmentType(Sku sku) {
        if (sku.getFulfillmentType() != null) {
            return sku.getFulfillmentType();
        }
        if (sku.getDefaultProduct() != null && sku.getDefaultProduct().getDefaultCategory() != null) {
            return sku.getDefaultProduct().getDefaultCategory().getFulfillmentType();
        }
        return null;
    }

    protected FulfillmentGroup addItemToFulfillmentGroup(Order order, OrderItem orderItem, FulfillmentGroup fulfillmentGroup) throws PricingException {
        return this.addItemToFulfillmentGroup(order, orderItem, orderItem.getQuantity(), fulfillmentGroup);
    }

    protected FulfillmentGroup addItemToFulfillmentGroup(Order order, OrderItem orderItem, int quantity, FulfillmentGroup fulfillmentGroup) throws PricingException {
        FulfillmentGroupItemRequest fulfillmentGroupItemRequest = new FulfillmentGroupItemRequest();
        fulfillmentGroupItemRequest.setOrder(order);
        fulfillmentGroupItemRequest.setOrderItem(orderItem);
        fulfillmentGroupItemRequest.setQuantity(quantity);
        fulfillmentGroupItemRequest.setFulfillmentGroup(fulfillmentGroup);
        return this.fulfillmentGroupService.addItemToFulfillmentGroup(fulfillmentGroupItemRequest, false, false);
    }

    @Override
    public CartOperationRequest onItemUpdated(CartOperationRequest request) throws PricingException {
        Order order = request.getOrder();
        OrderItem orderItem = request.getOrderItem();
        Integer orderItemQuantityDelta = request.getOrderItemQuantityDelta();
        if (orderItemQuantityDelta == 0) {
            return request;
        }
        ArrayList<FulfillmentGroupItem> fgisToDelete = new ArrayList<FulfillmentGroupItem>();
        if (orderItem instanceof BundleOrderItem) {
            ArrayList<DiscreteOrderItem> itemsToUpdate = new ArrayList<DiscreteOrderItem>(((BundleOrderItem)orderItem).getDiscreteOrderItems());
            for (OrderItem orderItem2 : itemsToUpdate) {
                int quantityPer = orderItem2.getQuantity();
                fgisToDelete.addAll(this.updateItemQuantity(order, orderItem2, quantityPer * orderItemQuantityDelta));
            }
        } else {
            fgisToDelete.addAll(this.updateItemQuantity(order, orderItem, orderItemQuantityDelta));
        }
        request.setFgisToDelete(fgisToDelete);
        return request;
    }

    protected List<FulfillmentGroupItem> updateItemQuantity(Order order, OrderItem orderItem, Integer orderItemQuantityDelta) throws PricingException {
        ArrayList<FulfillmentGroupItem> fgisToDelete = new ArrayList<FulfillmentGroupItem>();
        boolean done = false;
        if (orderItemQuantityDelta > 0) {
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                for (FulfillmentGroupItem fgItem : fg.getFulfillmentGroupItems()) {
                    if (done || !fgItem.getOrderItem().equals(orderItem)) continue;
                    fgItem.setQuantity(fgItem.getQuantity() + orderItemQuantityDelta);
                    done = true;
                }
            }
        } else {
            int remainingToDecrement = -1 * orderItemQuantityDelta;
            for (FulfillmentGroup fg : order.getFulfillmentGroups()) {
                for (FulfillmentGroupItem fgItem : fg.getFulfillmentGroupItems()) {
                    if (!fgItem.getOrderItem().equals(orderItem)) continue;
                    if (!done && fgItem.getQuantity() == remainingToDecrement) {
                        fgisToDelete.add(fgItem);
                        done = true;
                        continue;
                    }
                    if (!done && fgItem.getQuantity() > remainingToDecrement) {
                        fgItem.setQuantity(fgItem.getQuantity() - remainingToDecrement);
                        done = true;
                        continue;
                    }
                    if (done) continue;
                    remainingToDecrement -= fgItem.getQuantity();
                    fgisToDelete.add(fgItem);
                }
            }
        }
        if (!done) {
            throw new IllegalStateException("Could not find matching fulfillment group item for the given order item");
        }
        return fgisToDelete;
    }

    @Override
    public CartOperationRequest onItemRemoved(CartOperationRequest request) {
        Order order = request.getOrder();
        OrderItem orderItem = request.getOrderItem();
        if (orderItem instanceof BundleOrderItem) {
            ArrayList<DiscreteOrderItem> itemsToRemove = new ArrayList<DiscreteOrderItem>(((BundleOrderItem)orderItem).getDiscreteOrderItems());
            for (OrderItem orderItem2 : itemsToRemove) {
                request.getFgisToDelete().addAll(this.fulfillmentGroupService.getFulfillmentGroupItemsForOrderItem(order, orderItem2));
            }
        } else {
            request.getFgisToDelete().addAll(this.fulfillmentGroupService.getFulfillmentGroupItemsForOrderItem(order, orderItem));
        }
        return request;
    }

    @Override
    public CartOperationRequest verify(CartOperationRequest request) throws PricingException {
        Order order = request.getOrder();
        if (this.isRemoveEmptyFulfillmentGroups() && order.getFulfillmentGroups() != null) {
            ListIterator<FulfillmentGroup> fgIter = order.getFulfillmentGroups().listIterator();
            while (fgIter.hasNext()) {
                FulfillmentGroup fg = fgIter.next();
                if (fg.getFulfillmentGroupItems() != null && fg.getFulfillmentGroupItems().size() != 0) continue;
                fgIter.remove();
                this.fulfillmentGroupService.delete(fg);
            }
        }
        HashMap<Long, Integer> oiQuantityMap = new HashMap<Long, Integer>();
        ArrayList<OrderItem> expandedOrderItems = new ArrayList<OrderItem>();
        for (OrderItem orderItem : order.getOrderItems()) {
            if (orderItem instanceof BundleOrderItem) {
                for (DiscreteOrderItem doi : ((BundleOrderItem)orderItem).getDiscreteOrderItems()) {
                    expandedOrderItems.add(doi);
                }
                continue;
            }
            if (orderItem instanceof DiscreteOrderItem) {
                expandedOrderItems.add(orderItem);
                continue;
            }
            expandedOrderItems.add(orderItem);
        }
        for (OrderItem orderItem : expandedOrderItems) {
            Integer oiQuantity = (Integer)oiQuantityMap.get(orderItem.getId());
            if (oiQuantity == null) {
                oiQuantity = 0;
            }
            oiQuantity = orderItem instanceof DiscreteOrderItem && ((DiscreteOrderItem)orderItem).getBundleOrderItem() != null ? Integer.valueOf(oiQuantity + ((DiscreteOrderItem)orderItem).getBundleOrderItem().getQuantity() * orderItem.getQuantity()) : Integer.valueOf(oiQuantity + orderItem.getQuantity());
            oiQuantityMap.put(orderItem.getId(), oiQuantity);
        }
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fgi : fulfillmentGroup.getFulfillmentGroupItems()) {
                Long oiId = fgi.getOrderItem().getId();
                Integer oiQuantity = (Integer)oiQuantityMap.get(oiId);
                if (oiQuantity == null) {
                    throw new IllegalStateException("Fulfillment group items and discrete order items are not in sync. DiscreteOrderItem id: " + oiId);
                }
                oiQuantity = oiQuantity - fgi.getQuantity();
                oiQuantityMap.put(oiId, oiQuantity);
            }
        }
        for (Map.Entry entry : oiQuantityMap.entrySet()) {
            if (((Integer)entry.getValue()).equals(0)) continue;
            throw new IllegalStateException("Not enough fulfillment group items found for DiscreteOrderItem id: " + entry.getKey());
        }
        return request;
    }

    @Override
    public boolean isRemoveEmptyFulfillmentGroups() {
        return this.removeEmptyFulfillmentGroups;
    }

    @Override
    public void setRemoveEmptyFulfillmentGroups(boolean removeEmptyFulfillmentGroups) {
        this.removeEmptyFulfillmentGroups = removeEmptyFulfillmentGroups;
    }
}

