/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service.workflow;

import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.extension.ExtensionResultStatusType;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.inventory.service.InventoryService;
import org.broadleafcommerce.core.inventory.service.InventoryUnavailableException;
import org.broadleafcommerce.core.inventory.service.type.InventoryType;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.workflow.CartOperationRequest;
import org.broadleafcommerce.core.order.service.workflow.WorkflowInventoryExtensionHandler;
import org.broadleafcommerce.core.order.service.workflow.WorkflowInventoryExtensionManager;
import org.broadleafcommerce.core.workflow.BaseActivity;
import org.broadleafcommerce.core.workflow.ProcessContext;

public class CheckAvailabilityActivity
extends BaseActivity<ProcessContext<CartOperationRequest>> {
    private static final Log LOG = LogFactory.getLog(CheckAvailabilityActivity.class);
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blInventoryService")
    protected InventoryService inventoryService;
    @Resource(name="blWorkflowInventoryExtensionManager")
    protected WorkflowInventoryExtensionManager extensionManager;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public ProcessContext<CartOperationRequest> execute(ProcessContext<CartOperationRequest> context) throws Exception {
        Sku sku;
        CartOperationRequest request = context.getSeedData();
        Long orderItemId = request.getItemRequest().getOrderItemId();
        if (orderItemId != null) {
            OrderItem orderItem = this.orderItemService.readOrderItemById(orderItemId);
            if (orderItem instanceof DiscreteOrderItem) {
                sku = ((DiscreteOrderItem)orderItem).getSku();
            } else {
                if (!(orderItem instanceof BundleOrderItem)) {
                    LOG.warn((Object)("Could not check availability; did not recognize passed-in item " + orderItem.getClass().getName()));
                    return context;
                }
                sku = ((BundleOrderItem)orderItem).getSku();
            }
        } else {
            Long skuId = request.getItemRequest().getSkuId();
            sku = this.catalogService.findSkuById(skuId);
        }
        if (!sku.isAvailable().booleanValue()) {
            throw new InventoryUnavailableException("The referenced Sku " + sku.getId() + " is marked as unavailable", sku.getId(), request.getItemRequest().getQuantity(), 0);
        }
        if (InventoryType.CHECK_QUANTITY.equals(sku.getInventoryType())) {
            boolean available;
            Integer requestedQuantity = request.getItemRequest().getQuantity();
            ExtensionResultStatusType status = ((WorkflowInventoryExtensionHandler)this.extensionManager.getProxy()).checkAvailability(sku, requestedQuantity, context);
            if (ExtensionResultStatusType.NOT_HANDLED.equals((Object)status) && !(available = this.isInventoryAvailable(sku, requestedQuantity, context))) {
                throw new InventoryUnavailableException(sku.getId(), requestedQuantity, this.inventoryService.retrieveQuantityAvailable(sku));
            }
        }
        return context;
    }

    protected boolean isInventoryAvailable(Sku sku, Integer quantity, ProcessContext<CartOperationRequest> context) {
        return this.inventoryService.isAvailable(sku, quantity);
    }
}

