/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.order.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.broadleafcommerce.core.order.dao.OrderMultishipOptionDao;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderMultishipOption;
import org.broadleafcommerce.core.order.domain.OrderMultishipOptionImpl;
import org.broadleafcommerce.core.order.service.FulfillmentGroupService;
import org.broadleafcommerce.core.order.service.FulfillmentOptionService;
import org.broadleafcommerce.core.order.service.OrderItemService;
import org.broadleafcommerce.core.order.service.OrderMultishipOptionService;
import org.broadleafcommerce.core.order.service.call.OrderMultishipOptionDTO;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.springframework.stereotype.Service;

@Service(value="blOrderMultishipOptionService")
public class OrderMultishipOptionServiceImpl
implements OrderMultishipOptionService {
    @Resource(name="blOrderMultishipOptionDao")
    OrderMultishipOptionDao orderMultishipOptionDao;
    @Resource(name="blAddressService")
    protected AddressService addressService;
    @Resource(name="blOrderItemService")
    protected OrderItemService orderItemService;
    @Resource(name="blFulfillmentOptionService")
    protected FulfillmentOptionService fulfillmentOptionService;
    @Resource(name="blFulfillmentGroupService")
    protected FulfillmentGroupService fulfillmentGroupService;

    @Override
    public OrderMultishipOption save(OrderMultishipOption orderMultishipOption) {
        return this.orderMultishipOptionDao.save(orderMultishipOption);
    }

    @Override
    public List<OrderMultishipOption> findOrderMultishipOptions(Long orderId) {
        return this.orderMultishipOptionDao.readOrderMultishipOptions(orderId);
    }

    @Override
    public List<OrderMultishipOption> findOrderItemOrderMultishipOptions(Long orderItemId) {
        return this.orderMultishipOptionDao.readOrderItemOrderMultishipOptions(orderItemId);
    }

    @Override
    public OrderMultishipOption create() {
        return this.orderMultishipOptionDao.create();
    }

    @Override
    public void deleteOrderItemOrderMultishipOptions(Long orderItemId) {
        List<OrderMultishipOption> options = this.findOrderItemOrderMultishipOptions(orderItemId);
        this.orderMultishipOptionDao.deleteAll(options);
    }

    @Override
    public void deleteOrderItemOrderMultishipOptions(Long orderItemId, int numToDelete) {
        List<OrderMultishipOption> options = this.findOrderItemOrderMultishipOptions(orderItemId);
        numToDelete = numToDelete > options.size() ? options.size() : numToDelete;
        options = options.subList(0, numToDelete);
        this.orderMultishipOptionDao.deleteAll(options);
    }

    @Override
    public void deleteAllOrderMultishipOptions(Order order) {
        List<OrderMultishipOption> options = this.findOrderMultishipOptions(order.getId());
        this.orderMultishipOptionDao.deleteAll(options);
    }

    @Override
    public void saveOrderMultishipOptions(Order order, List<OrderMultishipOptionDTO> optionDTOs) {
        HashMap<Long, OrderMultishipOption> currentOptions = new HashMap<Long, OrderMultishipOption>();
        for (OrderMultishipOption option : this.findOrderMultishipOptions(order.getId())) {
            currentOptions.put(option.getId(), option);
        }
        ArrayList<OrderMultishipOption> orderMultishipOptions = new ArrayList<OrderMultishipOption>();
        for (OrderMultishipOptionDTO dto : optionDTOs) {
            OrderMultishipOption option = (OrderMultishipOption)currentOptions.get(dto.getId());
            if (option == null) {
                option = this.orderMultishipOptionDao.create();
            }
            option.setOrder(order);
            option.setOrderItem(this.orderItemService.readOrderItemById(dto.getOrderItemId()));
            if (dto.getAddressId() != null) {
                option.setAddress(this.addressService.readAddressById(dto.getAddressId()));
            } else {
                option.setAddress(null);
            }
            if (dto.getFulfillmentOptionId() != null) {
                option.setFulfillmentOption(this.fulfillmentOptionService.readFulfillmentOptionById(dto.getFulfillmentOptionId()));
            } else {
                option.setFulfillmentOption(null);
            }
            orderMultishipOptions.add(option);
        }
        for (OrderMultishipOption option : orderMultishipOptions) {
            this.save(option);
        }
    }

    @Override
    public List<OrderMultishipOption> getOrGenerateOrderMultishipOptions(Order order) {
        List<OrderMultishipOption> orderMultishipOptions = this.findOrderMultishipOptions(order.getId());
        if (orderMultishipOptions == null || orderMultishipOptions.size() == 0) {
            orderMultishipOptions = this.generateOrderMultishipOptions(order);
        }
        HashMap<Long, Integer> orderDiscreteOrderItemCounts = new HashMap<Long, Integer>();
        for (DiscreteOrderItem item : order.getDiscreteOrderItems()) {
            orderDiscreteOrderItemCounts.put(item.getId(), item.getQuantity());
        }
        ArrayList<OrderMultishipOption> optionsToRemove = new ArrayList<OrderMultishipOption>();
        for (OrderMultishipOption orderMultishipOption : orderMultishipOptions) {
            Integer count = (Integer)orderDiscreteOrderItemCounts.get(orderMultishipOption.getOrderItem().getId());
            if (count == null || count == 0) {
                optionsToRemove.add(orderMultishipOption);
                continue;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count - 1);
            orderDiscreteOrderItemCounts.put(orderMultishipOption.getOrderItem().getId(), count);
        }
        for (Map.Entry entry : orderDiscreteOrderItemCounts.entrySet()) {
            DiscreteOrderItem item = (DiscreteOrderItem)this.orderItemService.readOrderItemById((Long)entry.getKey());
            orderMultishipOptions.addAll(this.createPopulatedOrderMultishipOption(order, item, (Integer)entry.getValue()));
        }
        orderMultishipOptions.removeAll(optionsToRemove);
        this.orderMultishipOptionDao.deleteAll(optionsToRemove);
        return orderMultishipOptions;
    }

    @Override
    public List<OrderMultishipOption> getOrderMultishipOptionsFromDTOs(Order order, List<OrderMultishipOptionDTO> optionDtos) {
        ArrayList<OrderMultishipOption> orderMultishipOptions = new ArrayList<OrderMultishipOption>();
        for (OrderMultishipOptionDTO optionDto : optionDtos) {
            OrderMultishipOptionImpl option = new OrderMultishipOptionImpl();
            if (optionDto.getAddressId() != null) {
                option.setAddress(this.addressService.readAddressById(optionDto.getAddressId()));
            }
            if (optionDto.getFulfillmentOptionId() != null) {
                option.setFulfillmentOption(this.fulfillmentOptionService.readFulfillmentOptionById(optionDto.getFulfillmentOptionId()));
            }
            option.setId(optionDto.getId());
            option.setOrder(order);
            option.setOrderItem(this.orderItemService.readOrderItemById(optionDto.getOrderItemId()));
            orderMultishipOptions.add(option);
        }
        return orderMultishipOptions;
    }

    @Override
    public List<OrderMultishipOption> generateOrderMultishipOptions(Order order) {
        ArrayList<OrderMultishipOption> orderMultishipOptions = new ArrayList<OrderMultishipOption>();
        for (DiscreteOrderItem discreteOrderItem : order.getDiscreteOrderItems()) {
            orderMultishipOptions.addAll(this.createPopulatedOrderMultishipOption(order, discreteOrderItem, discreteOrderItem.getQuantity()));
        }
        return orderMultishipOptions;
    }

    protected List<OrderMultishipOption> createPopulatedOrderMultishipOption(Order order, DiscreteOrderItem item, Integer quantity) {
        ArrayList<OrderMultishipOption> orderMultishipOptions = new ArrayList<OrderMultishipOption>();
        if (!this.fulfillmentGroupService.isShippable(item.getSku().getFulfillmentType())) {
            return orderMultishipOptions;
        }
        for (int i = 0; i < quantity; ++i) {
            OrderMultishipOptionImpl orderMultishipOption = new OrderMultishipOptionImpl();
            orderMultishipOption.setOrder(order);
            orderMultishipOption.setOrderItem(item);
            orderMultishipOptions.add(orderMultishipOption);
        }
        return orderMultishipOptions;
    }
}

